/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.file;

import gnu.classpath.SystemProperties;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class Connection
extends URLConnection {
    private static final String DEFAULT_PERMISSION = "read";
    private File file;
    private byte[] directoryListing;
    private InputStream inputStream;
    private OutputStream outputStream;
    private FilePermission permission = new FilePermission(this.getURL().getFile(), "read");

    public Connection(URL url) {
        super(url);
    }

    public static String unquote(String str) throws MalformedURLException {
        if (str == null) {
            return null;
        }
        byte[] buf = new byte[str.length() * 3];
        int pos = 0;
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c == '%') {
                int lo;
                if (i + 2 >= str.length()) {
                    throw new MalformedURLException(String.valueOf(str) + " : Invalid quoted character");
                }
                int hi = Character.digit(str.charAt(++i), 16);
                if ((lo = Character.digit(str.charAt(++i), 16)) < 0 || hi < 0) {
                    throw new MalformedURLException(String.valueOf(str) + " : Invalid quoted character");
                }
                buf[pos++] = (byte)(hi * 16 + lo);
            } else if (c > '\u007f') {
                try {
                    byte[] c_as_bytes = Character.toString(c).getBytes("utf-8");
                    int c_length = c_as_bytes.length;
                    System.arraycopy(c_as_bytes, 0, buf, pos, c_length);
                    pos += c_length;
                }
                catch (UnsupportedEncodingException x2) {
                    throw (Error)new InternalError().initCause(x2);
                }
            } else {
                buf[pos++] = (byte)c;
            }
            ++i;
        }
        try {
            return new String(buf, 0, pos, "utf-8");
        }
        catch (UnsupportedEncodingException x2) {
            throw (Error)new InternalError().initCause(x2);
        }
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.file = new File(Connection.unquote(this.getURL().getFile()));
        if (!this.file.isDirectory()) {
            if (this.doInput) {
                this.inputStream = new BufferedInputStream(new FileInputStream(this.file));
            }
            if (this.doOutput) {
                this.outputStream = new BufferedOutputStream(new FileOutputStream(this.file));
            }
        } else {
            if (this.doInput) {
                this.inputStream = new ByteArrayInputStream(this.getDirectoryListing());
            }
            if (this.doOutput) {
                throw new ProtocolException("file: protocol does not support output on directories");
            }
        }
        this.connected = true;
    }

    byte[] getDirectoryListing() throws IOException {
        if (this.directoryListing == null) {
            ByteArrayOutputStream sink = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(sink);
            String[] files = this.file.list();
            int i = 0;
            while (i < files.length) {
                writer.write(files[i]);
                writer.write(StaticData.lineSeparator);
                ++i;
            }
            this.directoryListing = sink.toByteArray();
        }
        return this.directoryListing;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.doInput) {
            throw new ProtocolException("Can't open InputStream if doInput is false");
        }
        if (!this.connected) {
            this.connect();
        }
        return this.inputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.doOutput) {
            throw new ProtocolException("Can't open OutputStream if doOutput is false");
        }
        if (!this.connected) {
            this.connect();
        }
        return this.outputStream;
    }

    public long getLastModified() {
        try {
            if (!this.connected) {
                this.connect();
            }
            return this.file.lastModified();
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHeaderField(String field) {
        try {
            if (!this.connected) {
                this.connect();
            }
            if (field.equals("content-type")) {
                return Connection.guessContentTypeFromName(this.file.getName());
            }
            if (field.equals("content-length")) {
                if (this.file.isDirectory()) {
                    return Integer.toString(this.getContentLength());
                }
                return Long.toString(this.file.length());
            }
            if (field.equals("last-modified")) {
                SimpleDateFormat simpleDateFormat = StaticData.dateFormat;
                synchronized (simpleDateFormat) {
                    return StaticData.dateFormat.format(new Date(this.file.lastModified()));
                }
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    public int getContentLength() {
        try {
            if (!this.connected) {
                this.connect();
            }
            if (this.file.isDirectory()) {
                return this.getDirectoryListing().length;
            }
            return (int)this.file.length();
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    public Permission getPermission() throws IOException {
        return this.permission;
    }

    private static class StaticData {
        static SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy hh:mm:ss 'GMT'", new Locale("En", "Us", "Unix"));
        static String lineSeparator = SystemProperties.getProperty("line.separator");

        private StaticData() {
        }
    }
}

