/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.ui.internal.search.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.wst.common.core.search.scope.SearchScope;
import org.eclipse.wst.common.ui.internal.Messages;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSearchListDialogConfiguration;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSpecification;
import org.eclipse.wst.common.ui.internal.search.dialogs.IComponentDescriptionProvider;
import org.eclipse.wst.common.ui.internal.search.dialogs.IComponentList;
import org.eclipse.wst.common.ui.internal.search.dialogs.INewComponentHandler;

public class ComponentSearchListDialog
extends Dialog {
    private Display display = Display.getCurrent();
    private String dialogTitle;
    protected ComponentSearchListDialogConfiguration configuration;
    private List componentTableViewerInput;
    private List masterComponentList;
    protected Composite topComposite;
    protected Composite bottomComposite;
    private Text textFilter;
    protected TableViewer componentTableViewer;
    protected String fileLocationLabel = Messages._UI_LABEL_DECLARATION_LOCATION;
    protected ViewForm fileLocationView;
    protected CLabel locationLabel;
    private TableItem prevItem;
    private String prevItemText;
    protected Object componentSelection;
    protected Object qualifierTextSelection;
    protected ToolBar filterToolBar;
    protected ToolItem toolItem;
    protected MenuManager fMenuManager;
    protected HashMap TableDecoratorTrackingTool = new HashMap();
    private Button newButton;
    private DelayedEvent delayedEvent;

    public ComponentSearchListDialog(Shell shell, String dialogTitle, ComponentSearchListDialogConfiguration configuration) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.dialogTitle = dialogTitle;
        this.configuration = configuration;
        this.componentTableViewerInput = new ArrayList();
        this.masterComponentList = new ArrayList();
        configuration.init(this);
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
        this.setTextFilterFocus();
    }

    protected void setTextFilterFocus() {
        this.textFilter.setFocus();
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.dialogTitle);
        Composite mainComposite = (Composite)super.createDialogArea(parent);
        GridData gData = (GridData)mainComposite.getLayoutData();
        gData.heightHint = 500;
        gData.widthHint = 400;
        this.configuration.createWidgetAboveQualifierBox(mainComposite);
        Composite filterLabelAndText = new Composite(mainComposite, 0);
        GridLayout layoutFilterLabelAndText = new GridLayout(2, false);
        layoutFilterLabelAndText.marginWidth = 0;
        layoutFilterLabelAndText.marginHeight = 0;
        filterLabelAndText.setLayoutData((Object)new GridData(768));
        filterLabelAndText.setLayout((Layout)layoutFilterLabelAndText);
        Label filterLabel = new Label(filterLabelAndText, 0);
        filterLabel.setText(this.configuration.getFilterLabelText());
        GridData filterLabelData = new GridData();
        filterLabelData.horizontalSpan = 2;
        filterLabel.setLayoutData((Object)filterLabelData);
        this.textFilter = new Text(filterLabelAndText, 2052);
        this.textFilter.setLayoutData((Object)new GridData(768));
        this.textFilter.addModifyListener((ModifyListener)new TextFilterModifyAdapter());
        GridData textFilterData = new GridData();
        textFilterData.horizontalAlignment = 4;
        textFilterData.grabExcessHorizontalSpace = true;
        this.textFilter.setLayoutData((Object)textFilterData);
        final INewComponentHandler handler = this.configuration.getNewComponentHandler();
        if (handler != null) {
            this.newButton = new Button(filterLabelAndText, 0);
            this.newButton.setText(Messages._UI_LABEL_New);
            this.newButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    handler.openNewComponentDialog();
                }

                public void widgetSelected(SelectionEvent e) {
                    handler.openNewComponentDialog();
                }
            });
        }
        this.createComponentTableViewer(mainComposite);
        this.configuration.createWidgetAboveQualifierBox(mainComposite);
        Label qualifierLabel = new Label(mainComposite, 0);
        qualifierLabel.setText(Messages._UI_LABEL_QUALIFIER);
        qualifierLabel.setText(this.fileLocationLabel);
        this.fileLocationView = new ViewForm(mainComposite, 0x800800);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.heightHint = 22;
        this.fileLocationView.setLayoutData((Object)data);
        this.locationLabel = new CLabel((Composite)this.fileLocationView, 0x800000);
        this.fileLocationView.setContent((Control)this.locationLabel);
        this.locationLabel.setFont(this.fileLocationView.getFont());
        this.configuration.createWidgetBelowQualifierBox(mainComposite);
        this.bottomComposite = new Composite(mainComposite, 0);
        this.bottomComposite.setLayoutData((Object)new GridData(768));
        this.bottomComposite.setLayout((Layout)new GridLayout());
        this.componentTableViewer.setContentProvider((IContentProvider)new ComponentTableContentProvider());
        this.componentTableViewer.setLabelProvider((IBaseLabelProvider)this.configuration.getDescriptionProvider().getLabelProvider());
        this.componentTableViewer.setSorter(new ViewerSorter());
        this.componentTableViewer.setInput((Object)this.componentTableViewerInput);
        this.populateMasterComponentList(null);
        this.refreshTableViewer("");
        return mainComposite;
    }

    private void createComponentTableViewer(Composite base) {
        this.componentTableViewer = this.createFilterMenuAndTableViewer(base);
        this.componentTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ComponentSearchListDialog.this.updateCanFinish();
            }
        });
        this.componentTableViewer.getTable().addSelectionListener(new SelectionListener(){
            IComponentDescriptionProvider descriptionProvider;
            {
                this.descriptionProvider = ComponentSearchListDialog.this.configuration.getDescriptionProvider();
            }

            public void widgetSelected(SelectionEvent e) {
                this.run();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            private void run() {
                if (ComponentSearchListDialog.this.prevItem != null && !ComponentSearchListDialog.this.prevItem.isDisposed()) {
                    ComponentSearchListDialog.this.prevItem.setText(ComponentSearchListDialog.this.prevItemText);
                }
                TableItem[] items = ComponentSearchListDialog.this.componentTableViewer.getTable().getSelection();
                Object component = items[0].getData();
                ComponentSearchListDialog.this.prevItem = items[0];
                ComponentSearchListDialog.this.prevItemText = items[0].getText();
                items[0].setText(String.valueOf(this.descriptionProvider.getName(component)) + " - " + this.descriptionProvider.getQualifier(component));
                ComponentSearchListDialog.this.updateLocationView(component, this.descriptionProvider);
            }
        });
        this.componentTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ComponentSearchListDialog.this.okPressed();
            }
        });
    }

    protected TableViewer createFilterMenuAndTableViewer(Composite comp) {
        Composite labelAndFilter = new Composite(comp, 0);
        labelAndFilter.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        labelAndFilter.setLayout((Layout)layout);
        Label tableLabel = new Label(labelAndFilter, 0);
        tableLabel.setLayoutData((Object)new GridData(768));
        tableLabel.setText(this.configuration.getListLabelText());
        this.filterToolBar = new ToolBar(labelAndFilter, 0x800000);
        this.configuration.createToolBarItems(this.filterToolBar);
        TableViewer tableViewer = new TableViewer(new Table(labelAndFilter, 2052));
        Table TableWidget = tableViewer.getTable();
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        TableWidget.setLayoutData((Object)gd);
        return tableViewer;
    }

    private void updateLocationView(Object component, IComponentDescriptionProvider lp) {
        IFile file = lp.getFile(component);
        if (file == null) {
            this.locationLabel.setText("");
            this.locationLabel.setImage(null);
            return;
        }
        String filePath = "";
        filePath = file.getFullPath().toString();
        this.locationLabel.setText(filePath);
        this.locationLabel.setImage(lp.getFileIcon(component));
    }

    protected String getProcessedFilterString() {
        return this.processFilterString(this.textFilter.getText());
    }

    private String processFilterString(String inputString) {
        if (!inputString.equals("")) {
            inputString = this.insertString("*", ".", inputString);
            inputString = this.insertString("?", ".", inputString);
            inputString = String.valueOf(inputString) + ".*";
        } else {
            inputString = ".*";
        }
        return inputString.toLowerCase();
    }

    private String insertString(String target, String newString, String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int index = stringBuffer.indexOf(target);
        while (index != -1) {
            stringBuffer = stringBuffer.insert(index, newString);
            index = stringBuffer.indexOf(target, index + newString.length() + target.length());
        }
        return stringBuffer.toString();
    }

    protected void fireUpdateList(final ComponentList list) {
        Runnable runnable = new Runnable(){

            public void run() {
                int currentSize;
                int growingListSize = list.size();
                if (growingListSize > (currentSize = ComponentSearchListDialog.this.masterComponentList.size())) {
                    ComponentSearchListDialog.this.masterComponentList.addAll(list.subList(currentSize, growingListSize));
                }
                ComponentSearchListDialog.this.refreshTableViewer(ComponentSearchListDialog.this.getProcessedFilterString());
            }
        };
        this.display.asyncExec(runnable);
    }

    public void updateForFilterChange() {
        this.populateMasterComponentList(null);
        this.refreshTableViewer(this.getProcessedFilterString());
    }

    protected void populateMasterComponentList(final SearchScope searchScope) {
        this.masterComponentList.clear();
        final ComponentList componentList = new ComponentList();
        Job job = new Job("read components"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    long time1 = System.currentTimeMillis();
                    ComponentSearchListDialog.this.configuration.getSearchListProvider().populateComponentList(componentList, searchScope, null);
                    ComponentSearchListDialog.this.fireUpdateList(componentList);
                    long time2 = System.currentTimeMillis();
                    System.out.println("time=" + (time2 - time1) + " items= " + ComponentSearchListDialog.this.masterComponentList.size());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    protected void refreshTableViewer(String filterText) {
        this.componentTableViewerInput.clear();
        ILabelProvider labelProvider = this.configuration.getDescriptionProvider().getLabelProvider();
        Pattern regex = Pattern.compile(filterText);
        Iterator it = this.masterComponentList.iterator();
        while (it.hasNext()) {
            Object item = it.next();
            String itemString = labelProvider.getText(item);
            Matcher m = regex.matcher(itemString.toLowerCase());
            if (!itemString.toLowerCase().startsWith(filterText) && !m.matches()) continue;
            this.componentTableViewerInput.add(item);
        }
        this.componentTableViewer.refresh();
        this.decorateTable();
    }

    protected void decorateTable() {
        Integer count;
        this.TableDecoratorTrackingTool.clear();
        IComponentDescriptionProvider lp = this.configuration.getDescriptionProvider();
        int i = 0;
        while (i < this.componentTableViewerInput.size()) {
            Object currentItem = this.componentTableViewerInput.get(i);
            String name = lp.getName(currentItem);
            count = (Integer)this.TableDecoratorTrackingTool.get(name);
            if (count == null) {
                this.TableDecoratorTrackingTool.put(name, new Integer(1));
            } else {
                this.TableDecoratorTrackingTool.put(name, new Integer(count + 1));
            }
            ++i;
        }
        TableItem[] items = this.componentTableViewer.getTable().getItems();
        int i2 = 0;
        while (i2 < items.length) {
            Object currentItem = items[i2].getData();
            count = (Integer)this.TableDecoratorTrackingTool.get(lp.getName(currentItem));
            if (count != null && count > 1) {
                items[i2].setText(String.valueOf(lp.getName(currentItem)) + " - " + lp.getQualifier(currentItem));
            }
            ++i2;
        }
    }

    protected void updateCanFinish() {
        IStructuredSelection selection = (IStructuredSelection)this.componentTableViewer.getSelection();
        if (selection.getFirstElement() != null) {
            this.getButton(0).setEnabled(true);
        } else {
            this.getButton(0).setEnabled(false);
        }
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.componentTableViewer.getSelection();
        this.componentSelection = selection.getFirstElement();
        super.okPressed();
    }

    public ComponentSpecification getSelectedComponent() {
        ComponentSpecification result = null;
        if (this.componentSelection != null) {
            result = new ComponentSpecification();
            IComponentDescriptionProvider componentDescriptionProvider = this.configuration.getDescriptionProvider();
            result.setName(componentDescriptionProvider.getName(this.componentSelection));
            result.setQualifier(componentDescriptionProvider.getQualifier(this.componentSelection));
            result.setFile(componentDescriptionProvider.getFile(this.componentSelection));
            result.setObject(this.componentSelection);
        }
        return result;
    }

    class ComponentList
    implements IComponentList {
        private Vector objectVector = new Vector();
        private long currentChangeCounter = 0L;
        private long lastUpdateTime = 0L;

        ComponentList() {
        }

        public void add(Object o) {
            this.objectVector.add(o);
            ++this.currentChangeCounter;
            this.doViewerUpdate();
        }

        public void addAll(Collection collection) {
            this.objectVector.addAll(collection);
            this.currentChangeCounter += (long)collection.size();
            this.doViewerUpdate();
        }

        private void doViewerUpdate() {
            long time = System.currentTimeMillis();
            if (time - this.lastUpdateTime > 300L) {
                this.lastUpdateTime = time;
                ComponentSearchListDialog.this.fireUpdateList(this);
            }
        }

        public int size() {
            return this.objectVector.size();
        }

        public List subList(int startIndex, int endIndex) {
            return this.objectVector.subList(startIndex, endIndex);
        }

        public Iterator iterator() {
            return this.objectVector.iterator();
        }
    }

    private class ComponentTableContentProvider
    implements ITreeContentProvider {
        private ComponentTableContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof List) {
                return ((List)parentElement).toArray();
            }
            return new Object[0];
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private class DelayedEvent
    implements Runnable {
        public boolean CANCEL = false;

        private DelayedEvent() {
        }

        public void run() {
            if (!this.CANCEL) {
                ComponentSearchListDialog.this.refreshTableViewer(ComponentSearchListDialog.this.getProcessedFilterString());
                if (ComponentSearchListDialog.this.componentTableViewer.getTable().getItemCount() > 0) {
                    TableItem item = ComponentSearchListDialog.this.componentTableViewer.getTable().getItems()[0];
                    TableItem[] items = new TableItem[]{item};
                    ComponentSearchListDialog.this.componentTableViewer.getTable().setSelection(items);
                }
                ComponentSearchListDialog.this.updateCanFinish();
            }
        }
    }

    private class TextFilterModifyAdapter
    implements ModifyListener {
        private TextFilterModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            if (e.widget == ComponentSearchListDialog.this.textFilter) {
                if (ComponentSearchListDialog.this.delayedEvent != null) {
                    ((ComponentSearchListDialog)ComponentSearchListDialog.this).delayedEvent.CANCEL = true;
                }
                ComponentSearchListDialog.this.delayedEvent = new DelayedEvent();
                Display.getCurrent().timerExec(400, (Runnable)ComponentSearchListDialog.this.delayedEvent);
            }
        }
    }
}

