/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.plugin;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jem.internal.adapters.jdom.JavaClassJDOMAdaptor;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaPackage;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;

public class J2EEEditorUtility {
    public static final String EJB_JAVA_EDITOR_ID = "org.eclipse.jst.j2ee.internal.internal.ejb.ui.misc.EJBJavaEditor";
    static /* synthetic */ Class class$0;

    public static ICompilationUnit getCompilationUnit(JavaClass javaClass) {
        IProject project = ProjectUtilities.getProject((EObject)javaClass);
        if (project == null) {
            return null;
        }
        return J2EEEditorUtility.getCompilationUnit(javaClass, project);
    }

    public static ICompilationUnit getCompilationUnit(JavaClass javaClass, IProject project) {
        if (javaClass == null) {
            return null;
        }
        IJavaProject javaProj = J2EEEditorUtility.getJavaProject(project);
        if (javaProj == null) {
            return null;
        }
        return J2EEEditorUtility.getCompilationUnit(javaClass, javaProj);
    }

    public static ICompilationUnit getCompilationUnit(JavaClass javaClass, IJavaProject javaProject) {
        if (javaClass == null) {
            return null;
        }
        IType type = J2EEEditorUtility.getType(javaClass);
        if (type != null) {
            return type.getCompilationUnit();
        }
        return null;
    }

    public static IType getType(JavaClass javaClass) {
        JavaClassJDOMAdaptor adaptor;
        if (javaClass != null && (adaptor = (JavaClassJDOMAdaptor)EcoreUtil.getRegisteredAdapter((EObject)javaClass, (Object)"JavaReflection")) != null) {
            return adaptor.getSourceType();
        }
        return null;
    }

    public static IEditorInput getEditorInput(Object input) {
        if (input instanceof EObject) {
            return new FileEditorInput(WorkbenchResourceHelper.getFile((EObject)((EObject)input)));
        }
        if (input instanceof IFile) {
            return new FileEditorInput((IFile)input);
        }
        return null;
    }

    public static IFile getFile(JavaClass javaClass) {
        ICompilationUnit comp = J2EEEditorUtility.getCompilationUnit(javaClass);
        if (comp == null) {
            return null;
        }
        IEditorInput input = null;
        try {
            input = EditorUtility.getEditorInput((Object)comp);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        if (input != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IFile)input.getAdapter((Class)clazz);
        }
        return null;
    }

    public static IJavaProject getJavaProject(IProject aProject) {
        if (aProject == null) {
            return null;
        }
        IJavaModel javaModel = JemProjectUtilities.getJavaModel();
        return javaModel.getJavaProject(aProject.getName());
    }

    public static IPackageFragment getPackageFragment(JavaClass javaClass, IJavaProject javaProject) {
        if (javaProject != null) {
            try {
                JavaPackage javaPackage = (JavaPackage)javaClass.eContainer();
                String packageName = javaPackage.getName();
                IPackageFragment[] pkgFrags = javaProject.getPackageFragments();
                int i = 0;
                while (i < pkgFrags.length) {
                    if (pkgFrags[i].getElementName().equals(packageName)) {
                        return pkgFrags[i];
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }

    public static IEditorPart openInEditor(JavaClass javaClass, IProject aProject) throws JavaModelException, PartInitException {
        return J2EEEditorUtility.openInEditor(javaClass, J2EEEditorUtility.getJavaProject(aProject));
    }

    public static IEditorPart openInEditor(JavaClass javaClass, IJavaProject javaProject) throws JavaModelException, PartInitException {
        if (javaClass == null || javaProject == null) {
            return null;
        }
        IType type = J2EEEditorUtility.getType(javaClass);
        if (type == null) {
            return J2EEEditorUtility.openInEditor(J2EEEditorUtility.getCompilationUnit(javaClass, javaProject));
        }
        return EditorUtility.openInEditor((Object)type);
    }

    public static IEditorPart openInEditor(JavaClass javaClass, IJavaProject javaProject, String editorId) throws JavaModelException, PartInitException {
        return J2EEEditorUtility.openInEditor(J2EEEditorUtility.getCompilationUnit(javaClass, javaProject), editorId);
    }

    public static IEditorPart openInEditor(ICompilationUnit aCompilationUnit) throws JavaModelException, PartInitException {
        return EditorUtility.openInEditor((Object)aCompilationUnit);
    }

    public static IEditorPart openInEditor(ICompilationUnit aCompilationUnit, String editorId) throws JavaModelException, PartInitException {
        return J2EEEditorUtility.openInEditor(EditorUtility.getEditorInput((Object)aCompilationUnit), editorId);
    }

    private static IEditorPart openInEditor(IEditorInput input, String editorID) throws PartInitException {
        IWorkbenchPage p;
        if (input != null && (p = J2EEUIPlugin.getActiveWorkbenchWindow().getActivePage()) != null) {
            return p.openEditor(input, editorID, true);
        }
        return null;
    }
}

