/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.view.servers;

import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.PublishServerJob;
import org.eclipse.wst.server.core.internal.ServerPreferences;
import org.eclipse.wst.server.core.internal.ServerType;
import org.eclipse.wst.server.core.internal.StartServerJob;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.view.servers.AbstractServerAction;

public class StartAction
extends AbstractServerAction {
    protected String launchMode = "run";

    public StartAction(Shell shell, ISelectionProvider selectionProvider, String name, String launchMode) {
        super(shell, selectionProvider, name);
        this.launchMode = launchMode;
        try {
            this.selectionChanged((IStructuredSelection)selectionProvider.getSelection());
        }
        catch (Exception exception) {}
    }

    public boolean accept(IServer server) {
        return server.canStart(this.launchMode).isOK();
    }

    public void perform(IServer server) {
        if (!ServerUIPlugin.saveEditors()) {
            return;
        }
        if (!ServerPreferences.getInstance().isAutoPublishing()) {
            StartServerJob startJob = new StartServerJob(server, this.launchMode);
            startJob.schedule();
            return;
        }
        try {
            PublishServerJob publishJob = new PublishServerJob(server, 1, false);
            StartServerJob startJob = new StartServerJob(server, this.launchMode);
            if (((ServerType)server.getServerType()).startBeforePublish()) {
                startJob.setNextJob((Job)publishJob);
                startJob.schedule();
            } else {
                publishJob.setNextJob((Job)startJob);
                publishJob.schedule();
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error starting server", e);
        }
    }
}

