/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.emf.event.impl;

import com.ibm.etools.emf.event.EObjectDescriptor;
import com.ibm.etools.emf.event.Event;
import com.ibm.etools.emf.event.FeatureKind;
import com.ibm.etools.emf.event.NotifierKind;
import com.ibm.etools.emf.event.Setting;
import com.ibm.etools.emf.event.impl.EventHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class EventReaderHelper
extends EventHelper {
    private Map eventIdToEObjectMap = new HashMap();

    protected EventReaderHelper(Notifier topNotifier, ResourceSet defaultResourceSet) {
        super(topNotifier, defaultResourceSet);
    }

    public void createObjectsFromDescriptorList(Event e, EList templates, EList descriptors) {
        if (descriptors.size() > 0) {
            String eventId;
            EObjectDescriptor desc;
            ArrayList<EObject> newSourceEObjList = new ArrayList<EObject>();
            int d = 0;
            int size = descriptors.size();
            while (d < size) {
                desc = (EObjectDescriptor)descriptors.get(d);
                eventId = desc.getEventId();
                int t = desc.getEObjectPosition();
                EObject template = t == -1 ? null : (EObject)templates.get(t);
                EObject sourceEObj = (EObject)this.eventIdToEObjectMap.get(eventId);
                if (sourceEObj == null) {
                    newSourceEObjList.add(sourceEObj);
                    sourceEObj = EcoreUtil.create((EClass)template.eClass());
                    EventHelper.copyAttributes(sourceEObj, template);
                    this.rememberEventId(sourceEObj, eventId);
                    newSourceEObjList.add(sourceEObj);
                } else if (template != null) {
                    EventHelper.copyAttributes(sourceEObj, template);
                }
                ++d;
            }
            d = 0;
            size = descriptors.size();
            while (d < size) {
                desc = (EObjectDescriptor)descriptors.get(d);
                eventId = desc.getEventId();
                EList settings = desc.getSettings();
                EObject sourceEObj = (EObject)this.eventIdToEObjectMap.get(eventId);
                if (settings != null && settings.size() > 0) {
                    this.copyReferences(sourceEObj, settings, newSourceEObjList.contains(sourceEObj));
                }
                ++d;
            }
        }
    }

    public void rememberEventIdsInDescriptorList(Event e, EList templates, EList descriptors) {
        int d = 0;
        int size = descriptors.size();
        while (d < size) {
            EObjectDescriptor desc = (EObjectDescriptor)descriptors.get(d);
            String eventId = desc.getEventId();
            EObject sourceEObj = (EObject)this.eventIdToEObjectMap.get(eventId);
            if (sourceEObj != null) {
                EClass c = sourceEObj.eClass();
                EReference lastRef = null;
                EList settings = desc.getSettings();
                int j = 0;
                int settingSize = settings.size();
                while (j < settingSize) {
                    EReference ref;
                    Setting setting = (Setting)settings.get(j);
                    lastRef = ref = (EReference)c.getEStructuralFeature(setting.getRefName());
                    String val = setting.getValue();
                    if (this.isEventId(val) && !this.eventIdToEObjectMap.containsKey(val)) {
                        EObject targetEObj = null;
                        if (ref.isMany()) {
                            EList l = (EList)sourceEObj.eGet((EStructuralFeature)ref);
                            targetEObj = (EObject)l.get(setting.getPosition());
                        } else {
                            targetEObj = (EObject)sourceEObj.eGet((EStructuralFeature)ref);
                        }
                        this.rememberEventId(targetEObj, val);
                        if (!ref.isContainment()) {
                            ref.getEOpposite();
                        }
                    }
                    ++j;
                }
            }
            ++d;
        }
    }

    protected void copyReferences(EObject sourceEObj, EList settings, boolean isNewSourceObject) {
        EClass c = sourceEObj.eClass();
        int s = 0;
        int size = settings.size();
        while (s < size) {
            Setting setting = (Setting)settings.get(s);
            EReference ref = (EReference)c.getEStructuralFeature(setting.getRefName());
            String value = setting.getValue();
            EObject targetEObj = this.getEObjectFromString(value);
            if (ref.isMany()) {
                EList l = (EList)sourceEObj.eGet((EStructuralFeature)ref);
                if (l.contains((Object)targetEObj)) {
                    int pos = l.indexOf((Object)targetEObj);
                    if (pos != setting.getPosition()) {
                        l.move(setting.getPosition(), pos);
                    }
                } else {
                    l.add((Object)targetEObj);
                }
            } else {
                sourceEObj.eSet((EStructuralFeature)ref, (Object)targetEObj);
            }
            ++s;
        }
        if (!isNewSourceObject) {
            EList references = c.getEAllReferences();
            Iterator r = references.iterator();
            while (r.hasNext()) {
                EReference oRef = (EReference)r.next();
                if (!sourceEObj.eIsSet((EStructuralFeature)oRef)) continue;
                Object val = sourceEObj.eGet((EStructuralFeature)oRef);
                if (oRef.isMany()) {
                    EList list = (EList)val;
                    Iterator o = list.iterator();
                    while (o.hasNext()) {
                        EObject eObj = (EObject)o.next();
                        if (!this.isDeletedRef(sourceEObj, settings, oRef, eObj)) continue;
                        o.remove();
                    }
                    continue;
                }
                EObject eObj = (EObject)val;
                if (!this.isDeletedRef(sourceEObj, settings, oRef, eObj)) continue;
                sourceEObj.eUnset((EStructuralFeature)oRef);
            }
        }
    }

    protected boolean isDeletedRef(EObject sourceEObj, EList settings, EReference oRef, EObject val) {
        EClass c = sourceEObj.eClass();
        boolean foundSetting = false;
        int s = 0;
        int size = settings.size();
        while (!foundSetting && s < size) {
            String value;
            EObject sEObj;
            Setting setting = (Setting)settings.get(s);
            EReference sRef = (EReference)c.getEStructuralFeature(setting.getRefName());
            if (sRef.equals(oRef) && (sEObj = this.getEObjectFromString(value = setting.getValue())).equals(val)) {
                foundSetting = true;
            }
            ++s;
        }
        return !foundSetting;
    }

    public Object createFromString(Event e, String val) {
        Object objVal = null;
        if (val != null) {
            EStructuralFeature sf = this.getFeature(e);
            if (this.getFeatureKind(e) == FeatureKind.ATTRIBUTE_LITERAL) {
                EDataType sfType = (EDataType)sf.getEType();
                EFactory eFactory = sfType.getEPackage().getEFactoryInstance();
                objVal = eFactory.createFromString(sfType, val);
            } else {
                objVal = this.getEObjectFromString(val);
            }
        }
        return objVal;
    }

    public void setValue(Event e, Object val) {
        this.setValue(e, val, 0);
    }

    public void setValue(Event e, Object val, int pos) {
        Notifier n = e.getNotifier();
        EStructuralFeature sf = e.getFeature();
        if (this.getNotifierKind(e) == NotifierKind.RESOURCE_LITERAL) {
            if (pos != -1) {
                ((Resource)this.topNotifier).getContents().add(pos, val);
            } else {
                ((Resource)this.topNotifier).getContents().add(val);
            }
        } else if (sf.isMany()) {
            EList sfList = (EList)((EObject)n).eGet(sf);
            int index = sfList.indexOf(val);
            if (!sf.isUnique() || index == -1) {
                if (pos != -1) {
                    sfList.add(pos, val);
                } else {
                    sfList.add(val);
                }
            } else {
                sfList.move(pos, index);
            }
        } else {
            ((EObject)n).eSet(sf, val);
        }
    }

    public void unsetValue(Event e) {
        Notifier n = e.getNotifier();
        EStructuralFeature sf = e.getFeature();
        ((EObject)n).eUnset(sf);
    }

    public EObject getEObjectFromString(String value) {
        if (value == null) {
            return null;
        }
        if (this.isEventId(value)) {
            return (EObject)this.eventIdToEObjectMap.get(value);
        }
        return super.getEObjectFromURI(value);
    }

    public void rememberEventId(EObject obj, String id) {
        if (obj != null && id != null && this.isEventId(id) && !this.eventIdToEObjectMap.containsKey(id)) {
            this.eventIdToEObjectMap.put(id, obj);
        }
    }

    public void rememberAllEventIds(EList objList, EList subsetList, EList idList) {
        if (idList.size() == 0) {
            return;
        }
        if (subsetList.size() > 0) {
            int s = 0;
            int size = subsetList.size();
            while (s < size) {
                EObject oldVal = this.getEObjectFromString((String)idList.get(s));
                if (oldVal == null) {
                    int pos = (Integer)subsetList.get(s);
                    oldVal = (EObject)objList.get(pos);
                }
                this.rememberEventId(oldVal, (String)idList.get(s));
                ++s;
            }
        } else {
            int pos = 0;
            int size = objList.size();
            while (pos < size) {
                EObject oldVal = (EObject)objList.get(pos);
                this.rememberEventId(oldVal, (String)idList.get(pos));
                ++pos;
            }
        }
    }

    public void removeAll(EList list, EList posList, EList idList) {
        if (posList.size() > 0) {
            BasicEList removedList = new BasicEList(posList.size());
            int i = 0;
            int size = posList.size();
            while (i < size) {
                Object oldVal = null;
                if (idList.size() > 0) {
                    oldVal = this.getEObjectFromString((String)idList.get(i));
                }
                if (oldVal == null) {
                    int pos = (Integer)posList.get(i);
                    oldVal = list.get(pos);
                }
                removedList.add(oldVal);
                ++i;
            }
            list.removeAll((Collection)removedList);
        } else {
            list.clear();
        }
    }

    public void addAll(Event e, EList objList, EList posList) {
        if (posList.size() > 0) {
            int v = 0;
            int size = objList.size();
            while (v < size) {
                Integer pos = (Integer)posList.get(v);
                this.setValue(e, objList.get(v), pos);
                ++v;
            }
        } else {
            int v = 0;
            int size = objList.size();
            while (v < size) {
                this.setValue(e, objList.get(v), -1);
                ++v;
            }
        }
    }

    private static void clearReferences(EObject obj) {
        EClass c = obj.eClass();
        EList references = c.getEReferences();
        int r = 0;
        int size = references.size();
        while (r < size) {
            EReference ref = (EReference)references.get(r);
            if (ref.isMany()) {
                EList l = (EList)obj.eGet((EStructuralFeature)ref);
                l.clear();
            } else {
                obj.eUnset((EStructuralFeature)ref);
            }
            ++r;
        }
    }

    public EventReaderHelper makeCopy(EcoreUtil.Copier copyMap) {
        EObject copyNotifier = null;
        if (this.topNotifier instanceof Resource) {
            Resource baseRes = (Resource)this.topNotifier;
            ResourceImpl copyRes = new ResourceImpl(baseRes.getURI());
            copyRes.getContents().addAll(copyMap.copyAll((Collection)baseRes.getContents()));
            copyMap.copyReferences();
            copyNotifier = copyRes;
        } else {
            copyNotifier = copyMap.copy((EObject)this.topNotifier);
            copyMap.copyReferences();
        }
        return new EventReaderHelper((Notifier)copyNotifier, this.defaultResourceSet);
    }
}

