/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.CMDocumentManager;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.modelqueryimpl.CMDocumentLoader;
import org.eclipse.wst.xml.core.internal.contentmodel.modelqueryimpl.InferredGrammarBuildingCMDocumentLoader;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMObserver {
    private Job timer = new TimerJob();
    protected Document fDocument;
    protected boolean isGrammarInferenceEnabled;

    public DOMObserver(IStructuredModel model) {
        Object object = this.fDocument = model instanceof IDOMModel ? ((IDOMModel)model).getDocument() : null;
        if (this.fDocument != null) {
            MyDocumentAdapter adapter = new MyDocumentAdapter();
            adapter.connect(this.fDocument);
            ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)this.fDocument);
            if (modelQuery != null && modelQuery.getCMDocumentManager() != null) {
                CMDocumentManager cmDocumentManager = modelQuery.getCMDocumentManager();
                cmDocumentManager.setPropertyEnabled("autoLoad", false);
            }
        }
    }

    public void init() {
        this.invokeDelayedCMDocumentLoad();
    }

    public void invokeCMDocumentLoad() {
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)this.fDocument);
        if (modelQuery != null && modelQuery.getCMDocumentManager() != null) {
            InferredGrammarBuildingCMDocumentLoader loader = this.isGrammarInferenceEnabled ? new InferredGrammarBuildingCMDocumentLoader(this.fDocument, modelQuery) : new CMDocumentLoader(this.fDocument, modelQuery);
            loader.loadCMDocuments();
        }
    }

    public void invokeDelayedCMDocumentLoad() {
        this.timer.schedule(2000L);
    }

    public void setGrammarInferenceEnabled(boolean isEnabled) {
        this.isGrammarInferenceEnabled = isEnabled;
    }

    abstract class DocumentAdapter
    implements INodeAdapter {
        public void connect(Document document) {
            ((INodeNotifier)document).addAdapter((INodeAdapter)this);
            this.adapt(document.getDocumentElement());
        }

        public void dicconnect(Document document) {
            ((INodeNotifier)document).removeAdapter((INodeAdapter)this);
        }

        public void adapt(Element element) {
            if (element != null && ((INodeNotifier)element).getExistingAdapter((Object)this) == null) {
                ((INodeNotifier)element).addAdapter((INodeAdapter)this);
                Node child = element.getFirstChild();
                while (child != null) {
                    if (child.getNodeType() == 1) {
                        this.adapt((Element)child);
                    }
                    child = child.getNextSibling();
                }
            }
        }

        public boolean isAdapterForType(Object type) {
            return type == this;
        }

        public abstract void notifyChanged(INodeNotifier var1, int var2, Object var3, Object var4, Object var5, int var6);
    }

    class MyDocumentAdapter
    extends DocumentAdapter {
        MyDocumentAdapter() {
        }

        public void notifyChanged(INodeNotifier notifier, int eventType, Object feature, Object oldValue, Object newValue, int index) {
            block0 : switch (eventType) {
                case 2: {
                    if (!(newValue instanceof Element)) break;
                    this.adapt((Element)newValue);
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    Node node = (Node)notifier;
                    if (node.getNodeType() == 1) {
                        switch (eventType) {
                            case 1: 
                            case 4: {
                                DOMObserver.this.invokeDelayedCMDocumentLoad();
                                break block0;
                            }
                        }
                        break;
                    }
                    if (node.getNodeType() != 9) break;
                    DOMObserver.this.invokeDelayedCMDocumentLoad();
                }
            }
        }
    }

    class TimerJob
    extends Job {
        public TimerJob() {
            super(SSEUIMessages.LoadingReferencedGrammars);
            this.setPriority(20);
        }

        public IStatus run(IProgressMonitor monitor) {
            monitor.beginTask("", -1);
            DOMObserver.this.invokeCMDocumentLoad();
            monitor.done();
            return Status.OK_STATUS;
        }
    }
}

