/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.editor.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.core.search.SearchEngine;
import org.eclipse.wst.common.core.search.SearchMatch;
import org.eclipse.wst.common.core.search.SearchParticipant;
import org.eclipse.wst.common.core.search.SearchPlugin;
import org.eclipse.wst.common.core.search.SearchRequestor;
import org.eclipse.wst.common.core.search.pattern.QualifiedName;
import org.eclipse.wst.common.core.search.pattern.SearchPattern;
import org.eclipse.wst.common.core.search.scope.SearchScope;
import org.eclipse.wst.common.ui.internal.search.dialogs.IComponentList;
import org.eclipse.wst.common.ui.internal.search.dialogs.IComponentSearchListProvider;
import org.eclipse.wst.xml.core.internal.search.XMLComponentDeclarationPattern;
import org.eclipse.wst.xsd.ui.internal.search.IXSDSearchConstants;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDRedefine;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;

public abstract class XSDSearchListProvider
implements IComponentSearchListProvider {
    protected XSDSchema[] schemas;
    protected IFile currentFile;
    public static final int ENCLOSING_PROJECT_SCOPE = 0;
    public static final int ENTIRE_WORKSPACE_SCOPE = 1;

    public XSDSearchListProvider(IFile currentFile, XSDSchema[] schemas) {
        this.schemas = schemas;
        this.currentFile = currentFile;
        try {
            IProject[] refs = currentFile.getProject().getReferencedProjects();
            System.out.println("dependencies:----");
            int i = 0;
            while (i < refs.length) {
                System.out.println("dep " + refs[i].getName());
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void findMatches(SearchEngine searchEngine, SearchRequestor requestor, SearchScope scope, QualifiedName metaName) {
        try {
            XMLComponentDeclarationPattern pattern = new XMLComponentDeclarationPattern(new QualifiedName("*", "*"), metaName, 2);
            SearchParticipant particpant = SearchPlugin.getDefault().getSearchParticipant("org.eclipse.wst.xsd.search.XSDSearchParticipant");
            Assert.isNotNull((Object)particpant);
            SearchParticipant[] participants = new SearchParticipant[]{particpant};
            searchEngine.search((SearchPattern)pattern, requestor, participants, scope, null, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected HashMap createFileMap(List visitedSchemas) {
        HashMap<IFile, Boolean> fileMap = new HashMap<IFile, Boolean>();
        Iterator i = visitedSchemas.iterator();
        while (i.hasNext()) {
            XSDSchema theSchema = (XSDSchema)i.next();
            String location = theSchema.getSchemaLocation();
            IFile file = this.computeFile(location);
            if (file == null) continue;
            fileMap.put(file, Boolean.TRUE);
        }
        return fileMap;
    }

    private IFile computeFile(String baseLocation) {
        IFile file = null;
        if (baseLocation != null) {
            String fileScheme = "file:";
            String platformResourceScheme = "platform:/resource";
            if (baseLocation.startsWith(fileScheme)) {
                baseLocation = baseLocation.substring(fileScheme.length());
                baseLocation = this.removeLeading(baseLocation, "/");
                Path path = new Path(baseLocation);
                file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
            } else if (baseLocation.startsWith(platformResourceScheme)) {
                baseLocation = baseLocation.substring(platformResourceScheme.length());
                baseLocation = this.removeLeading(baseLocation, "/");
                Path path = new Path(baseLocation);
                file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            }
        }
        return file;
    }

    private String removeLeading(String path, String pattern) {
        while (path.startsWith(pattern)) {
            path = path.substring(pattern.length());
        }
        return path;
    }

    class ComponentCollectingXSDVisitor {
        protected List visitedSchemas = new ArrayList();
        IComponentList list;
        QualifiedName searchKind;

        ComponentCollectingXSDVisitor(IComponentList list, QualifiedName searchKind) {
            this.list = list;
            this.searchKind = searchKind;
        }

        public void visitSchema(XSDSchema schema, boolean visitImportedSchema) {
            this.visitedSchemas.add(schema);
            Iterator contents = schema.getContents().iterator();
            while (contents.hasNext()) {
                XSDSchemaContent content = (XSDSchemaContent)contents.next();
                if (content instanceof XSDSchemaDirective) {
                    XSDSchemaDirective schemaDirective = (XSDSchemaDirective)content;
                    XSDSchema extSchema = schemaDirective.getResolvedSchema();
                    if (extSchema == null || this.visitedSchemas.contains(extSchema)) continue;
                    if (schemaDirective instanceof XSDImport && visitImportedSchema) {
                        this.visitSchema(extSchema, false);
                        continue;
                    }
                    if (!(schemaDirective instanceof XSDInclude) && !(schemaDirective instanceof XSDRedefine)) continue;
                    this.visitSchema(extSchema, false);
                    continue;
                }
                if (content instanceof XSDElementDeclaration && this.searchKind == IXSDSearchConstants.ELEMENT_META_NAME) {
                    this.list.add((Object)content);
                    continue;
                }
                if (content instanceof XSDSimpleTypeDefinition && this.searchKind == IXSDSearchConstants.SIMPLE_TYPE_META_NAME) {
                    this.list.add((Object)content);
                    continue;
                }
                if (!(content instanceof XSDTypeDefinition) || this.searchKind != IXSDSearchConstants.TYPE_META_NAME) continue;
                this.list.add((Object)content);
            }
        }

        public List getVisitedSchemas() {
            return this.visitedSchemas;
        }
    }

    class InternalSearchRequestor
    extends SearchRequestor {
        IComponentList componentList;
        HashMap files;

        InternalSearchRequestor(IComponentList componentList, HashMap files) {
            this.componentList = componentList;
            this.files = files;
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            if (this.files.get(match.getFile()) == null) {
                QualifiedName qualifiedName = null;
                Object o = match.map.get("name");
                if (o != null && o instanceof QualifiedName) {
                    qualifiedName = (QualifiedName)o;
                }
                if (qualifiedName != null && qualifiedName.getLocalName() != null) {
                    this.componentList.add((Object)match);
                }
            }
        }
    }
}

