/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.javascript.ui.internal.common.preferences.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.javascript.core.internal.JavaScriptCorePlugin;
import org.eclipse.wst.javascript.core.internal.contenttype.ContentTypeIdForJavaScript;
import org.eclipse.wst.javascript.ui.internal.common.JSCommonUIMessages;
import org.eclipse.wst.javascript.ui.internal.editor.JSEditorPlugin;

public class JavaScriptFilesPreferencePage
extends PreferencePage
implements ModifyListener,
SelectionListener,
IWorkbenchPreferencePage {
    protected Combo fEndOfLineCode = null;
    private Vector fEOLCodes = null;
    private Text fDefaultSuffix = null;
    private List fValidExtensions = null;

    protected Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.horizontalIndent = 0;
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    protected Control createContents(Composite parent) {
        Composite composite = this.createScrolledComposite(parent);
        this.createContentsForCreatingOrSavingGroup(composite);
        this.createContentsForCreatingGroup(composite);
        this.setSize(composite);
        this.loadPreferences();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.wst.javascript.ui.webx0040");
        return composite;
    }

    protected void createContentsForCreatingGroup(Composite parent) {
        Group creatingGroup = this.createGroup(parent, 2);
        creatingGroup.setText(JSCommonUIMessages.Creating_files);
        this.createLabel((Composite)creatingGroup, JSCommonUIMessages.JavaScriptFilesPreferencePage_ExtensionLabel);
        this.fDefaultSuffix = this.createTextField((Composite)creatingGroup);
        this.fDefaultSuffix.addModifyListener((ModifyListener)this);
    }

    protected void createContentsForCreatingOrSavingGroup(Composite parent) {
        Group creatingOrSavingGroup = this.createGroup(parent, 2);
        creatingOrSavingGroup.setText(JSCommonUIMessages.Creating_or_saving_files);
        Label label = this.createLabel((Composite)creatingOrSavingGroup, JSCommonUIMessages.End_of_line_code_desc);
        ((GridData)label.getLayoutData()).horizontalSpan = 2;
        ((GridData)label.getLayoutData()).grabExcessHorizontalSpace = true;
        this.createLabel((Composite)creatingOrSavingGroup, JSCommonUIMessages.End_of_line_code);
        this.fEndOfLineCode = this.createDropDownBox((Composite)creatingOrSavingGroup);
        this.populateLineDelimiters();
    }

    protected Combo createDropDownBox(Composite parent) {
        Combo comboBox = new Combo(parent, 12);
        GridData data = new GridData();
        data.verticalAlignment = 2;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        comboBox.setLayoutData((Object)data);
        return comboBox;
    }

    protected Group createGroup(Composite parent, int numColumns) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        group.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.horizontalIndent = 0;
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)data);
        return group;
    }

    protected Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData(4);
        data.verticalAlignment = 2;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    protected Composite createScrolledComposite(Composite parent) {
        ScrolledComposite sc1 = new ScrolledComposite(parent, 768);
        sc1.setLayoutData((Object)new GridData(1808));
        Composite composite = this.createComposite((Composite)sc1, 1);
        sc1.setContent((Control)composite);
        this.setSize(composite);
        return composite;
    }

    protected Text createTextField(Composite parent) {
        Text text = new Text(parent, 2052);
        GridData data = new GridData();
        data.verticalAlignment = 2;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        text.setLayoutData((Object)data);
        return text;
    }

    public void dispose() {
        this.fDefaultSuffix.removeModifyListener((ModifyListener)this);
        super.dispose();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return JSEditorPlugin.getDefault().getPreferenceStore();
    }

    protected void doSavePreferenceStore() {
        JavaScriptCorePlugin.getDefault().savePluginPreferences();
    }

    private void enableValues() {
    }

    private IContentType getContentType() {
        return Platform.getContentTypeManager().getContentType(ContentTypeIdForJavaScript.ContentTypeID_JAVASCRIPT);
    }

    private List getValidExtensions() {
        if (this.fValidExtensions == null) {
            IContentType type = this.getContentType();
            this.fValidExtensions = new ArrayList<String>(Arrays.asList(type.getFileSpecs(8)));
        }
        return this.fValidExtensions;
    }

    private String getCurrentEOLCode() {
        int i = this.fEndOfLineCode.getSelectionIndex();
        if (i >= 0) {
            return (String)this.fEOLCodes.elementAt(i);
        }
        return "";
    }

    protected Preferences getModelPreferences() {
        return JavaScriptCorePlugin.getDefault().getPluginPreferences();
    }

    public void init(IWorkbench workbench) {
    }

    protected void initializeValues() {
        this.initializeValuesForCreatingOrSavingGroup();
        this.initializeValuesForCreatingGroup();
    }

    protected void initializeValuesForCreatingGroup() {
        String suffix = this.getModelPreferences().getString("defaultExtension");
        this.fDefaultSuffix.setText(suffix);
    }

    protected void initializeValuesForCreatingOrSavingGroup() {
        String endOfLineCode = this.getModelPreferences().getString("endOfLineCode");
        if (endOfLineCode.length() > 0) {
            this.setCurrentEOLCode(endOfLineCode);
        } else {
            this.setCurrentEOLCode("");
        }
    }

    protected boolean loadPreferences() {
        BusyIndicator.showWhile((Display)this.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                JavaScriptFilesPreferencePage.this.initializeValues();
                JavaScriptFilesPreferencePage.this.validateValues();
                JavaScriptFilesPreferencePage.this.enableValues();
            }
        });
        return true;
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget != null && e.widget.isDisposed()) {
            return;
        }
        this.validateValues();
        this.enableValues();
    }

    protected void performDefaults() {
        this.performDefaultsForCreatingOrSavingGroup();
        this.performDefaultsForCreatingGroup();
        super.performDefaults();
    }

    protected void performDefaultsForCreatingGroup() {
        String suffix = this.getModelPreferences().getDefaultString("defaultExtension");
        this.fDefaultSuffix.setText(suffix);
    }

    protected void performDefaultsForCreatingOrSavingGroup() {
        String endOfLineCode = this.getModelPreferences().getDefaultString("endOfLineCode");
        if (endOfLineCode.length() > 0) {
            this.setCurrentEOLCode(endOfLineCode);
        } else {
            this.setCurrentEOLCode("");
        }
    }

    public boolean performOk() {
        this.savePreferences();
        this.doSavePreferenceStore();
        return true;
    }

    private void populateLineDelimiters() {
        this.fEOLCodes = new Vector();
        this.fEndOfLineCode.add(JSCommonUIMessages.EOL_Unix);
        this.fEOLCodes.add("EOL_Unix");
        this.fEndOfLineCode.add(JSCommonUIMessages.EOL_Mac);
        this.fEOLCodes.add("EOL_Mac");
        this.fEndOfLineCode.add(JSCommonUIMessages.EOL_Windows);
        this.fEOLCodes.add("EOL_Windows");
        this.fEndOfLineCode.add(JSCommonUIMessages.EOL_NoTranslation);
        this.fEOLCodes.add("");
    }

    private void setCurrentEOLCode(String eolCode) {
        this.fEndOfLineCode.clearSelection();
        this.fEndOfLineCode.deselectAll();
        int i = this.fEOLCodes.indexOf(eolCode);
        if (i >= 0) {
            this.fEndOfLineCode.select(i);
        }
    }

    protected void setSize(Composite composite) {
        if (composite != null) {
            this.applyDialogFont(composite);
            Point minSize = composite.computeSize(-1, -1);
            composite.setSize(minSize);
            if (composite.getParent() instanceof ScrolledComposite) {
                ScrolledComposite sc1 = (ScrolledComposite)composite.getParent();
                sc1.setMinSize(minSize);
                sc1.setExpandHorizontal(true);
                sc1.setExpandVertical(true);
            }
        }
    }

    protected void storeValues() {
        this.storeValuesForCreatingOrSavingGroup();
        this.storeValuesForCreatingGroup();
    }

    protected void storeValuesForCreatingGroup() {
        String suffix = this.fDefaultSuffix.getText();
        this.getModelPreferences().setValue("defaultExtension", suffix);
    }

    protected void storeValuesForCreatingOrSavingGroup() {
        String eolCode = this.getCurrentEOLCode();
        this.getModelPreferences().setValue("endOfLineCode", eolCode);
    }

    protected void validateValues() {
        boolean isValid = false;
        Iterator i = this.getValidExtensions().iterator();
        while (i.hasNext() && !isValid) {
            String extension = (String)i.next();
            isValid = extension.equalsIgnoreCase(this.fDefaultSuffix.getText());
        }
        if (!isValid) {
            this.setErrorMessage(NLS.bind((String)JSCommonUIMessages.JavaScriptFilesPreferencePage_ExtensionError, (Object)this.getValidExtensions().toString()));
            this.setValid(false);
        } else {
            this.setErrorMessage(null);
            this.setValid(true);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget != null && e.widget.isDisposed()) {
            return;
        }
        this.validateValues();
        this.enableValues();
    }

    protected boolean savePreferences() {
        BusyIndicator.showWhile((Display)this.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                JavaScriptFilesPreferencePage.this.storeValues();
            }
        });
        return true;
    }
}

