/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model.internal.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.Method;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.ejb.CMPAttribute;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.model.internal.validation.AValidateEntityBean;
import org.eclipse.jst.j2ee.model.internal.validation.IEJBValidationContext;
import org.eclipse.jst.j2ee.model.internal.validation.IMessagePrefixEjb11Constants;
import org.eclipse.jst.j2ee.model.internal.validation.IValidationRule;
import org.eclipse.jst.j2ee.model.internal.validation.IValidationRuleList;
import org.eclipse.jst.j2ee.model.internal.validation.InvalidInputException;
import org.eclipse.jst.j2ee.model.internal.validation.MessageUtility;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationCancelledException;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationRuleUtility;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public class ValidateCMPBean
extends AValidateEntityBean
implements IMessagePrefixEjb11Constants {
    private List _containerManagedFields = null;
    private static final String MSSGID = ".eb";
    private static final String EXT = ".eb.ejb11";
    private static final String BEXT = ".eb.i.ejb11";
    private static final String MEXT = ".eb.m.ejb11";
    private static final Object ID = IValidationRuleList.EJB11_CMP_BEANCLASS;
    private static final Object[] DEPENDS_ON = new Object[]{IValidationRuleList.EJB11_CMP_HOME, IValidationRuleList.EJB11_CMP_REMOTE};
    private static final Map MESSAGE_IDS = new HashMap();

    static {
        MESSAGE_IDS.put("CHKJ2002", new String[]{"CHKJ2002.eb.i.ejb11", "CHKJ2002.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2004", new String[]{"CHKJ2004.eb.i.ejb11", "CHKJ2004.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2006", new String[]{"CHKJ2006.eb.ejb11"});
        MESSAGE_IDS.put("CHKJ2007", new String[]{"CHKJ2007.eb.ejb11"});
        MESSAGE_IDS.put("CHKJ2013", new String[]{"CHKJ2013.eb.ejb11"});
        MESSAGE_IDS.put("CHKJ2014", new String[]{"CHKJ2014.eb.ejb11"});
        MESSAGE_IDS.put("CHKJ2015", new String[]{"CHKJ2015.eb.ejb11"});
        MESSAGE_IDS.put("CHKJ2022", new String[]{"CHKJ2022.eb.ejb11"});
        MESSAGE_IDS.put("CHKJ2028", new String[]{"CHKJ2028.eb.i.ejb11", "CHKJ2028.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2029", new String[]{"CHKJ2029.eb.i.ejb11", "CHKJ2029.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2032", new String[]{"CHKJ2032.eb.ejb11"});
        MESSAGE_IDS.put("CHKJ2033", new String[]{"CHKJ2033.eb.ejb11"});
        MESSAGE_IDS.put("CHKJ2034", new String[]{"CHKJ2034.eb.ejb11"});
        MESSAGE_IDS.put("CHKJ2035", new String[]{"CHKJ2035.eb.ejb11"});
        MESSAGE_IDS.put("CHKJ2036", new String[]{"CHKJ2036.eb.ejb11"});
        MESSAGE_IDS.put("CHKJ2037", new String[]{"CHKJ2037.eb.ejb11"});
        MESSAGE_IDS.put("CHKJ2038", new String[]{"CHKJ2038.eb.ejb11"});
        MESSAGE_IDS.put("CHKJ2039", new String[]{"CHKJ2039.eb.ejb11"});
        MESSAGE_IDS.put("CHKJ2103", new String[]{"CHKJ2103.ejb11"});
        MESSAGE_IDS.put("CHKJ2200", new String[]{"CHKJ2200.i.ejb11", "CHKJ2200.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2201", new String[]{"CHKJ2201.eb.i.ejb11", "CHKJ2201.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2202", new String[]{"CHKJ2202.eb.i.ejb11", "CHKJ2202.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2203", new String[]{"CHKJ2203.eb.i.ejb11", "CHKJ2203.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2207", new String[]{"CHKJ2207.eb.ejb11", "CHKJ2207.eb.ejb11"});
        MESSAGE_IDS.put("CHKJ2400.bus", new String[]{"CHKJ2400.bus.eb.i.ejb11", "CHKJ2400.bus.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2400.ejbCreate", new String[]{"CHKJ2400.ejbCreate.eb.i.ejb11", "CHKJ2400.ejbCreate.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2400.ejbFind", new String[]{"CHKJ2400.ejbFind.eb.i.ejb11", "CHKJ2400.ejbFind.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2400.ejbPostCreate", new String[]{"CHKJ2400.ejbPostCreate.eb.i.ejb11", "CHKJ2400.ejbPostCreate.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2406", new String[]{"CHKJ2406.eb.i.ejb11", "CHKJ2406.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2408.bus", new String[]{"CHKJ2408.bus.eb.i.ejb11", "CHKJ2408.bus.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2408.ejbCreate", new String[]{"CHKJ2408.ejbCreate.eb.i.ejb11", "CHKJ2408.ejbCreate.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2408.ejbPostCreate", new String[]{"CHKJ2408.ejbPostCreate.eb.i.ejb11", "CHKJ2408.ejbPostCreate.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2409.bus", new String[]{"CHKJ2409.bus.eb.i.ejb11", "CHKJ2409.bus.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2409.ejbCreate", new String[]{"CHKJ2409.ejbCreate.eb.i.ejb11", "CHKJ2409.ejbCreate.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2409.ejbFind", new String[]{"CHKJ2409.ejbFind.eb.i.ejb11", "CHKJ2409.ejbFind.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2409.ejbPostCreate", new String[]{"CHKJ2409.ejbPostCreate.eb.i.ejb11", "CHKJ2409.ejbPostCreate.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2410.bus", new String[]{"CHKJ2410.bus.eb.i.ejb11", "CHKJ2410.bus.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2410.ejbCreate", new String[]{"CHKJ2410.ejbCreate.eb.i.ejb11", "CHKJ2410.ejbCreate.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2410.ejbFind", new String[]{"CHKJ2410.ejbFind.eb.i.ejb11", "CHKJ2410.ejbFind.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2410.ejbPostCreate", new String[]{"CHKJ2410.ejbPostCreate.eb.i.ejb11", "CHKJ2410.ejbPostCreate.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2411", new String[]{"CHKJ2411.eb.i.ejb11", "CHKJ2411.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2412", new String[]{"CHKJ2412.eb.i.ejb11", "CHKJ2412.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2413", new String[]{"CHKJ2413.eb.i.ejb11", "CHKJ2413.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2414", new String[]{"CHKJ2414.eb.i.ejb11", "CHKJ2414.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2418", new String[]{"CHKJ2418.eb.i.ejb11", "CHKJ2418.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2420", new String[]{"CHKJ2420.eb.i.ejb11", "CHKJ2420.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2432", new String[]{"CHKJ2432.eb.i.ejb11", "CHKJ2432.eb.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2041", new String[]{"CHKJ2041"});
        MESSAGE_IDS.put("CHKJ2433", new String[]{"CHKJ2433"});
        MESSAGE_IDS.put("CHKJ2456", new String[]{"CHKJ2456.i", "CHKJ2456.m"});
        MESSAGE_IDS.put("CHKJ2907", new String[]{"CHKJ2907"});
    }

    public void reset() {
        super.reset();
        this._containerManagedFields = null;
    }

    public final Map getMessageIds() {
        return MESSAGE_IDS;
    }

    public final Object[] getDependsOn() {
        return DEPENDS_ON;
    }

    public final Object getId() {
        return ID;
    }

    protected List getContainerManagedFields() {
        return this._containerManagedFields;
    }

    protected boolean hasContainerManagedField() {
        return this.getContainerManagedFields() != null && this.getContainerManagedFields().size() > 0;
    }

    public boolean isContainerManagedField(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Field field) {
        if (field == null) {
            return false;
        }
        return this.getContainerManagedFields() != null && this.getContainerManagedFields().contains(field.getName());
    }

    protected boolean isContainerManagedHome_homeDep(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Field field) throws InvalidInputException {
        if (field == null) {
            return false;
        }
        if (bean == null) {
            return false;
        }
        JavaClass homeIntf = bean.getHomeInterface();
        ValidationRuleUtility.isValidTypeHierarchy(bean, (JavaHelpers)homeIntf);
        return ValidationRuleUtility.isAssignableFrom(ValidationRuleUtility.getType(field), (JavaHelpers)homeIntf);
    }

    protected boolean isContainerManagedRemote_remoteDep(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Field field) throws InvalidInputException {
        if (field == null) {
            return false;
        }
        if (bean == null) {
            return false;
        }
        JavaClass remoteIntf = bean.getRemoteInterface();
        ValidationRuleUtility.isValidTypeHierarchy(bean, (JavaHelpers)remoteIntf);
        return ValidationRuleUtility.isAssignableFrom(ValidationRuleUtility.getType(field), (JavaHelpers)remoteIntf);
    }

    private List loadContainerManagedFields(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) {
        if (bean == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> fields = null;
        try {
            EList cmpAttributes = ((ContainerManagedEntity)bean).getPersistentAttributes();
            if (cmpAttributes != null && !cmpAttributes.isEmpty()) {
                fields = new ArrayList<String>(cmpAttributes.size());
                int i = 0;
                while (i < cmpAttributes.size()) {
                    fields.add(((CMPAttribute)cmpAttributes.get(i)).getName());
                    ++i;
                }
            }
        }
        catch (Throwable exc) {
            Logger logger = vc.getMsgLogger();
            if (logger != null && logger.isLoggingLevel(Level.FINER)) {
                logger.write(Level.FINER, exc);
            }
            fields = Collections.EMPTY_LIST;
        }
        return fields;
    }

    public void primValidate(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Field field) throws InvalidInputException {
        super.primValidate(vc, bean, clazz, field);
        vc.terminateIfCancelled();
        this.validateContainerManagedField(vc, bean, clazz, field);
    }

    public void validateBusinessMethod(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        if (!this.isEjbRelationshipRoleMethod(vc, bean, clazz, method)) {
            super.validateBusinessMethod(vc, bean, clazz, method);
        }
    }

    protected void validateBusinessMethodNoRemoteException(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        if (!this.isEjbRelationshipRoleMethod(vc, bean, clazz, method)) {
            super.validateBusinessMethodNoRemoteException(vc, bean, clazz, method);
        }
    }

    public void validateClass(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) throws InvalidInputException {
        super.validateClass(vc, bean, clazz);
        this.validatePrimitivePrimaryKey(vc, bean, clazz);
    }

    protected void validateContainerManagedField(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Field field) throws InvalidInputException {
        if (this.isContainerManagedField(vc, bean, clazz, field)) {
            IMessage message;
            if (field == null) {
                return;
            }
            vc.terminateIfCancelled();
            if (!ValidationRuleUtility.isPublic(field)) {
                message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2203", 1, bean, clazz, field, (IValidationRule)this);
                vc.addMessage(message);
            }
            if (field.isTransient()) {
                message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2201", 1, bean, clazz, field, (IValidationRule)this);
                vc.addMessage(message);
            }
            this.validateContainerManagedField_dependent(vc, bean, clazz, field);
        }
    }

    protected void validateContainerManagedField_dependent(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Field field) throws InvalidInputException {
        if (field == null) {
            return;
        }
        JavaHelpers fieldType = ValidationRuleUtility.getType(field);
        if (!ValidationRuleUtility.isSerializable(fieldType, bean)) {
            vc.terminateIfCancelled();
            if (!this.isContainerManagedHome_homeDep(vc, bean, clazz, field) || this.isContainerManagedRemote_remoteDep(vc, bean, clazz, field)) {
                IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2202", 2, bean, clazz, field, (IValidationRule)this);
                vc.addMessage(message);
            }
        }
    }

    public void validateEjbFindMethod(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        if (method == null) {
            throw new InvalidInputException();
        }
        IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2004", 2, bean, clazz, method, new String[]{clazz.getQualifiedName()}, (IValidationRule)this);
        vc.addMessage(message);
    }

    public void validateEjbPostCreateMethod(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        super.validateEjbPostCreateMethod(vc, bean, clazz, method);
    }

    protected void validatePrimitivePrimaryKey(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) throws InvalidInputException {
        ContainerManagedEntity cmp = (ContainerManagedEntity)bean;
        if (ValidationRuleUtility.isPrimitivePrimaryKey(cmp)) {
            CMPAttribute keyAttribute = cmp.getPrimKeyField();
            Field keyField = keyAttribute == null ? null : keyAttribute.getField();
            JavaClass primaryKey = cmp.getPrimaryKey();
            if (keyField == null || !ValidationRuleUtility.isAssignableFrom((JavaHelpers)keyField.getEType(), (JavaHelpers)primaryKey)) {
                String[] msgParm = new String[]{keyAttribute.getName(), primaryKey.getName()};
                IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2207", 1, bean, clazz, keyField, msgParm, (IValidationRule)this);
                vc.addMessage(message);
            }
        }
    }

    public void verifyFieldExists(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) throws InvalidInputException {
        if (!this.hasContainerManagedField()) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2032", 2, bean, clazz, new String[]{clazz.getQualifiedName()}, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    public void preValidate(IEJBValidationContext vc, Object targetParent, Object target) throws ValidationCancelledException, ValidationException {
        super.preValidate(vc, targetParent, target);
        this._containerManagedFields = this.loadContainerManagedFields(vc, (EnterpriseBean)targetParent, (JavaClass)target);
    }
}

