/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.envelope;

import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionNotApplicableException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class BP1032
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1032(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            Document doc = entryContext.getMessageEntryDocument();
            if (doc == null) {
                throw new AssertionNotApplicableException();
            }
            Element element = doc.getDocumentElement();
            if (!element.getLocalName().equals("Envelope")) {
                throw new AssertionNotApplicableException();
            }
            Attr attr = this.getAttribute(element.getAttributes());
            if (attr != null) {
                throw new AssertionFailException("soap:Envelope attribute name is " + attr.getName());
            }
            if ((element = XMLUtils.getFirstChild(element)) != null && element.getLocalName().equals("Header")) {
                attr = this.getAttribute(element.getAttributes());
                if (attr != null) {
                    throw new AssertionFailException("soap:Header attribute name is " + attr.getName());
                }
                element = XMLUtils.getNextSibling(element);
            }
            if (element != null && element.getLocalName().equals("Body") && (attr = this.getAttribute(element.getAttributes())) != null) {
                throw new AssertionFailException("soap:Body attribute name is " + attr.getName());
            }
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException afe) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(afe.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private Attr getAttribute(NamedNodeMap attrs) {
        Attr ret = null;
        if (attrs != null) {
            int i = 0;
            while (i < attrs.getLength()) {
                Attr attr = (Attr)attrs.item(i);
                if (attr.getNamespaceURI() != null && attr.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/")) {
                    ret = attr;
                    break;
                }
                ++i;
            }
        }
        return ret;
    }
}

