/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.ant;

import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.ModuleId;
import fr.jayasoft.ivy.ModuleRevisionId;
import fr.jayasoft.ivy.ResolvedModuleRevision;
import fr.jayasoft.ivy.ant.IvyTask;
import org.apache.tools.ant.BuildException;

public class IvyBuildNumber
extends IvyTask {
    private String _organisation;
    private String _module;
    private String _branch;
    private String _revision;
    private String _revSep = ".";
    private String _prefix = "ivy.";
    private String _default = "0";
    private String _defaultBuildNumber = "0";

    public String getModule() {
        return this._module;
    }

    public void setModule(String module) {
        this._module = module;
    }

    public String getOrganisation() {
        return this._organisation;
    }

    public void setOrganisation(String organisation) {
        this._organisation = organisation;
    }

    public String getRevision() {
        return this._revision;
    }

    public void setRevision(String revision) {
        this._revision = revision;
    }

    public String getBranch() {
        return this._branch;
    }

    public void setBranch(String branch) {
        this._branch = branch;
    }

    public String getDefault() {
        return this._default;
    }

    public void setDefault(String default1) {
        this._default = default1;
    }

    public String getPrefix() {
        return this._prefix;
    }

    public void setPrefix(String prefix) {
        this._prefix = prefix;
    }

    public void execute() throws BuildException {
        ResolvedModuleRevision rmr;
        if (this._organisation == null) {
            throw new BuildException("no organisation provided for ivy findmodules");
        }
        if (this._module == null) {
            throw new BuildException("no module name provided for ivy findmodules");
        }
        if (this._prefix == null) {
            throw new BuildException("null prefix not allowed");
        }
        Ivy ivy = this.getIvyInstance();
        if (this._branch == null) {
            ivy.getDefaultBranch(new ModuleId(this._organisation, this._module));
        }
        if (this._revision == null || this._revision.length() == 0) {
            this._revision = "latest.integration";
        } else if (!this._revision.endsWith("+")) {
            this._revision = this._revision + "+";
        }
        if (!this._prefix.endsWith(".") && this._prefix.length() > 0) {
            this._prefix = this._prefix + ".";
        }
        String revision = (rmr = ivy.findModule(ModuleRevisionId.newInstance(this._organisation, this._module, this._branch, this._revision))) == null ? null : rmr.getId().getRevision();
        NewRevision newRevision = this.computeNewRevision(revision);
        this.setProperty("revision", newRevision.revision);
        this.setProperty("new.revision", newRevision.newRevision);
        this.setProperty("build.number", newRevision.buildNumber);
        this.setProperty("new.build.number", newRevision.newBuildNumber);
    }

    private void setProperty(String propertyName, String value) {
        if (value != null) {
            this.getProject().setProperty(this._prefix + propertyName, value);
        }
    }

    private NewRevision computeNewRevision(String revision) {
        Range r;
        String revPrefix;
        String string = revPrefix = "latest.integration".equals(this._revision) ? "" : this._revision.substring(0, this._revision.length() - 1);
        if (revision != null && !revision.startsWith(revPrefix)) {
            throw new BuildException("invalid exception found in repository: '" + revision + "' for '" + revPrefix + "'");
        }
        if (revision == null) {
            if (revPrefix.length() > 0) {
                return new NewRevision(revision, revPrefix + (revPrefix.endsWith(this._revSep) ? this._defaultBuildNumber : this._revSep + this._defaultBuildNumber), null, this._defaultBuildNumber);
            }
            Range r2 = this.findLastNumber(this._default);
            if (r2 == null) {
                return new NewRevision(revision, this._default, null, null);
            }
            long n = Long.parseLong(this._default.substring(r2.startIndex, r2.endIndex));
            return new NewRevision(revision, this._default, null, String.valueOf(n));
        }
        if (revPrefix.length() == 0) {
            r = this.findLastNumber(revision);
            if (r == null) {
                return new NewRevision(revision, revision + (revision.endsWith(this._revSep) ? "1" : this._revSep + "1"), null, "1");
            }
        } else {
            r = this.findFirstNumber(revision, revPrefix.length());
            if (r == null) {
                return new NewRevision(revision, revPrefix + (revPrefix.endsWith(this._revSep) ? "1" : this._revSep + "1"), null, "1");
            }
        }
        long n = Long.parseLong(revision.substring(r.startIndex, r.endIndex)) + 1L;
        return new NewRevision(revision, revision.substring(0, r.startIndex) + n, String.valueOf(n - 1L), String.valueOf(n));
    }

    private Range findFirstNumber(String str, int startIndex) {
        int endNumberIndex;
        int startNumberIndex;
        for (startNumberIndex = startIndex; startNumberIndex < str.length() && !Character.isDigit(str.charAt(startNumberIndex)); ++startNumberIndex) {
        }
        if (startNumberIndex == str.length()) {
            return null;
        }
        for (endNumberIndex = startNumberIndex + 1; endNumberIndex < str.length() && Character.isDigit(str.charAt(endNumberIndex)); ++endNumberIndex) {
        }
        return new Range(startNumberIndex, endNumberIndex);
    }

    private Range findLastNumber(String str) {
        int startNumberIndex;
        int endNumberIndex;
        for (endNumberIndex = str.length() - 1; endNumberIndex >= 0 && !Character.isDigit(str.charAt(endNumberIndex)); --endNumberIndex) {
        }
        int n = startNumberIndex = endNumberIndex == -1 ? -1 : endNumberIndex - 1;
        while (startNumberIndex >= 0 && Character.isDigit(str.charAt(startNumberIndex))) {
            --startNumberIndex;
        }
        if (++startNumberIndex == ++endNumberIndex) {
            return null;
        }
        return new Range(startNumberIndex, endNumberIndex);
    }

    public String getRevSep() {
        return this._revSep;
    }

    public void setRevSep(String revSep) {
        this._revSep = revSep;
    }

    public String getDefaultBuildNumber() {
        return this._defaultBuildNumber;
    }

    public void setDefaultBuildNumber(String defaultBuildNumber) {
        this._defaultBuildNumber = defaultBuildNumber;
    }

    private static class NewRevision {
        private String revision;
        private String newRevision;
        private String buildNumber;
        private String newBuildNumber;

        public NewRevision(String revision, String newRevision, String buildNumber, String newBuildNumber) {
            this.revision = revision;
            this.newRevision = newRevision;
            this.buildNumber = buildNumber;
            this.newBuildNumber = newBuildNumber;
        }
    }

    private static class Range {
        private int startIndex;
        private int endIndex;

        public Range(int startIndex, int endIndex) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }
    }
}

