/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.latest;

import fr.jayasoft.ivy.ArtifactInfo;
import fr.jayasoft.ivy.latest.AbstractLatestStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class ComparatorLatestStrategy
extends AbstractLatestStrategy {
    private Comparator _comparator;

    public ComparatorLatestStrategy() {
    }

    public ComparatorLatestStrategy(Comparator comparator) {
        this._comparator = comparator;
    }

    public ArtifactInfo findLatest(ArtifactInfo[] artifacts, Date date) {
        if (artifacts == null) {
            return null;
        }
        ArtifactInfo found = null;
        for (int i = 0; i < artifacts.length; ++i) {
            long lastModified;
            ArtifactInfo art = artifacts[i];
            if (found != null && this._comparator.compare(art, found) <= 0 || date != null && (lastModified = art.getLastModified()) > date.getTime()) continue;
            found = art;
        }
        return found;
    }

    public List sort(ArtifactInfo[] infos) {
        ArrayList<ArtifactInfo> ret = new ArrayList<ArtifactInfo>(Arrays.asList(infos));
        Collections.sort(ret, this._comparator);
        return ret;
    }

    public Comparator getComparator() {
        return this._comparator;
    }

    public void setComparator(Comparator comparator) {
        this._comparator = comparator;
    }
}

