/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.obl;

import edu.umd.cs.findbugs.ba.obl.NonexistentObligationException;
import edu.umd.cs.findbugs.ba.obl.Obligation;
import edu.umd.cs.findbugs.ba.obl.ObligationFactory;

public class ObligationSet {
    private static final int INVALID_HASH_CODE = -1;
    private final short[] countList;
    private final ObligationFactory factory;
    private int cachedHashCode;

    public ObligationSet(int maxObligationTypes, ObligationFactory factory) {
        this.countList = new short[maxObligationTypes];
        this.factory = factory;
        this.invalidate();
    }

    public int getMaxObligationTypes() {
        return this.countList.length;
    }

    public void add(Obligation obligation) {
        this.invalidate();
        int n = obligation.getId();
        this.countList[n] = (short)(this.countList[n] + 1);
    }

    public void remove(Obligation obligation) throws NonexistentObligationException {
        short count = this.countList[obligation.getId()];
        this.invalidate();
        this.countList[obligation.getId()] = (short)(count - 1);
    }

    public int getCount(int id) {
        return this.countList[id];
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ObligationSet other = (ObligationSet)o;
        if (this.countList.length != other.countList.length) {
            return false;
        }
        for (int i = 0; i < this.countList.length; ++i) {
            if (this.countList[i] == other.countList[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        int count = 0;
        for (int i = 0; i < this.countList.length; ++i) {
            if (this.countList[i] == 0) continue;
            if (count > 0) {
                buf.append(",");
            }
            buf.append(this.factory.getObligationById(i).toString());
            buf.append("*");
            buf.append(this.countList[i]);
            ++count;
        }
        buf.append("}");
        return buf.toString();
    }

    public ObligationSet duplicate() {
        ObligationSet dup = new ObligationSet(this.countList.length, this.factory);
        System.arraycopy(this.countList, 0, dup.countList, 0, this.countList.length);
        return dup;
    }

    public int hashCode() {
        if (this.cachedHashCode == -1) {
            int value = 0;
            for (int i = 0; i < this.countList.length; ++i) {
                value += 13 * i * this.countList[i];
            }
            this.cachedHashCode = value;
        }
        return this.cachedHashCode;
    }

    private void invalidate() {
        this.cachedHashCode = -1;
    }
}

