/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql.jdbcwrapper;

import ca.sqlpower.sql.CachedRowSet;
import ca.sqlpower.sql.jdbcwrapper.ConnectionDecorator;
import ca.sqlpower.sql.jdbcwrapper.DatabaseMetaDataDecorator;
import ca.sqlpower.sql.jdbcwrapper.GenericResultSetDecorator;
import ca.sqlpower.sql.jdbcwrapper.GenericStatementDecorator;
import ca.sqlpower.sql.jdbcwrapper.ResultSetDecorator;
import ca.sqlpower.sql.jdbcwrapper.StatementDecorator;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class SybaseDatabaseMetaDataDecorator
extends DatabaseMetaDataDecorator {
    private static final Logger logger = Logger.getLogger(SybaseDatabaseMetaDataDecorator.class);

    public SybaseDatabaseMetaDataDecorator(DatabaseMetaData delegate, ConnectionDecorator connectionDecorator) {
        super(delegate, connectionDecorator);
        logger.debug((Object)"Creating new DatabaseMetaDataDecorator for Sybase connection");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        ResultSet rs = null;
        try {
            rs = super.getPrimaryKeys(catalog, schema, table);
            CachedRowSet crs = new CachedRowSet();
            crs.populate(rs);
            while (crs.next()) {
                crs.updateString(6, crs.getString(3) + "_pk");
            }
            crs.beforeFirst();
            CachedRowSet cachedRowSet = crs;
            return cachedRowSet;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    logger.warn((Object)"Failed to close result set. Squishing this exception:", (Throwable)ex);
                }
            }
        }
    }

    @Override
    protected ResultSetDecorator wrap(ResultSet rs) throws SQLException {
        return new GenericResultSetDecorator(this.wrap(rs.getStatement()), rs);
    }

    @Override
    protected StatementDecorator wrap(Statement statement) {
        return new GenericStatementDecorator(this.connectionDecorator, statement);
    }
}

