/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseFactoryInterface;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.InfobrightDatabaseMeta;
import org.pentaho.di.core.database.Messages;
import org.pentaho.di.core.database.MySQLDatabaseMeta;
import org.pentaho.di.core.database.PartitionDatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.core.xml.XMLInterface;
import org.pentaho.di.shared.SharedObjectBase;
import org.pentaho.di.shared.SharedObjectInterface;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseMeta
extends SharedObjectBase
implements Cloneable,
XMLInterface,
SharedObjectInterface,
VariableSpace {
    public static final String XML_TAG = "connection";
    public static final Comparator<DatabaseMeta> comparator = new Comparator<DatabaseMeta>(){

        @Override
        public int compare(DatabaseMeta dbm1, DatabaseMeta dbm2) {
            return dbm1.getName().compareToIgnoreCase(dbm2.getName());
        }
    };
    private DatabaseInterface databaseInterface;
    private static DatabaseInterface[] allDatabaseInterfaces;
    private VariableSpace variables = new Variables();
    public static final int TYPE_DATABASE_NONE = 0;
    public static final int TYPE_DATABASE_MYSQL = 1;
    public static final int TYPE_DATABASE_ORACLE = 2;
    public static final int TYPE_DATABASE_AS400 = 3;
    public static final int TYPE_DATABASE_ACCESS = 4;
    public static final int TYPE_DATABASE_MSSQL = 5;
    public static final int TYPE_DATABASE_DB2 = 6;
    public static final int TYPE_DATABASE_POSTGRES = 7;
    public static final int TYPE_DATABASE_CACHE = 8;
    public static final int TYPE_DATABASE_INFORMIX = 9;
    public static final int TYPE_DATABASE_SYBASE = 10;
    public static final int TYPE_DATABASE_GUPTA = 11;
    public static final int TYPE_DATABASE_DBASE = 12;
    public static final int TYPE_DATABASE_FIREBIRD = 13;
    public static final int TYPE_DATABASE_SAPDB = 14;
    public static final int TYPE_DATABASE_HYPERSONIC = 15;
    public static final int TYPE_DATABASE_GENERIC = 16;
    public static final int TYPE_DATABASE_SAPR3 = 17;
    public static final int TYPE_DATABASE_INGRES = 18;
    public static final int TYPE_DATABASE_INTERBASE = 19;
    public static final int TYPE_DATABASE_EXTENDB = 20;
    public static final int TYPE_DATABASE_TERADATA = 21;
    public static final int TYPE_DATABASE_ORACLE_RDB = 22;
    public static final int TYPE_DATABASE_H2 = 23;
    public static final int TYPE_DATABASE_NETEZZA = 24;
    public static final int TYPE_DATABASE_UNIVERSE = 25;
    public static final int TYPE_DATABASE_SQLITE = 26;
    public static final int TYPE_DATABASE_DERBY = 27;
    public static final int TYPE_DATABASE_REMEDY_AR_SYSTEM = 28;
    public static final int TYPE_DATABASE_PALO = 29;
    public static final int TYPE_DATABASE_SYBASEIQ = 30;
    public static final int TYPE_DATABASE_GREENPLUM = 31;
    public static final int TYPE_DATABASE_MONETDB = 32;
    public static final int TYPE_DATABASE_KINGBASEES = 33;
    public static final int TYPE_DATABASE_VERTICA = 34;
    public static final int TYPE_DATABASE_NEOVIEW = 35;
    public static final int TYPE_DATABASE_LUCIDDB = 36;
    public static final int TYPE_DATABASE_INFOBRIGHT = 37;
    public static final int TYPE_ACCESS_NATIVE = 0;
    public static final int TYPE_ACCESS_ODBC = 1;
    public static final int TYPE_ACCESS_OCI = 2;
    public static final int TYPE_ACCESS_PLUGIN = 3;
    public static final int TYPE_ACCESS_JNDI = 4;
    public static final String[] dbAccessTypeCode;
    public static final String[] dbAccessTypeDesc;
    public static final int CLOB_LENGTH = 9999999;
    public static final String EMPTY_OPTIONS_STRING = "><EMPTY><";

    public DatabaseMeta(String name, String type, String access, String host, String db, String port, String user, String pass) {
        this.setValues(name, type, access, host, db, port, user, pass);
        this.addOptions();
    }

    public DatabaseMeta() {
        this.setDefault();
        this.addOptions();
    }

    public void setDefault() {
        this.setValues("", "Oracle", "Native", "", "", "1521", "", "");
    }

    public void addOptions() {
        String mySQL = new MySQLDatabaseMeta().getDatabaseTypeDesc();
        this.addExtraOption(mySQL, "defaultFetchSize", "500");
        this.addExtraOption(mySQL, "useCursorFetch", "true");
        String infoBright = new InfobrightDatabaseMeta().getDatabaseTypeDesc();
        this.addExtraOption(infoBright, "characterEncoding", "UTF-8");
    }

    public DatabaseInterface getDatabaseInterface() {
        return this.databaseInterface;
    }

    public void setDatabaseInterface(DatabaseInterface databaseInterface) {
        this.databaseInterface = databaseInterface;
    }

    public static final DatabaseInterface getDatabaseInterface(String databaseType) throws KettleDatabaseException {
        return (DatabaseInterface)DatabaseMeta.findDatabaseInterface(databaseType).clone();
    }

    private static final DatabaseInterface findDatabaseInterface(String databaseTypeDesc) throws KettleDatabaseException {
        DatabaseInterface[] di = DatabaseMeta.getDatabaseInterfaces();
        for (int i = 0; i < di.length; ++i) {
            if (!di[i].getDatabaseTypeDesc().equalsIgnoreCase(databaseTypeDesc) && !di[i].getDatabaseTypeDescLong().equalsIgnoreCase(databaseTypeDesc)) continue;
            return di[i];
        }
        throw new KettleDatabaseException("database type [" + databaseTypeDesc + "] couldn't be found!");
    }

    public long getID() {
        return this.databaseInterface.getId();
    }

    public void setID(long id) {
        this.databaseInterface.setId(id);
    }

    public Object clone() {
        DatabaseMeta databaseMeta = new DatabaseMeta();
        databaseMeta.replaceMeta(this);
        databaseMeta.setID(-1L);
        return databaseMeta;
    }

    public void replaceMeta(DatabaseMeta databaseMeta) {
        this.setValues(databaseMeta.getName(), databaseMeta.getDatabaseTypeDesc(), databaseMeta.getAccessTypeDesc(), databaseMeta.getHostname(), databaseMeta.getDatabaseName(), databaseMeta.getDatabasePortNumberString(), databaseMeta.getUsername(), databaseMeta.getPassword());
        this.setServername(databaseMeta.getServername());
        this.setDataTablespace(databaseMeta.getDataTablespace());
        this.setIndexTablespace(databaseMeta.getIndexTablespace());
        this.databaseInterface = (DatabaseInterface)databaseMeta.databaseInterface.clone();
        this.setID(databaseMeta.getID());
        this.setChanged();
    }

    public void setValues(String name, String type, String access, String host, String db, String port, String user, String pass) {
        try {
            this.databaseInterface = DatabaseMeta.getDatabaseInterface(type);
        }
        catch (KettleDatabaseException kde) {
            throw new RuntimeException("Database type not found!", kde);
        }
        this.setName(name);
        this.setAccessType(DatabaseMeta.getAccessType(access));
        this.setHostname(host);
        this.setDBName(db);
        this.setDBPort(port);
        this.setUsername(user);
        this.setPassword(pass);
        this.setServername(null);
        this.setChanged(false);
    }

    public void setDatabaseType(String type) {
        DatabaseInterface oldInterface = this.databaseInterface;
        try {
            this.databaseInterface = DatabaseMeta.getDatabaseInterface(type);
        }
        catch (KettleDatabaseException kde) {
            throw new RuntimeException("Database type [" + type + "] not found!", kde);
        }
        this.setName(oldInterface.getName());
        this.setAccessType(oldInterface.getAccessType());
        this.setHostname(oldInterface.getHostname());
        this.setDBName(oldInterface.getDatabaseName());
        this.setDBPort(oldInterface.getDatabasePortNumberString());
        this.setUsername(oldInterface.getUsername());
        this.setPassword(oldInterface.getPassword());
        this.setServername(oldInterface.getServername());
        this.setDataTablespace(oldInterface.getDataTablespace());
        this.setIndexTablespace(oldInterface.getIndexTablespace());
        this.setChanged(oldInterface.isChanged());
    }

    public void setValues(DatabaseMeta info) {
        this.databaseInterface = (DatabaseInterface)info.databaseInterface.clone();
    }

    public void setName(String name) {
        this.databaseInterface.setName(name);
    }

    public String getName() {
        return this.databaseInterface.getName();
    }

    public int getDatabaseType() {
        return this.databaseInterface.getDatabaseType();
    }

    public int getAccessType() {
        return this.databaseInterface.getAccessType();
    }

    public void setAccessType(int access_type) {
        this.databaseInterface.setAccessType(access_type);
    }

    public String getDatabaseTypeDesc() {
        return this.databaseInterface.getDatabaseTypeDesc();
    }

    public String getAccessTypeDesc() {
        return dbAccessTypeCode[this.getAccessType()];
    }

    public String getHostname() {
        return this.databaseInterface.getHostname();
    }

    public void setHostname(String hostname) {
        this.databaseInterface.setHostname(hostname);
    }

    public String getDatabasePortNumberString() {
        return this.databaseInterface.getDatabasePortNumberString();
    }

    public void setDBPort(String db_port) {
        this.databaseInterface.setDatabasePortNumberString(db_port);
    }

    public String getDatabaseName() {
        return this.databaseInterface.getDatabaseName();
    }

    public void setDBName(String databaseName) {
        this.databaseInterface.setDatabaseName(databaseName);
    }

    public String getUsername() {
        return this.databaseInterface.getUsername();
    }

    public void setUsername(String username) {
        this.databaseInterface.setUsername(username);
    }

    public String getPassword() {
        return this.databaseInterface.getPassword();
    }

    public void setPassword(String password) {
        this.databaseInterface.setPassword(password);
    }

    public void setServername(String servername) {
        this.databaseInterface.setServername(servername);
    }

    public String getServername() {
        return this.databaseInterface.getServername();
    }

    public String getDataTablespace() {
        return this.databaseInterface.getDataTablespace();
    }

    public void setDataTablespace(String data_tablespace) {
        this.databaseInterface.setDataTablespace(data_tablespace);
    }

    public String getIndexTablespace() {
        return this.databaseInterface.getIndexTablespace();
    }

    public void setIndexTablespace(String index_tablespace) {
        this.databaseInterface.setIndexTablespace(index_tablespace);
    }

    public void setChanged() {
        this.setChanged(true);
    }

    public void setChanged(boolean ch) {
        this.databaseInterface.setChanged(ch);
    }

    public boolean hasChanged() {
        return this.databaseInterface.isChanged();
    }

    public String toString() {
        return this.getName();
    }

    public Properties getAttributes() {
        return this.databaseInterface.getAttributes();
    }

    public void setAttributes(Properties attributes) {
        this.databaseInterface.setAttributes(attributes);
    }

    public DatabaseMeta(String xml) throws KettleXMLException {
        this(XMLHandler.getSubNode((Node)XMLHandler.loadXMLString((String)xml), (String)XML_TAG));
    }

    public DatabaseMeta(Node con) throws KettleXMLException {
        this();
        try {
            String type = XMLHandler.getTagValue((Node)con, (String)"type");
            try {
                this.databaseInterface = DatabaseMeta.getDatabaseInterface(type);
            }
            catch (KettleDatabaseException kde) {
                throw new KettleXMLException("Unable to create new database interface", (Throwable)kde);
            }
            this.setName(XMLHandler.getTagValue((Node)con, (String)"name"));
            this.setHostname(XMLHandler.getTagValue((Node)con, (String)"server"));
            String acc = XMLHandler.getTagValue((Node)con, (String)"access");
            this.setAccessType(DatabaseMeta.getAccessType(acc));
            this.setDBName(XMLHandler.getTagValue((Node)con, (String)"database"));
            this.setDBPort(XMLHandler.getTagValue((Node)con, (String)"port"));
            this.setUsername(XMLHandler.getTagValue((Node)con, (String)"username"));
            this.setPassword(Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)con, (String)"password")));
            this.setServername(XMLHandler.getTagValue((Node)con, (String)"servername"));
            this.setDataTablespace(XMLHandler.getTagValue((Node)con, (String)"data_tablespace"));
            this.setIndexTablespace(XMLHandler.getTagValue((Node)con, (String)"index_tablespace"));
            Node attrsnode = XMLHandler.getSubNode((Node)con, (String)"attributes");
            if (attrsnode != null) {
                int nr = XMLHandler.countNodes((Node)attrsnode, (String)"attribute");
                for (int i = 0; i < nr; ++i) {
                    Node attrnode = XMLHandler.getSubNodeByNr((Node)attrsnode, (String)"attribute", (int)i);
                    String code = XMLHandler.getTagValue((Node)attrnode, (String)"code");
                    String attribute = XMLHandler.getTagValue((Node)attrnode, (String)"attribute");
                    if (code == null || attribute == null) continue;
                    this.getAttributes().put(code, attribute);
                }
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load database connection info from XML node", (Throwable)e);
        }
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer(250);
        retval.append("  <").append(XML_TAG).append('>').append(Const.CR);
        retval.append("    ").append(XMLHandler.addTagValue((String)"name", (String)this.getName()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"server", (String)this.getHostname()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"type", (String)this.getDatabaseTypeDesc()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"access", (String)this.getAccessTypeDesc()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"database", (String)this.getDatabaseName()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"port", (String)this.getDatabasePortNumberString()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"username", (String)this.getUsername()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.getPassword())));
        retval.append("    ").append(XMLHandler.addTagValue((String)"servername", (String)this.getServername()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"data_tablespace", (String)this.getDataTablespace()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"index_tablespace", (String)this.getIndexTablespace()));
        retval.append("    <attributes>").append(Const.CR);
        ArrayList<Object> list = new ArrayList<Object>(this.getAttributes().keySet());
        Collections.sort(list);
        for (String string : list) {
            String attribute = this.getAttributes().getProperty(string);
            if (Const.isEmpty((String)attribute)) continue;
            retval.append("      <attribute>" + XMLHandler.addTagValue((String)"code", (String)string, (boolean)false, (String[])new String[0]) + XMLHandler.addTagValue((String)"attribute", (String)attribute, (boolean)false, (String[])new String[0]) + "</attribute>" + Const.CR);
        }
        retval.append("    </attributes>").append(Const.CR);
        retval.append("  </connection>").append(Const.CR);
        return retval.toString();
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        return this.getName().equals(((DatabaseMeta)obj).getName());
    }

    public String getURL() throws KettleDatabaseException {
        return this.getURL(null);
    }

    public String getURL(String partitionId) throws KettleDatabaseException {
        String baseUrl;
        if (this.getAccessType() == 4) {
            // empty if block
        }
        if (this.isPartitioned() && !Const.isEmpty((String)partitionId)) {
            PartitionDatabaseMeta partition = this.getPartitionMeta(partitionId);
            String hostname = partition.getHostname();
            String port = partition.getPort();
            String databaseName = partition.getDatabaseName();
            baseUrl = this.databaseInterface.getURL(hostname, port, databaseName);
        } else {
            baseUrl = this.databaseInterface.getURL(this.getHostname(), this.getDatabasePortNumberString(), this.getDatabaseName());
        }
        StringBuffer url = new StringBuffer(this.environmentSubstitute(baseUrl));
        if (this.databaseInterface.supportsOptionsInURL()) {
            String optionIndicator = this.getExtraOptionIndicator();
            String optionSeparator = this.getExtraOptionSeparator();
            String valueSeparator = this.getExtraOptionValueSeparator();
            Map<String, String> map = this.getExtraOptions();
            if (map.size() > 0) {
                Iterator<String> iterator = map.keySet().iterator();
                boolean first = true;
                while (iterator.hasNext()) {
                    String typedParameter = iterator.next();
                    int dotIndex = typedParameter.indexOf(46);
                    if (dotIndex < 0) continue;
                    String typeCode = typedParameter.substring(0, dotIndex);
                    String parameter = typedParameter.substring(dotIndex + 1);
                    String value = map.get(typedParameter);
                    if (!this.databaseInterface.getDatabaseTypeDesc().equals(typeCode)) continue;
                    if (first && url.indexOf(valueSeparator) == -1) {
                        url.append(optionIndicator);
                    } else {
                        url.append(optionSeparator);
                    }
                    url.append(parameter);
                    if (!Const.isEmpty((String)value) && !value.equals(EMPTY_OPTIONS_STRING)) {
                        url.append(valueSeparator).append(value);
                    }
                    first = false;
                }
            }
        }
        return url.toString();
    }

    public Properties getConnectionProperties() {
        Properties properties = new Properties();
        Map<String, String> map = this.getExtraOptions();
        if (map.size() > 0) {
            for (String typedParameter : map.keySet()) {
                int dotIndex = typedParameter.indexOf(46);
                if (dotIndex < 0) continue;
                String typeCode = typedParameter.substring(0, dotIndex);
                String parameter = typedParameter.substring(dotIndex + 1);
                String value = map.get(typedParameter);
                if (!this.databaseInterface.getDatabaseTypeDesc().equals(typeCode)) continue;
                if (value != null && value.equals(EMPTY_OPTIONS_STRING)) {
                    value = "";
                }
                properties.put(parameter, this.environmentSubstitute(Const.NVL((String)value, (String)"")));
            }
        }
        return properties;
    }

    public String getExtraOptionIndicator() {
        return this.databaseInterface.getExtraOptionIndicator();
    }

    public String getExtraOptionSeparator() {
        return this.databaseInterface.getExtraOptionSeparator();
    }

    public String getExtraOptionValueSeparator() {
        return this.databaseInterface.getExtraOptionValueSeparator();
    }

    public void addExtraOption(String databaseTypeCode, String option, String value) {
        this.databaseInterface.addExtraOption(databaseTypeCode, option, value);
    }

    public boolean supportsTransactions() {
        return this.databaseInterface.supportsTransactions();
    }

    public boolean supportsAutoinc() {
        return this.databaseInterface.supportsAutoInc();
    }

    public boolean supportsSequences() {
        return this.databaseInterface.supportsSequences();
    }

    public String getSQLSequenceExists(String sequenceName) {
        return this.databaseInterface.getSQLSequenceExists(sequenceName);
    }

    public boolean supportsBitmapIndex() {
        return this.databaseInterface.supportsBitmapIndex();
    }

    public boolean supportsSetLong() {
        return this.databaseInterface.supportsSetLong();
    }

    public boolean supportsSchemas() {
        return this.databaseInterface.supportsSchemas();
    }

    public boolean supportsCatalogs() {
        return this.databaseInterface.supportsCatalogs();
    }

    public boolean supportsEmptyTransactions() {
        return this.databaseInterface.supportsEmptyTransactions();
    }

    public boolean supportsSetCharacterStream() {
        return this.databaseInterface.supportsSetCharacterStream();
    }

    public int getMaxTextFieldLength() {
        return this.databaseInterface.getMaxTextFieldLength();
    }

    public static final int getDatabaseType(String dbTypeDesc) {
        if (dbTypeDesc.equalsIgnoreCase("ODBC-ACCESS")) {
            return 4;
        }
        try {
            DatabaseInterface di = DatabaseMeta.getDatabaseInterface(dbTypeDesc);
            return di.getDatabaseType();
        }
        catch (KettleDatabaseException kde) {
            return 0;
        }
    }

    public static final String getDBTypeDesc(int dbtype) {
        return DatabaseMeta.getDatabaseTypeCode(dbtype);
    }

    public static final String getDatabaseTypeCode(int dbtype) {
        DatabaseInterface[] di = DatabaseMeta.getDatabaseInterfaces();
        for (int i = 0; i < di.length; ++i) {
            if (di[i].getDatabaseType() != dbtype) continue;
            return di[i].getDatabaseTypeDesc();
        }
        return null;
    }

    public static final String getDatabaseTypeDesc(int dbtype) {
        DatabaseInterface[] di = DatabaseMeta.getDatabaseInterfaces();
        for (int i = 0; i < di.length; ++i) {
            if (di[i].getDatabaseType() != dbtype) continue;
            return di[i].getDatabaseTypeDescLong();
        }
        return null;
    }

    public static final int getAccessType(String dbaccess) {
        int i;
        if (dbaccess == null) {
            return 0;
        }
        for (i = 0; i < dbAccessTypeCode.length; ++i) {
            if (!dbAccessTypeCode[i].equalsIgnoreCase(dbaccess)) continue;
            return i;
        }
        for (i = 0; i < dbAccessTypeDesc.length; ++i) {
            if (!dbAccessTypeDesc[i].equalsIgnoreCase(dbaccess)) continue;
            return i;
        }
        return 0;
    }

    public static final String getAccessTypeDesc(int dbaccess) {
        if (dbaccess < 0) {
            return null;
        }
        if (dbaccess > dbAccessTypeCode.length) {
            return null;
        }
        return dbAccessTypeCode[dbaccess];
    }

    public static final String getAccessTypeDescLong(int dbaccess) {
        if (dbaccess < 0) {
            return null;
        }
        if (dbaccess > dbAccessTypeDesc.length) {
            return null;
        }
        return dbAccessTypeDesc[dbaccess];
    }

    public static final String[] getDBTypeDescLongList() {
        DatabaseInterface[] di = DatabaseMeta.getDatabaseInterfaces();
        String[] retval = new String[di.length];
        for (int i = 0; i < di.length; ++i) {
            retval[i] = di[i].getDatabaseTypeDescLong();
        }
        return retval;
    }

    public static final String[] getDBTypeDescList() {
        DatabaseInterface[] di = DatabaseMeta.getDatabaseInterfaces();
        String[] retval = new String[di.length];
        for (int i = 0; i < di.length; ++i) {
            retval[i] = di[i].getDatabaseTypeDesc();
        }
        return retval;
    }

    public static final DatabaseInterface[] getDatabaseInterfaces() {
        if (allDatabaseInterfaces != null) {
            return allDatabaseInterfaces;
        }
        Class<?>[] ic = DatabaseInterface.implementingClasses;
        allDatabaseInterfaces = new DatabaseInterface[ic.length];
        for (int i = 0; i < ic.length; ++i) {
            try {
                Class.forName(ic[i].getName());
                DatabaseMeta.allDatabaseInterfaces[i] = (DatabaseInterface)ic[i].newInstance();
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Error creating class for : " + ic[i].getName(), e);
            }
        }
        return allDatabaseInterfaces;
    }

    public static final int[] getAccessTypeList(String dbTypeDesc) {
        try {
            DatabaseInterface di = DatabaseMeta.findDatabaseInterface(dbTypeDesc);
            return di.getAccessTypeList();
        }
        catch (KettleDatabaseException kde) {
            return null;
        }
    }

    public static final int getPortForDBType(String strtype, String straccess) {
        try {
            DatabaseInterface di = DatabaseMeta.getDatabaseInterface(strtype);
            di.setAccessType(DatabaseMeta.getAccessType(straccess));
            return di.getDefaultDatabasePort();
        }
        catch (KettleDatabaseException kde) {
            return -1;
        }
    }

    public int getDefaultDatabasePort() {
        return this.databaseInterface.getDefaultDatabasePort();
    }

    public int getNotFoundTK(boolean use_autoinc) {
        return this.databaseInterface.getNotFoundTK(use_autoinc);
    }

    public String getDriverClass() {
        return this.environmentSubstitute(this.databaseInterface.getDriverClass());
    }

    public String stripCR(String sbsql) {
        return this.stripCR(new StringBuffer(sbsql));
    }

    public String stripCR(StringBuffer sbsql) {
        if (this.getDatabaseType() == 6 || this.getDatabaseType() == 8 || this.getDatabaseType() == 25) {
            for (int i = sbsql.length() - 1; i >= 0; --i) {
                if (sbsql.charAt(i) != '\n' && sbsql.charAt(i) != '\r') continue;
                sbsql.setCharAt(i, ' ');
            }
        }
        return sbsql.toString();
    }

    public String getSeqNextvalSQL(String sequenceName) {
        return this.databaseInterface.getSQLNextSequenceValue(sequenceName);
    }

    public String getSQLCurrentSequenceValue(String sequenceName) {
        return this.databaseInterface.getSQLCurrentSequenceValue(sequenceName);
    }

    public boolean isFetchSizeSupported() {
        return this.databaseInterface.isFetchSizeSupported();
    }

    public boolean needsPlaceHolder() {
        return this.databaseInterface.needsPlaceHolder();
    }

    public String getFunctionSum() {
        return this.databaseInterface.getFunctionSum();
    }

    public String getFunctionAverage() {
        return this.databaseInterface.getFunctionAverage();
    }

    public String getFunctionMaximum() {
        return this.databaseInterface.getFunctionMaximum();
    }

    public String getFunctionMinimum() {
        return this.databaseInterface.getFunctionMinimum();
    }

    public String getFunctionCount() {
        return this.databaseInterface.getFunctionCount();
    }

    public String[] checkParameters() {
        ArrayList<String> remarks = new ArrayList<String>();
        if (this.getDatabaseType() == 0) {
            remarks.add("No database type was choosen");
        }
        if (this.getName() == null || this.getName().length() == 0) {
            remarks.add("Please give this database connection a name");
        }
        if (!(this.isPartitioned() || this.getDatabaseType() == 17 || this.getDatabaseType() == 16 || this.getDatabaseName() != null && this.getDatabaseName().length() != 0)) {
            remarks.add("Please specify the name of the database");
        }
        return remarks.toArray(new String[remarks.size()]);
    }

    public String getSchemaTableCombination(String schemaName, String tableName) {
        if (Const.isEmpty((String)schemaName)) {
            if (Const.isEmpty((String)this.getPreferredSchemaName())) {
                return tableName;
            }
            return this.databaseInterface.getSchemaTableCombination(this.getPreferredSchemaName(), tableName);
        }
        return this.databaseInterface.getSchemaTableCombination(schemaName, tableName);
    }

    public boolean isClob(ValueMetaInterface v) {
        boolean retval = true;
        if (v != null && v.getLength() >= 9999999) {
            return true;
        }
        retval = false;
        return retval;
    }

    public String getFieldDefinition(ValueMetaInterface v, String tk, String pk, boolean use_autoinc) {
        return this.getFieldDefinition(v, tk, pk, use_autoinc, true, true);
    }

    public String getFieldDefinition(ValueMetaInterface v, String tk, String pk, boolean use_autoinc, boolean add_fieldname, boolean add_cr) {
        return this.databaseInterface.getFieldDefinition(v, tk, pk, use_autoinc, add_fieldname, add_cr);
    }

    public String getLimitClause(int nrRows) {
        return this.databaseInterface.getLimitClause(nrRows);
    }

    public String getSQLQueryFields(String tableName) {
        return this.databaseInterface.getSQLQueryFields(tableName);
    }

    public String getAddColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        String retval = this.databaseInterface.getAddColumnStatement(tablename, v, tk, use_autoinc, pk, semicolon);
        retval = retval + Const.CR;
        if (semicolon) {
            retval = retval + ";" + Const.CR;
        }
        return retval;
    }

    public String getDropColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        String retval = this.databaseInterface.getDropColumnStatement(tablename, v, tk, use_autoinc, pk, semicolon);
        retval = retval + Const.CR;
        if (semicolon) {
            retval = retval + ";" + Const.CR;
        }
        return retval;
    }

    public String getModifyColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        String retval = this.databaseInterface.getModifyColumnStatement(tablename, v, tk, use_autoinc, pk, semicolon);
        retval = retval + Const.CR;
        if (semicolon) {
            retval = retval + ";" + Const.CR;
        }
        return retval;
    }

    public String[] getReservedWords() {
        return this.databaseInterface.getReservedWords();
    }

    public boolean quoteReservedWords() {
        return this.databaseInterface.quoteReservedWords();
    }

    public String getStartQuote() {
        return this.databaseInterface.getStartQuote();
    }

    public String getEndQuote() {
        return this.databaseInterface.getEndQuote();
    }

    public String quoteField(String field) {
        if (Const.isEmpty((String)field)) {
            return null;
        }
        if (this.isForcingIdentifiersToLowerCase()) {
            field = field.toLowerCase();
        } else if (this.isForcingIdentifiersToUpperCase()) {
            field = field.toUpperCase();
        }
        if (field.indexOf(this.getStartQuote()) >= 0 || field.indexOf(this.getEndQuote()) >= 0) {
            return field;
        }
        if (this.isReservedWord(field) && this.quoteReservedWords()) {
            return this.handleCase(this.getStartQuote() + field + this.getEndQuote());
        }
        if (this.databaseInterface.isQuoteAllFields() || this.hasSpacesInField(field) || this.hasSpecialCharInField(field) || this.hasDotInField(field)) {
            return this.getStartQuote() + field + this.getEndQuote();
        }
        return field;
    }

    private String handleCase(String field) {
        if (this.databaseInterface.isDefaultingToUppercase()) {
            return field.toUpperCase();
        }
        return field.toLowerCase();
    }

    public boolean isInNeedOfQuoting(String fieldname) {
        return this.isReservedWord(fieldname) || this.hasSpacesInField(fieldname);
    }

    public boolean isReservedWord(String word) {
        String[] reserved = this.getReservedWords();
        return Const.indexOfString((String)word, (String[])reserved) >= 0;
    }

    public boolean hasSpacesInField(String fieldname) {
        if (fieldname == null) {
            return false;
        }
        return fieldname.indexOf(32) >= 0;
    }

    public boolean hasSpecialCharInField(String fieldname) {
        if (fieldname == null) {
            return false;
        }
        if (fieldname.indexOf(47) >= 0) {
            return true;
        }
        if (fieldname.indexOf(45) >= 0) {
            return true;
        }
        if (fieldname.indexOf(43) >= 0) {
            return true;
        }
        if (fieldname.indexOf(44) >= 0) {
            return true;
        }
        if (fieldname.indexOf(42) >= 0) {
            return true;
        }
        if (fieldname.indexOf(40) >= 0) {
            return true;
        }
        if (fieldname.indexOf(41) >= 0) {
            return true;
        }
        if (fieldname.indexOf(123) >= 0) {
            return true;
        }
        if (fieldname.indexOf(125) >= 0) {
            return true;
        }
        if (fieldname.indexOf(91) >= 0) {
            return true;
        }
        if (fieldname.indexOf(93) >= 0) {
            return true;
        }
        if (fieldname.indexOf(37) >= 0) {
            return true;
        }
        return fieldname.indexOf(64) >= 0;
    }

    public boolean hasDotInField(String fieldname) {
        if (fieldname == null) {
            return false;
        }
        return fieldname.indexOf(46) >= 0;
    }

    public boolean replaceReservedWords(RowMetaInterface fields) {
        boolean hasReservedWords = false;
        for (int i = 0; i < fields.size(); ++i) {
            ValueMetaInterface v = fields.getValueMeta(i);
            if (!this.isReservedWord(v.getName())) continue;
            hasReservedWords = true;
            v.setName(this.quoteField(v.getName()));
        }
        return hasReservedWords;
    }

    public int getNrReservedWords(RowMetaInterface fields) {
        int nrReservedWords = 0;
        for (int i = 0; i < fields.size(); ++i) {
            ValueMetaInterface v = fields.getValueMeta(i);
            if (!this.isReservedWord(v.getName())) continue;
            ++nrReservedWords;
        }
        return nrReservedWords;
    }

    public String[] getTableTypes() {
        return this.databaseInterface.getTableTypes();
    }

    public String[] getViewTypes() {
        return this.databaseInterface.getViewTypes();
    }

    public String[] getSynonymTypes() {
        return this.databaseInterface.getSynonymTypes();
    }

    public boolean useSchemaNameForTableList() {
        return this.databaseInterface.useSchemaNameForTableList();
    }

    public boolean supportsViews() {
        return this.databaseInterface.supportsViews();
    }

    public boolean supportsSynonyms() {
        return this.databaseInterface.supportsSynonyms();
    }

    public String getSQLListOfProcedures() {
        return this.databaseInterface.getSQLListOfProcedures();
    }

    public String getTruncateTableStatement(String schema, String tableName) {
        return this.databaseInterface.getTruncateTableStatement(this.getQuotedSchemaTableCombination(schema, tableName));
    }

    public boolean supportsFloatRoundingOnUpdate() {
        return this.databaseInterface.supportsFloatRoundingOnUpdate();
    }

    public String getSQLLockTables(String[] tableNames) {
        return this.databaseInterface.getSQLLockTables(tableNames);
    }

    public String getSQLUnlockTables(String[] tableNames) {
        return this.databaseInterface.getSQLUnlockTables(tableNames);
    }

    public List<RowMetaAndData> getFeatureSummary() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaAndData r = null;
        String par = "Parameter";
        String val = "Value";
        ValueMeta testValue = new ValueMeta("FIELD", 2);
        testValue.setLength(30);
        if (this.databaseInterface != null) {
            int i;
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, (Object)"Database type");
            r.addValue("Value", 2, (Object)this.getDatabaseTypeDesc());
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, (Object)"Access type");
            r.addValue("Value", 2, (Object)this.getAccessTypeDesc());
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, (Object)"Database name");
            r.addValue("Value", 2, (Object)this.getDatabaseName());
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, (Object)"Server hostname");
            r.addValue("Value", 2, (Object)this.getHostname());
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, (Object)"Service port");
            r.addValue("Value", 2, (Object)this.getDatabasePortNumberString());
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, (Object)"Username");
            r.addValue("Value", 2, (Object)this.getUsername());
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, (Object)"Informix server name");
            r.addValue("Value", 2, (Object)this.getServername());
            list.add(r);
            Enumeration<Object> keys = this.getAttributes().keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = this.getAttributes().getProperty(key);
                r = new RowMetaAndData();
                r.addValue("Parameter", 2, (Object)("Extra attribute [" + key + "]"));
                r.addValue("Value", 2, (Object)value);
                list.add(r);
            }
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, (Object)"Driver class");
            r.addValue("Value", 2, (Object)this.getDriverClass());
            list.add(r);
            String pwd = this.getPassword();
            this.setPassword("password");
            String url = "";
            try {
                url = this.getURL();
            }
            catch (KettleDatabaseException e) {
                // empty catch block
            }
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, (Object)"URL");
            r.addValue("Value", 2, (Object)url);
            list.add(r);
            this.setPassword(pwd);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, (Object)"SQL: next sequence value");
            r.addValue("Value", 2, (Object)this.getSeqNextvalSQL("SEQUENCE"));
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, (Object)"supported: set fetch size");
            r.addValue("Value", 2, (Object)(this.isFetchSizeSupported() ? "Y" : "N"));
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, (Object)"auto increment field needs placeholder");
            r.addValue("Value", 2, (Object)(this.needsPlaceHolder() ? "Y" : "N"));
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, (Object)"SUM aggregate function");
            r.addValue("Value", 2, (Object)this.getFunctionSum());
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, (Object)"AVG aggregate function");
            r.addValue("Value", 2, (Object)this.getFunctionAverage());
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, (Object)"MIN aggregate function");
            r.addValue("Value", 2, (Object)this.getFunctionMinimum());
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, (Object)"MAX aggregate function");
            r.addValue("Value", 2, (Object)this.getFunctionMaximum());
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, (Object)"COUNT aggregate function");
            r.addValue("Value", 2, (Object)this.getFunctionCount());
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, (Object)"Schema / Table combination");
            r.addValue("Value", 2, (Object)this.getSchemaTableCombination("SCHEMA", "TABLE"));
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, (Object)"LIMIT clause for 100 rows");
            r.addValue("Value", 2, (Object)this.getLimitClause(100));
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, (Object)"Add column statement");
            r.addValue("Value", 2, (Object)this.getAddColumnStatement("TABLE", (ValueMetaInterface)testValue, null, false, null, false));
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, (Object)"Drop column statement");
            r.addValue("Value", 2, (Object)this.getDropColumnStatement("TABLE", (ValueMetaInterface)testValue, null, false, null, false));
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, (Object)"Modify column statement");
            r.addValue("Value", 2, (Object)this.getModifyColumnStatement("TABLE", (ValueMetaInterface)testValue, null, false, null, false));
            list.add(r);
            String reserved = "";
            if (this.getReservedWords() != null) {
                for (int i2 = 0; i2 < this.getReservedWords().length; ++i2) {
                    reserved = reserved + (i2 > 0 ? ", " : "") + this.getReservedWords()[i2];
                }
            }
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, (Object)"List of reserved words");
            r.addValue("Value", 2, (Object)reserved);
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, (Object)"Quote reserved words?");
            r.addValue("Value", 2, (Object)(this.quoteReservedWords() ? "Y" : "N"));
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, (Object)"Start quote for reserved words");
            r.addValue("Value", 2, (Object)this.getStartQuote());
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, (Object)"End quote for reserved words");
            r.addValue("Value", 2, (Object)this.getEndQuote());
            list.add(r);
            String types = "";
            String[] slist = this.getTableTypes();
            if (slist != null) {
                for (i = 0; i < slist.length; ++i) {
                    types = types + (i > 0 ? ", " : "") + slist[i];
                }
            }
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, (Object)"List of JDBC table types");
            r.addValue("Value", 2, (Object)types);
            list.add(r);
            types = "";
            slist = this.getViewTypes();
            if (slist != null) {
                for (i = 0; i < slist.length; ++i) {
                    types = types + (i > 0 ? ", " : "") + slist[i];
                }
            }
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, (Object)"List of JDBC view types");
            r.addValue("Value", 2, (Object)types);
            list.add(r);
            types = "";
            slist = this.getSynonymTypes();
            if (slist != null) {
                for (i = 0; i < slist.length; ++i) {
                    types = types + (i > 0 ? ", " : "") + slist[i];
                }
            }
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, (Object)"List of JDBC synonym types");
            r.addValue("Value", 2, (Object)types);
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, (Object)"use schema name to get table list?");
            r.addValue("Value", 2, (Object)(this.useSchemaNameForTableList() ? "Y" : "N"));
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, (Object)"supports views?");
            r.addValue("Value", 2, (Object)(this.supportsViews() ? "Y" : "N"));
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, (Object)"supports synonyms?");
            r.addValue("Value", 2, (Object)(this.supportsSynonyms() ? "Y" : "N"));
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, (Object)"SQL: list of procedures");
            r.addValue("Value", 2, (Object)this.getSQLListOfProcedures());
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, (Object)"SQL: truncate table");
            r.addValue("Value", 2, (Object)this.getTruncateTableStatement(null, "TABLE"));
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, (Object)"supports floating point rounding on update/insert");
            r.addValue("Value", 2, (Object)(this.supportsFloatRoundingOnUpdate() ? "Y" : "N"));
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, (Object)"supports timestamp-date conversion");
            r.addValue("Value", 2, (Object)(this.supportsTimeStampToDateConversion() ? "Y" : "N"));
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, (Object)"supports batch updates");
            r.addValue("Value", 2, (Object)(this.supportsBatchUpdates() ? "Y" : "N"));
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, (Object)"supports boolean data type");
            r.addValue("Value", 2, (Object)(this.supportsBooleanDataType() ? "Y" : "N"));
            list.add(r);
        }
        return list;
    }

    public boolean supportsTimeStampToDateConversion() {
        return this.databaseInterface.supportsTimeStampToDateConversion();
    }

    public boolean supportsBatchUpdates() {
        return this.databaseInterface.supportsBatchUpdates();
    }

    public boolean supportsBooleanDataType() {
        return this.databaseInterface.supportsBooleanDataType();
    }

    public void setSupportsBooleanDataType(boolean b) {
        this.databaseInterface.setSupportsBooleanDataType(b);
    }

    public void quoteReservedWords(RowMetaInterface fields) {
        for (int i = 0; i < fields.size(); ++i) {
            ValueMetaInterface v = fields.getValueMeta(i);
            v.setName(this.quoteField(v.getName()));
        }
    }

    public Map<String, String> getExtraOptions() {
        return this.databaseInterface.getExtraOptions();
    }

    public boolean supportsOptionsInURL() {
        return this.databaseInterface.supportsOptionsInURL();
    }

    public String getExtraOptionsHelpText() {
        return this.databaseInterface.getExtraOptionsHelpText();
    }

    public boolean supportsGetBlob() {
        return this.databaseInterface.supportsGetBlob();
    }

    public String getConnectSQL() {
        return this.databaseInterface.getConnectSQL();
    }

    public void setConnectSQL(String sql) {
        this.databaseInterface.setConnectSQL(sql);
    }

    public boolean supportsSetMaxRows() {
        return this.databaseInterface.supportsSetMaxRows();
    }

    public String verifyAndModifyDatabaseName(List<DatabaseMeta> databases, String oldname) {
        String name = this.getName();
        if (name.equalsIgnoreCase(oldname)) {
            return name;
        }
        int nr = 2;
        while (DatabaseMeta.findDatabase(databases, this.getName()) != null) {
            this.setName(name + " " + nr);
            ++nr;
        }
        return this.getName();
    }

    public boolean isUsingConnectionPool() {
        return this.databaseInterface.isUsingConnectionPool();
    }

    public void setUsingConnectionPool(boolean usePool) {
        this.databaseInterface.setUsingConnectionPool(usePool);
    }

    public int getMaximumPoolSize() {
        return this.databaseInterface.getMaximumPoolSize();
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.databaseInterface.setMaximumPoolSize(maximumPoolSize);
    }

    public int getInitialPoolSize() {
        return this.databaseInterface.getInitialPoolSize();
    }

    public void setInitialPoolSize(int initalPoolSize) {
        this.databaseInterface.setInitialPoolSize(initalPoolSize);
    }

    public boolean isPartitioned() {
        return this.databaseInterface.isPartitioned();
    }

    public void setPartitioned(boolean partitioned) {
        this.databaseInterface.setPartitioned(partitioned);
    }

    public PartitionDatabaseMeta[] getPartitioningInformation() {
        if (!this.isPartitioned()) {
            return new PartitionDatabaseMeta[0];
        }
        return this.databaseInterface.getPartitioningInformation();
    }

    public void setPartitioningInformation(PartitionDatabaseMeta[] partitionInfo) {
        this.databaseInterface.setPartitioningInformation(partitionInfo);
    }

    public PartitionDatabaseMeta getPartitionMeta(String partitionId) {
        PartitionDatabaseMeta[] partitionInfo = this.getPartitioningInformation();
        for (int i = 0; i < partitionInfo.length; ++i) {
            if (!partitionInfo[i].getPartitionId().equals(partitionId)) continue;
            return partitionInfo[i];
        }
        return null;
    }

    public Properties getConnectionPoolingProperties() {
        return this.databaseInterface.getConnectionPoolingProperties();
    }

    public void setConnectionPoolingProperties(Properties properties) {
        this.databaseInterface.setConnectionPoolingProperties(properties);
    }

    public String getSQLTableExists(String tablename) {
        return this.databaseInterface.getSQLTableExists(tablename);
    }

    public String getSQLColumnExists(String columnname, String tablename) {
        return this.databaseInterface.getSQLColumnExists(columnname, tablename);
    }

    public boolean needsToLockAllTables() {
        return this.databaseInterface.needsToLockAllTables();
    }

    public String getQuotedSchemaTableCombination(String schemaName, String tableName) {
        if (Const.isEmpty((String)schemaName)) {
            return this.getSchemaTableCombination(this.quoteField(this.getPreferredSchemaName()), this.quoteField(tableName));
        }
        return this.getSchemaTableCombination(this.quoteField(schemaName), this.quoteField(tableName));
    }

    public boolean isStreamingResults() {
        return this.databaseInterface.isStreamingResults();
    }

    public void setStreamingResults(boolean useStreaming) {
        this.databaseInterface.setStreamingResults(useStreaming);
    }

    public boolean isQuoteAllFields() {
        return this.databaseInterface.isQuoteAllFields();
    }

    public void setQuoteAllFields(boolean quoteAllFields) {
        this.databaseInterface.setQuoteAllFields(quoteAllFields);
    }

    public boolean isForcingIdentifiersToLowerCase() {
        return this.databaseInterface.isForcingIdentifiersToLowerCase();
    }

    public void setForcingIdentifiersToLowerCase(boolean forceLowerCase) {
        this.databaseInterface.setForcingIdentifiersToLowerCase(forceLowerCase);
    }

    public boolean isForcingIdentifiersToUpperCase() {
        return this.databaseInterface.isForcingIdentifiersToUpperCase();
    }

    public void setForcingIdentifiersToUpperCase(boolean forceUpperCase) {
        this.databaseInterface.setForcingIdentifiersToUpperCase(forceUpperCase);
    }

    public static final DatabaseMeta findDatabase(List<? extends SharedObjectInterface> databases, String dbname) {
        if (databases == null) {
            return null;
        }
        for (int i = 0; i < databases.size(); ++i) {
            DatabaseMeta ci = (DatabaseMeta)databases.get(i);
            if (!ci.getName().equalsIgnoreCase(dbname)) continue;
            return ci;
        }
        return null;
    }

    public static final DatabaseMeta findDatabase(List<DatabaseMeta> databases, String dbname, String exclude) {
        if (databases == null) {
            return null;
        }
        for (int i = 0; i < databases.size(); ++i) {
            DatabaseMeta ci = databases.get(i);
            if (!ci.getName().equalsIgnoreCase(dbname)) continue;
            return ci;
        }
        return null;
    }

    public static final DatabaseMeta findDatabase(List<DatabaseMeta> databases, long id) {
        if (databases == null) {
            return null;
        }
        for (DatabaseMeta ci : databases) {
            if (ci.getID() != id) continue;
            return ci;
        }
        return null;
    }

    public void copyVariablesFrom(VariableSpace space) {
        this.variables.copyVariablesFrom(space);
    }

    public String environmentSubstitute(String aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public String[] environmentSubstitute(String[] aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public VariableSpace getParentVariableSpace() {
        return this.variables.getParentVariableSpace();
    }

    public void setParentVariableSpace(VariableSpace parent) {
        this.variables.setParentVariableSpace(parent);
    }

    public String getVariable(String variableName, String defaultValue) {
        return this.variables.getVariable(variableName, defaultValue);
    }

    public String getVariable(String variableName) {
        return this.variables.getVariable(variableName);
    }

    public boolean getBooleanValueOfVariable(String variableName, boolean defaultValue) {
        String value;
        if (!Const.isEmpty((String)variableName) && !Const.isEmpty((String)(value = this.environmentSubstitute(variableName)))) {
            return ValueMeta.convertStringToBoolean((String)value);
        }
        return defaultValue;
    }

    public void initializeVariablesFrom(VariableSpace parent) {
        this.variables.initializeVariablesFrom(parent);
    }

    public String[] listVariables() {
        return this.variables.listVariables();
    }

    public void setVariable(String variableName, String variableValue) {
        this.variables.setVariable(variableName, variableValue);
    }

    public void shareVariablesWith(VariableSpace space) {
        this.variables = space;
    }

    public void injectVariables(Map<String, String> prop) {
        this.variables.injectVariables(prop);
    }

    public String getSQLServerInstance() {
        return this.getExtraOptions().get("MSSQL.instance");
    }

    public void setSQLServerInstance(String instanceName) {
        this.addExtraOption("MSSQL", "instance", instanceName);
    }

    public boolean isUsingDoubleDecimalAsSchemaTableSeparator() {
        return this.databaseInterface.isUsingDoubleDecimalAsSchemaTableSeparator();
    }

    public void setUsingDoubleDecimalAsSchemaTableSeparator(boolean useDoubleDecimalSeparator) {
        this.databaseInterface.setUsingDoubleDecimalAsSchemaTableSeparator(useDoubleDecimalSeparator);
    }

    public boolean isRequiringTransactionsOnQueries() {
        return this.databaseInterface.isRequiringTransactionsOnQueries();
    }

    public String testConnection() {
        StringBuffer report = new StringBuffer();
        try {
            DatabaseFactoryInterface factory = this.getDatabaseFactory();
            return factory.getConnectionTestReport(this);
        }
        catch (ClassNotFoundException e) {
            report.append(Messages.getString("BaseDatabaseMeta.TestConnectionReportNotImplemented.Message")).append(Const.CR);
            report.append(Messages.getString("DatabaseMeta.report.ConnectionError", this.getName()) + e.toString() + Const.CR);
            report.append(Const.getStackTracker((Throwable)e) + Const.CR);
        }
        catch (Exception e) {
            report.append(Messages.getString("DatabaseMeta.report.ConnectionError", this.getName()) + e.toString() + Const.CR);
            report.append(Const.getStackTracker((Throwable)e) + Const.CR);
        }
        return report.toString();
    }

    public DatabaseFactoryInterface getDatabaseFactory() throws Exception {
        Class<?> clazz = Class.forName(this.databaseInterface.getDatabaseFactoryName());
        return (DatabaseFactoryInterface)clazz.newInstance();
    }

    public String getPreferredSchemaName() {
        return this.databaseInterface.getPreferredSchemaName();
    }

    public void setPreferredSchemaName(String preferredSchemaName) {
        this.databaseInterface.setPreferredSchemaName(preferredSchemaName);
    }

    static {
        dbAccessTypeCode = new String[]{"Native", "ODBC", "OCI", "Plugin", "JNDI"};
        dbAccessTypeDesc = new String[]{"Native (JDBC)", "ODBC", "OCI", "Plugin specific access method", "JNDI", "Custom"};
    }
}

