/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatResolver;
import org.apache.camel.spi.FactoryFinder;

public class DefaultDataFormatResolver
implements DataFormatResolver {
    public static final String DATAFORMAT_RESOURCE_PATH = "META-INF/services/org/apache/camel/dataformat/";
    protected FactoryFinder dataformatFactory;

    @Override
    public DataFormat resolveDataFormat(String name, CamelContext context) {
        DataFormat dataFormat = DefaultDataFormatResolver.lookup(context, name, DataFormat.class);
        if (dataFormat == null) {
            Class<?> type = null;
            try {
                if (this.dataformatFactory == null) {
                    this.dataformatFactory = context.getFactoryFinder(DATAFORMAT_RESOURCE_PATH);
                }
                type = this.dataformatFactory.findClass(name);
            }
            catch (NoFactoryAvailableException e) {
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid URI, no DataFormat registered for scheme: " + name, e);
            }
            if (type == null) {
                type = context.getClassResolver().resolveClass(name);
            }
            if (type != null) {
                if (DataFormat.class.isAssignableFrom(type)) {
                    dataFormat = (DataFormat)context.getInjector().newInstance(type);
                } else {
                    throw new IllegalArgumentException("Resolving dataformat: " + name + " detected type conflict: Not a DataFormat implementation. Found: " + type.getName());
                }
            }
        }
        return dataFormat;
    }

    private static <T> T lookup(CamelContext context, String ref, Class<T> type) {
        try {
            return context.getRegistry().lookupByNameAndType(ref, type);
        }
        catch (Exception e) {
            return null;
        }
    }
}

