/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.osgi;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.DefaultClassResolver;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiClassResolver
extends DefaultClassResolver {
    private static final Logger LOG = LoggerFactory.getLogger(OsgiClassResolver.class);
    private final CamelContext camelContext;
    private final BundleContext bundleContext;

    public OsgiClassResolver(CamelContext camelContext, BundleContext context) {
        super(camelContext);
        this.camelContext = camelContext;
        this.bundleContext = context;
    }

    @Override
    public Class<?> resolveClass(String name) {
        LOG.trace("Resolve class {}", (Object)name);
        name = ObjectHelper.normalizeClassName(name);
        if (ObjectHelper.isEmpty(name)) {
            return null;
        }
        Class<?> clazz = ObjectHelper.loadSimpleType(name);
        if (clazz == null) {
            clazz = this.doLoadClass(name, this.bundleContext.getBundle());
            if (LOG.isTraceEnabled()) {
                LOG.trace("Loading class {} using BundleContext {} -> {}", name, this.bundleContext.getBundle(), clazz);
            }
        }
        if (clazz == null && this.camelContext != null) {
            clazz = super.loadClass(name, this.camelContext.getApplicationContextClassLoader());
            if (LOG.isTraceEnabled()) {
                LOG.trace("Loading class {} using CamelContext {} -> {}", name, this.camelContext, clazz);
            }
        }
        return clazz;
    }

    @Override
    public <T> Class<T> resolveClass(String name, Class<T> type) {
        return CastUtils.cast(this.resolveClass(name));
    }

    @Override
    public InputStream loadResourceAsStream(String uri) {
        ObjectHelper.notEmpty(uri, "uri");
        String resolvedName = OsgiClassResolver.resolveUriPath(uri);
        URL url = this.loadResourceAsURL(resolvedName);
        InputStream answer = null;
        if (url != null) {
            try {
                answer = url.openStream();
            }
            catch (IOException ex) {
                throw new RuntimeException("Cannot load resource: " + uri, ex);
            }
        }
        if (answer == null) {
            answer = super.loadResourceAsStream(uri);
        }
        return answer;
    }

    @Override
    public URL loadResourceAsURL(String uri) {
        ObjectHelper.notEmpty(uri, "uri");
        String resolvedName = OsgiClassResolver.resolveUriPath(uri);
        URL answer = this.bundleContext.getBundle().getResource(resolvedName);
        if (answer == null) {
            answer = super.loadResourceAsURL(uri);
        }
        return answer;
    }

    @Override
    public Enumeration<URL> loadResourcesAsURL(String uri) {
        ObjectHelper.notEmpty(uri, "uri");
        try {
            String resolvedName = OsgiClassResolver.resolveUriPath(uri);
            return this.bundleContext.getBundle().getResources(resolvedName);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot load resource: " + uri, e);
        }
    }

    @Override
    public Enumeration<URL> loadAllResourcesAsURL(String uri) {
        ObjectHelper.notEmpty(uri, "uri");
        Vector answer = new Vector();
        try {
            String resolvedName = OsgiClassResolver.resolveUriPath(uri);
            Enumeration e = this.bundleContext.getBundle().getResources(resolvedName);
            while (e != null && e.hasMoreElements()) {
                answer.add(e.nextElement());
            }
            String path = FileUtil.onlyPath(uri);
            String name = FileUtil.stripPath(uri);
            if (path != null && name != null) {
                for (Bundle bundle : this.bundleContext.getBundles()) {
                    LOG.trace("Finding all entries in path: {} with pattern: {}", (Object)path, (Object)name);
                    e = bundle.findEntries(path, name, false);
                    while (e != null && e.hasMoreElements()) {
                        answer.add(e.nextElement());
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot load resource: " + uri, e);
        }
        return answer.elements();
    }

    protected Class<?> doLoadClass(String name, Bundle loader) {
        Class answer;
        block3: {
            ObjectHelper.notEmpty(name, "name");
            answer = null;
            if (loader != null) {
                try {
                    answer = loader.loadClass(name);
                }
                catch (ClassNotFoundException e) {
                    if (!LOG.isTraceEnabled()) break block3;
                    LOG.trace("Cannot load class: " + name + " using classloader: " + loader + ". This exception will be ignored.", e);
                }
            }
        }
        return answer;
    }

    private static String resolveUriPath(String name) {
        return FileUtil.compactPath(name, '/');
    }
}

