'''OpenGL extension EXT.convolution

This module customises the behaviour of the 
OpenGL.raw.GL.EXT.convolution to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension defines 1 and 2 dimensional convolution operations
	at a fixed location in the pixel transfer process.  Thus pixel drawing,
	reading, and copying, as well as texture image definition, are all
	candidates for convolution.  The convolution kernels are themselves
	treated as 1 and 2 dimensional images, which can be loaded from
	application memory or from the framebuffer.
	
	This extension is designed to accommodate 3D convolution, but the
	API is left for a future extension.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/convolution.txt
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL.EXT.convolution import *
### END AUTOGENERATED SECTION