/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.view.ViewLocale;

public final class LocaleUtils {
    private static final Logger logger = Logger.getLogger(LocaleUtils.class);
    private static final String MESSAGES_BASE_FILENAME = "Messages_";
    private static final String DEFAULT_LOCALE = "en_GB";
    public static final String LANGUAGE_LOCALE_REGEX = "[a-zA-Z]{2,8}";
    public static final String COUNTRY_LOCALE_REGEX = "[a-zA-Z]{2}|[0-9]{3}";

    private LocaleUtils() {
    }

    public static Pattern createMessagesPropertiesFilePattern() {
        return LocaleUtils.createResourceFilesPattern("Messages", ".properties");
    }

    public static String createResourceFilesRegex(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("Parameter fileName must not be null.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Parameter fileExtension must not be null.");
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + LANGUAGE_LOCALE_REGEX.length() + COUNTRY_LOCALE_REGEX.length() + string2.length() + 13);
        stringBuilder.append(Pattern.quote(string));
        stringBuilder.append("(?:_").append(LANGUAGE_LOCALE_REGEX);
        stringBuilder.append("(?:_").append(COUNTRY_LOCALE_REGEX).append(")?").append(")?");
        stringBuilder.append(Pattern.quote(string2));
        stringBuilder.append('$');
        return stringBuilder.toString();
    }

    public static Pattern createResourceFilesPattern(String string, String string2) {
        return Pattern.compile(LocaleUtils.createResourceFilesRegex(string, string2));
    }

    public static List<String> getAvailableLocales() {
        List<String> list = LocaleUtils.readAvailableLocales();
        Collections.sort(list);
        list.add(0, DEFAULT_LOCALE);
        return list;
    }

    private static List<String> readAvailableLocales() {
        MessagesPropertiesFilenameFilter messagesPropertiesFilenameFilter;
        File file = new File(Constant.getZapInstall(), "lang");
        String[] stringArray = file.list(messagesPropertiesFilenameFilter = new MessagesPropertiesFilenameFilter());
        if (stringArray == null || stringArray.length == 0) {
            logger.error((Object)("Failed to find any locale files in directory " + file.getAbsolutePath()));
            return new ArrayList<String>(0);
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        int n = MESSAGES_BASE_FILENAME.length();
        for (String string : Arrays.asList(stringArray)) {
            if (!string.startsWith(MESSAGES_BASE_FILENAME)) continue;
            arrayList.add(string.substring(n, string.indexOf(".")));
        }
        return arrayList;
    }

    public static ViewLocale getViewLocale(String string) {
        return new ViewLocale(string, LocaleUtils.getLocalDisplayName(string));
    }

    public static List<ViewLocale> getAvailableViewLocales() {
        List<String> list = LocaleUtils.readAvailableLocales();
        ArrayList<ViewLocale> arrayList = new ArrayList<ViewLocale>();
        if (!list.isEmpty()) {
            for (String string : list) {
                arrayList.add(new ViewLocale(string, LocaleUtils.getLocalDisplayName(string)));
            }
            Collections.sort(arrayList, new Comparator<ViewLocale>(){

                @Override
                public int compare(ViewLocale viewLocale, ViewLocale viewLocale2) {
                    return viewLocale.toString().compareTo(viewLocale2.toString());
                }
            });
        }
        arrayList.add(0, new ViewLocale(DEFAULT_LOCALE, LocaleUtils.getLocalDisplayName(DEFAULT_LOCALE)));
        return arrayList;
    }

    public static String getLocalDisplayName(String string) {
        String string2 = "" + string;
        if (string != null) {
            String[] stringArray = string.split("_");
            Locale locale = null;
            if (stringArray.length == 1) {
                locale = new Locale(stringArray[0]);
            } else if (stringArray.length == 2) {
                locale = new Locale(stringArray[0], stringArray[1]);
            } else if (stringArray.length == 3) {
                locale = new Locale(stringArray[0], stringArray[1], stringArray[2]);
            }
            if (locale != null) {
                string2 = locale.getDisplayLanguage(locale);
            }
        }
        return string2;
    }

    private static final class MessagesPropertiesFilenameFilter
    implements FilenameFilter {
        private final Pattern messagesPropertiesPattern = LocaleUtils.createMessagesPropertiesFilePattern();

        private MessagesPropertiesFilenameFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            return this.messagesPropertiesPattern.matcher(string).matches();
        }
    }
}

