/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.components.split.response;

import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.response.ResponseBodyStringHttpPanelViewModel;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.AutoDetectSyntaxHttpPanelTextArea;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.HttpPanelSyntaxHighlightTextArea;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.HttpPanelSyntaxHighlightTextView;
import org.zaproxy.zap.extension.search.SearchMatch;

public class HttpResponseBodyPanelSyntaxHighlightTextView
extends HttpPanelSyntaxHighlightTextView {
    public HttpResponseBodyPanelSyntaxHighlightTextView(ResponseBodyStringHttpPanelViewModel responseBodyStringHttpPanelViewModel) {
        super(responseBodyStringHttpPanelViewModel);
    }

    @Override
    protected HttpPanelSyntaxHighlightTextArea createHttpPanelTextArea() {
        return new HttpResponseBodyPanelSyntaxHighlightTextArea();
    }

    private static class HttpResponseBodyPanelSyntaxHighlightTextArea
    extends AutoDetectSyntaxHttpPanelTextArea {
        private static final long serialVersionUID = -8952571125337022950L;
        private static final String CSS = Constant.messages.getString("http.panel.view.syntaxtext.syntax.css");
        private static final String HTML = Constant.messages.getString("http.panel.view.syntaxtext.syntax.html");
        private static final String JAVASCRIPT = Constant.messages.getString("http.panel.view.syntaxtext.syntax.javascript");
        private static final String JSON = Constant.messages.getString("http.panel.view.syntaxtext.syntax.json");
        private static final String XML = Constant.messages.getString("http.panel.view.syntaxtext.syntax.xml");
        private static ResponseBodyTokenMakerFactory tokenMakerFactory = null;

        public HttpResponseBodyPanelSyntaxHighlightTextArea() {
            this.addSyntaxStyle(CSS, "text/css");
            this.addSyntaxStyle(HTML, "text/html");
            this.addSyntaxStyle(JAVASCRIPT, "text/javascript");
            this.addSyntaxStyle(JSON, "text/json");
            this.addSyntaxStyle(XML, "text/xml");
        }

        @Override
        public void search(Pattern pattern, List<SearchMatch> list) {
            Matcher matcher = pattern.matcher(this.getText());
            while (matcher.find()) {
                list.add(new SearchMatch(SearchMatch.Location.RESPONSE_BODY, matcher.start(), matcher.end()));
            }
        }

        @Override
        public void highlight(SearchMatch searchMatch) {
            if (!SearchMatch.Location.RESPONSE_BODY.equals((Object)searchMatch.getLocation())) {
                return;
            }
            int n = this.getText().length();
            if (searchMatch.getStart() > n || searchMatch.getEnd() > n) {
                return;
            }
            this.highlight(searchMatch.getStart(), searchMatch.getEnd());
        }

        @Override
        protected String detectSyntax(HttpMessage httpMessage) {
            String string;
            String string2 = null;
            if (httpMessage != null && (string = httpMessage.getResponseHeader().getHeader("Content-Type")) != null && !string.isEmpty()) {
                int n = (string = string.toLowerCase(Locale.ENGLISH)).indexOf(59);
                if (n != -1) {
                    string = string.substring(0, n).trim();
                }
                string2 = string.contains("javascript") ? "text/javascript" : (string.contains("json") ? "text/json" : (string.contains("xhtml") ? "text/html" : (string.contains("xml") ? "text/xml" : string)));
            }
            return string2;
        }

        @Override
        protected synchronized HttpPanelSyntaxHighlightTextArea.CustomTokenMakerFactory getTokenMakerFactory() {
            if (tokenMakerFactory == null) {
                tokenMakerFactory = new ResponseBodyTokenMakerFactory();
            }
            return tokenMakerFactory;
        }

        private static class ResponseBodyTokenMakerFactory
        extends HttpPanelSyntaxHighlightTextArea.CustomTokenMakerFactory {
            public ResponseBodyTokenMakerFactory() {
                String string = "org.fife.ui.rsyntaxtextarea.modes.";
                this.putMapping("text/css", string + "CSSTokenMaker");
                this.putMapping("text/html", string + "HTMLTokenMaker");
                this.putMapping("text/javascript", string + "JavaScriptTokenMaker");
                this.putMapping("text/json", string + "JsonTokenMaker");
                this.putMapping("text/xml", string + "XMLTokenMaker");
            }
        }
    }
}

