/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.NoRouteToHostException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

final class SwingBrowserImpl
extends HtmlBrowser.Impl
implements Runnable {
    private static final int NO_NAVIGATION = 1;
    private static final int NAVIGATION_BACK = 2;
    private static final int NAVIGATION_FWD = 3;
    private static RequestProcessor rp = new RequestProcessor("Swing Browser");
    private URL url;
    private URL loadingURL;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private String statusMessage = "";
    private SwingBrowser swingBrowser = new SwingBrowser();
    private Vector<Object> historyList = new Vector(5, 3);
    private int historyIndex = -1;
    private int historyNavigating = 1;
    private String title = null;
    boolean fetchingTitle = false;
    private static Logger LOG = Logger.getLogger(SwingBrowserImpl.class.getName());

    SwingBrowserImpl() {
        this.swingBrowser.addPropertyChangeListener("page", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getNewValue() instanceof URL) {
                    URL uRL = SwingBrowserImpl.this.url;
                    SwingBrowserImpl.this.url = (URL)propertyChangeEvent.getNewValue();
                    SwingBrowserImpl.this.pcs.firePropertyChange("url", uRL, SwingBrowserImpl.this.url);
                    if (((URL)propertyChangeEvent.getNewValue()).equals(SwingBrowserImpl.this.loadingURL)) {
                        SwingBrowserImpl.this.loadingURL = null;
                    }
                    if (SwingBrowserImpl.this.historyNavigating == 2) {
                        int n = SwingBrowserImpl.this.historyList.lastIndexOf(propertyChangeEvent.getNewValue(), SwingBrowserImpl.this.historyIndex - 1);
                        if (n != -1) {
                            SwingBrowserImpl.this.historyIndex = n;
                        }
                    } else if (SwingBrowserImpl.this.historyNavigating == 3) {
                        int n = SwingBrowserImpl.this.historyList.indexOf(propertyChangeEvent.getNewValue(), SwingBrowserImpl.this.historyIndex + 1);
                        if (n != -1) {
                            SwingBrowserImpl.this.historyIndex = n;
                        }
                    } else {
                        while (SwingBrowserImpl.this.historyList.size() > SwingBrowserImpl.this.historyIndex + 1) {
                            SwingBrowserImpl.this.historyList.remove(SwingBrowserImpl.this.historyList.size() - 1);
                        }
                        SwingBrowserImpl.this.historyList.add(propertyChangeEvent.getNewValue());
                        SwingBrowserImpl.this.historyIndex = SwingBrowserImpl.this.historyList.size() - 1;
                    }
                    SwingBrowserImpl.this.historyNavigating = 1;
                    SwingBrowserImpl.this.pcs.firePropertyChange("backward", null, null);
                    SwingBrowserImpl.this.pcs.firePropertyChange("forward", null, null);
                    SwingUtilities.invokeLater(SwingBrowserImpl.this);
                }
            }
        });
    }

    public Component getComponent() {
        return this.swingBrowser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadDocument() {
        RequestProcessor requestProcessor = rp;
        synchronized (requestProcessor) {
            try {
                if (this.url == null || this.loadingURL != null) {
                    return;
                }
                Document document = this.swingBrowser.getDocument();
                this.loadingURL = this.url;
                if (document instanceof AbstractDocument) {
                    String string = this.url.getProtocol();
                    if ("ftp".equalsIgnoreCase(string) || "http".equalsIgnoreCase(string)) {
                        ((AbstractDocument)document).setAsynchronousLoadPriority(5);
                    } else {
                        ((AbstractDocument)document).setAsynchronousLoadPriority(-1);
                    }
                }
                rp.post((Runnable)this);
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, null, exception);
                this.statusMessage = "" + exception;
                this.pcs.firePropertyChange("statusMessage", null, this.statusMessage);
            }
        }
    }

    public void stopLoading() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setURL(URL uRL) {
        RequestProcessor requestProcessor = rp;
        synchronized (requestProcessor) {
            try {
                if (uRL == null) {
                    return;
                }
                this.loadingURL = uRL;
                rp.post((Runnable)this);
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, null, exception);
                this.statusMessage = "" + exception;
                this.pcs.firePropertyChange("statusMessage", null, this.statusMessage);
            }
        }
    }

    public URL getURL() {
        return this.url;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public String getTitle() {
        if (this.title == null) {
            Mutex.EVENT.readAccess((Runnable)this);
        }
        return this.title == null ? NbBundle.getMessage(SwingBrowserImpl.class, (String)"LBL_Loading") : this.title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTitle() {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.fetchingTitle) {
            return;
        }
        this.fetchingTitle = true;
        String string = this.getTitle();
        try {
            URL uRL;
            Document document = this.swingBrowser.getDocument();
            this.title = (String)document.getProperty("title");
            if ((this.title == null || this.title.trim().length() == 0) && (uRL = this.getURL()) != null) {
                this.title = uRL.getFile();
                if (this.title.length() == 0) {
                    this.title = NbBundle.getMessage(SwingBrowserImpl.class, (String)"LBL_Untitled");
                } else {
                    int n = this.title.lastIndexOf("/");
                    if (n != -1 && n != this.title.length() - 1) {
                        this.title = this.title.substring(n + 1);
                    }
                }
            }
            if (this.title != null) {
                if (this.title.length() > 60) {
                    this.title = NbBundle.getMessage(SwingBrowserImpl.class, (String)"LBL_Title", (Object[])new Object[]{this.title.substring(0, 57)});
                }
                if (!string.equals(this.title)) {
                    this.pcs.firePropertyChange("title", string, this.title);
                }
            }
        }
        finally {
            this.fetchingTitle = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.title = null;
            this.updateTitle();
        } else {
            URL uRL;
            RequestProcessor requestProcessor = rp;
            synchronized (requestProcessor) {
                Document document;
                if (this.url != null && this.url.sameFile(this.url) && (document = this.swingBrowser.getDocument()) != null) {
                    document.putProperty("stream", null);
                }
                uRL = this.loadingURL;
                this.loadingURL = null;
            }
            try {
                this.swingBrowser.setPage(uRL);
                this.setStatusText(null);
            }
            catch (UnknownHostException unknownHostException) {
                this.setStatusText(NbBundle.getMessage(SwingBrowserImpl.class, (String)"FMT_UnknownHost", (Object[])new Object[]{uRL}));
            }
            catch (NoRouteToHostException noRouteToHostException) {
                this.setStatusText(NbBundle.getMessage(SwingBrowserImpl.class, (String)"FMT_NoRouteToHost", (Object[])new Object[]{uRL}));
            }
            catch (IOException iOException) {
                this.setStatusText(NbBundle.getMessage(SwingBrowserImpl.class, (String)"FMT_InvalidURL", (Object[])new Object[]{uRL}));
            }
            SwingUtilities.invokeLater(this);
        }
    }

    void setStatusText(String string) {
        this.statusMessage = string;
        this.pcs.firePropertyChange("statusMessage", null, this.statusMessage);
    }

    public boolean isForward() {
        return this.historyIndex >= 0 && this.historyIndex < this.historyList.size() - 1 && this.historyNavigating == 1;
    }

    public void forward() {
        if (this.isForward()) {
            this.historyNavigating = 3;
            this.setURL((URL)this.historyList.elementAt(this.historyIndex + 1));
        }
    }

    public boolean isBackward() {
        return this.historyIndex > 0 && this.historyIndex < this.historyList.size() && this.historyNavigating == 1;
    }

    public void backward() {
        if (this.isBackward()) {
            this.historyNavigating = 2;
            this.setURL((URL)this.historyList.elementAt(this.historyIndex - 1));
        }
    }

    public boolean isHistory() {
        return false;
    }

    public void showHistory() {
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    private static String findEncodingFromURL(InputStream inputStream) {
        try {
            byte[] byArray = new byte[4096];
            int n = inputStream.read(byArray, 0, byArray.length);
            String string = new String(byArray, 0, n >= 0 ? n : 0).toUpperCase();
            return SwingBrowserImpl.findEncoding(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static String findEncoding(String string) {
        int n;
        int n2 = string.indexOf("</HEAD>");
        if (n2 == -1) {
            n2 = string.length();
        }
        if ((n = string.indexOf("CONTENT-TYPE")) == -1 || n > n2) {
            return null;
        }
        int n3 = string.indexOf("CHARSET=", n);
        if (n3 == -1) {
            return null;
        }
        int n4 = string.indexOf(34, n3);
        int n5 = string.indexOf(39, n3);
        if (n4 == -1 && n5 == -1) {
            return null;
        }
        if (n5 != -1 && (n4 == -1 || n4 > n5)) {
            n4 = n5;
        }
        return string.substring(n3 + "CHARSET=".length(), n4);
    }

    private static class FilteredInputStream
    extends FilterInputStream {
        private final URLConnection conn;
        private final SwingBrowserImpl browser;

        FilteredInputStream(URLConnection uRLConnection, SwingBrowserImpl swingBrowserImpl) {
            super(null);
            this.conn = uRLConnection;
            this.browser = swingBrowserImpl;
        }

        private synchronized void openStream() throws IOException {
            if (this.in == null) {
                this.in = this.conn.getInputStream();
            }
        }

        public int available() throws IOException {
            this.openStream();
            return super.available();
        }

        public long skip(long l) throws IOException {
            this.openStream();
            return super.skip(l);
        }

        public void reset() throws IOException {
            this.openStream();
            super.reset();
        }

        public void close() throws IOException {
            this.openStream();
            super.close();
            Mutex.EVENT.readAccess((Runnable)this.browser);
        }

        public int read(byte[] byArray) throws IOException {
            this.openStream();
            return super.read(byArray);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            this.openStream();
            return super.read(byArray, n, n2);
        }

        public int read() throws IOException {
            this.openStream();
            return super.read();
        }
    }

    private class SwingBrowser
    extends JEditorPane {
        private boolean lastPaintException = false;

        private SwingBrowser() {
            this.setEditable(false);
            this.addHyperlinkListener(new HyperlinkListener(){

                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                            HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
                            HTMLDocument hTMLDocument = (HTMLDocument)SwingBrowser.this.getDocument();
                            URL uRL = SwingBrowserImpl.this.getURL();
                            hTMLDocument.processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
                            SwingBrowserImpl.this.pcs.firePropertyChange("url", uRL, hyperlinkEvent.getURL());
                        } else {
                            try {
                                SwingBrowserImpl.this.setURL(hyperlinkEvent.getURL());
                            }
                            catch (Exception exception) {
                                LOG.log(Level.WARNING, null, exception);
                            }
                        }
                    }
                }
            });
            ActionMap actionMap = this.getActionMap();
            actionMap.put("caret-up", new ScrollAction(-1));
            actionMap.put("caret-down", new ScrollAction(1));
        }

        protected InputStream getStream(URL uRL) throws IOException {
            SwingUtilities.invokeLater(SwingBrowserImpl.this);
            String string = SwingBrowserImpl.findEncodingFromURL(uRL.openStream());
            LOG.log(Level.FINE, "Url " + uRL + " has charset " + string);
            if (string != null) {
                this.putClientProperty("charset", string);
            }
            if (Boolean.getBoolean("org.openide.awt.SwingBrowserImpl.do-not-block-awt")) {
                this.setContentType("text/html");
                return new FilteredInputStream(uRL.openConnection(), SwingBrowserImpl.this);
            }
            return super.getStream(uRL);
        }

        public Dimension getPreferredSize() {
            try {
                return super.getPreferredSize();
            }
            catch (RuntimeException runtimeException) {
                return new Dimension(400, 600);
            }
        }

        public void paint(Graphics graphics) {
            try {
                super.paint(graphics);
                this.lastPaintException = false;
            }
            catch (RuntimeException runtimeException) {
                if (!this.lastPaintException) {
                    this.repaint();
                }
                this.lastPaintException = true;
            }
        }

        private class ScrollAction
        extends AbstractAction {
            int direction;

            public ScrollAction(int n) {
                this.direction = n;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Rectangle rectangle = SwingBrowser.this.getVisibleRect();
                int n = SwingBrowser.this.getScrollableUnitIncrement(rectangle, 1, this.direction);
                rectangle.y += n * this.direction;
                SwingBrowser.this.scrollRectToVisible(rectangle);
            }
        }
    }
}

