/*  Part of SWI-Prolog

    Author:        Edison Mera
    E-mail:        efmera@gmail.com
    WWW:           http://www.swi-prolog.org
    Copyright (C): 2013, Process Design Center, Breda, The Netherlands.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

    As a special exception, if you link this library with other files,
    compiled with a Free Software compiler, to produce an executable, this
    library does not by itself cause the resulting executable to be covered
    by the GNU General Public License. This exception does not however
    invalidate any other reasons why the executable file might be covered by
    the GNU General Public License.
*/

%% Migrated from Ciao to SWI-Prolog

:- module(ciao_sort,
	  [ sort/2,		% +List, -Sorted
	    keysort/2,		% +List, -Sorted
	    keylist/1,
	    keypair/1
	  ], [assertions, nortchecks]).

:- prop keylist(L) + regtype
   # "@var{L} is a list of pairs of the form @tt{Key-Value}.".

keylist([]).
keylist([_-_|KL]) :- keylist(KL).

:- doc(doinclude,keypair/1).
:- prop keypair(P) + regtype
   # "@var{P} is a pair of the form ""@tt{K-_}"",
      where @tt{K} is considered the @em{key}.".

keypair(_-_).
