/*
 * Decompiled with CFR 0.152.
 */
package org.openamf.invoker;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openamf.util.OpenAMFUtils;

public class RankedMethod
implements Comparable {
    public static final int NAME_MATCHES = 55;
    public static final int NAME_CASE_MATCHES = 5;
    public static final int PARAM_COUNT_MATCHES = 10;
    private double rank;
    private Method method;
    private List parameters;
    private boolean invokable;
    private static final Log log = LogFactory.getLog((Class)(class$org$openamf$invoker$RankedMethod == null ? (class$org$openamf$invoker$RankedMethod = RankedMethod.class$("org.openamf.invoker.RankedMethod")) : class$org$openamf$invoker$RankedMethod));
    static /* synthetic */ Class class$org$openamf$invoker$RankedMethod;

    public RankedMethod(Method method, String requestedMethodName, List parameters) {
        this.method = method;
        this.process(requestedMethodName, parameters);
    }

    public double getRank() {
        return this.rank;
    }

    public Method getMethod() {
        return this.method;
    }

    public boolean isInvokable() {
        return this.invokable;
    }

    public Object invoke(Object service) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this.method == null) {
            throw new NullPointerException("method is null, service=" + String.valueOf(service));
        }
        if (this.parameters == null) {
            throw new NullPointerException("parameters is null, service=" + String.valueOf(service));
        }
        return this.method.invoke(service, this.parameters.toArray());
    }

    private void process(String requestedMethodName, List parameters) {
        double rank = 0.0;
        ArrayList decodedParameters = null;
        if (this.method.getName().equalsIgnoreCase(requestedMethodName)) {
            Class[] parameterTypes;
            log.debug((Object)("comparing to methodName: " + this.method.getName()));
            log.debug((Object)"NAME_MATCHES");
            rank = 55.0;
            if (this.method.getName().equals(requestedMethodName)) {
                log.debug((Object)"NAME_CASE_MATCHES");
                rank += 5.0;
            }
            if ((parameterTypes = this.method.getParameterTypes()).length == parameters.size()) {
                log.debug((Object)"PARAM_COUNT_MATCHES");
                rank += 10.0;
                decodedParameters = new ArrayList(parameterTypes.length);
                rank = this.checkParameters(parameters, rank, decodedParameters, parameterTypes);
            }
            log.debug((Object)("RANK: " + rank));
        }
        this.rank = rank;
        this.parameters = decodedParameters;
    }

    private double checkParameters(List parameters, double rank, List decodedParameters, Class[] parameterTypes) {
        this.invokable = true;
        int allParamTypesMatch = 30;
        double paramTypeMatchValue = 0.0;
        if (parameterTypes.length == 0) {
            rank += (double)allParamTypesMatch;
        } else {
            paramTypeMatchValue = allParamTypesMatch / parameterTypes.length;
        }
        int i = 0;
        while (i < parameterTypes.length) {
            Class parameterType = parameterTypes[i];
            Object parameter = parameters.get(i);
            boolean origTypesMatch = OpenAMFUtils.typesMatch(parameterType, parameter);
            Object decodedObject = OpenAMFUtils.decodeParameter(parameter, parameterType);
            if (decodedObject == null) {
                rank += paramTypeMatchValue / 2.0;
                decodedParameters.add(decodedObject);
            } else if (OpenAMFUtils.typesMatch(parameterType, decodedObject)) {
                log.debug((Object)"types match");
                rank = origTypesMatch ? (rank += paramTypeMatchValue) : (rank += paramTypeMatchValue / 2.0);
                decodedParameters.add(decodedObject);
            } else if (origTypesMatch) {
                rank += paramTypeMatchValue;
                decodedParameters.add(parameter);
            } else {
                log.info((Object)"parameter couldn't be decoded");
                this.invokable = false;
                break;
            }
            ++i;
        }
        return rank;
    }

    public int compareTo(Object o) {
        int compareTo = 0;
        RankedMethod rankedMethod = (RankedMethod)o;
        if (this.getRank() > rankedMethod.getRank()) {
            compareTo = -1;
        } else if (this.getRank() < rankedMethod.getRank()) {
            compareTo = 1;
        }
        return compareTo;
    }

    public String toString() {
        return String.valueOf(this.getMethod());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

