/*
 * Decompiled with CFR 0.152.
 */
package org.openamf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openamf.AMFBody;
import org.openamf.AMFHeader;

public class AMFMessage
implements Serializable {
    private static final int CURRENT_VERSION = 0;
    protected int version = 0;
    protected List headers = new ArrayList();
    protected List bodies = new ArrayList();

    public void addHeader(String key, boolean required, Object value) {
        this.addHeader(new AMFHeader(key, required, value));
    }

    public void addHeader(AMFHeader header) {
        this.headers.add(header);
    }

    public int getHeaderCount() {
        return this.headers.size();
    }

    public AMFHeader getHeader(int index) {
        return (AMFHeader)this.headers.get(index);
    }

    public List getHeaders() {
        return this.headers;
    }

    public void addBody(String target, String response, Object value, byte type) {
        this.addBody(new AMFBody(target, response, value, type));
    }

    public void addBody(AMFBody body) {
        this.bodies.add(body);
    }

    public int getBodyCount() {
        return this.bodies.size();
    }

    public AMFBody getBody(int index) {
        return (AMFBody)this.bodies.get(index);
    }

    public Iterator getBodies() {
        return this.bodies.iterator();
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getBodiesString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.bodies.size()) {
            if (i > 0) {
                sb.append('\n');
            }
            AMFBody amfBody = (AMFBody)this.bodies.get(i);
            sb.append(amfBody);
            ++i;
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[AMFMessage: {version=");
        sb.append(this.version);
        sb.append(", headers={");
        int i = 0;
        while (i < this.headers.size()) {
            AMFHeader amfHeader = (AMFHeader)this.headers.get(i);
            sb.append(amfHeader);
            ++i;
        }
        sb.append("}, bodies={");
        int i2 = 0;
        while (i2 < this.bodies.size()) {
            AMFBody amfBody = (AMFBody)this.bodies.get(i2);
            sb.append(amfBody);
            ++i2;
        }
        sb.append("}}]");
        return sb.toString();
    }
}

