/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.DEREncodable;

public class ASN1ObjectParser {
    private int _baseTag;
    private int _tagNumber;
    private ASN1StreamParser _aIn;

    protected ASN1ObjectParser(int n, int n2, InputStream inputStream) {
        this._baseTag = n;
        this._tagNumber = n2;
        this._aIn = new ASN1StreamParser(inputStream);
    }

    int getTagNumber() {
        return this._tagNumber;
    }

    int getBaseTag() {
        return this._baseTag;
    }

    DEREncodable readObject() throws IOException {
        return this._aIn.readObject();
    }

    ASN1EncodableVector readVector() throws IllegalStateException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        try {
            DEREncodable dEREncodable;
            while ((dEREncodable = this.readObject()) != null) {
                aSN1EncodableVector.add(dEREncodable.getDERObject());
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.getMessage());
        }
        return aSN1EncodableVector;
    }
}

