/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.connector;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.EISSystemException;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import oracle.jdbc.connector.OracleLocalTransaction;
import oracle.jdbc.connector.OracleManagedConnectionMetaData;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.xa.OracleXAConnection;
import oracle.jdbc.xa.OracleXAResource;

public class OracleManagedConnection
implements ManagedConnection {
    private OracleXAConnection m_xaconn = null;
    private Hashtable m_connListeners = null;
    private Connection m_conn = null;
    private PrintWriter m_pw = null;
    private PasswordCredential m_pcred = null;

    OracleManagedConnection(XAConnection xAConnection) {
        this.m_xaconn = (OracleXAConnection)xAConnection;
        this.m_connListeners = new Hashtable(10);
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        try {
            if (this.m_conn != null) {
                this.m_conn.close();
            }
            this.m_conn = this.m_xaconn.getConnection();
            return this.m_conn;
        }
        catch (SQLException sQLException) {
            EISSystemException eISSystemException = new EISSystemException("SQLException: " + sQLException.getMessage());
            eISSystemException.setLinkedException((Exception)sQLException);
            throw eISSystemException;
        }
    }

    public void destroy() throws ResourceException {
        try {
            Connection connection;
            if (this.m_xaconn != null && ((OracleConnection)(connection = this.m_xaconn.getPhysicalHandle())).getTxnMode() == 1) {
                IllegalStateException illegalStateException = new IllegalStateException("Could not close connection while transaction is active");
                throw illegalStateException;
            }
            if (this.m_conn != null) {
                this.m_conn.close();
            }
            if (this.m_xaconn != null) {
                this.m_xaconn.close();
            }
        }
        catch (SQLException sQLException) {
            EISSystemException eISSystemException = new EISSystemException("SQLException: " + sQLException.getMessage());
            eISSystemException.setLinkedException((Exception)sQLException);
            throw eISSystemException;
        }
    }

    public void cleanup() throws ResourceException {
        try {
            if (this.m_conn != null) {
                if (((OracleConnection)this.m_conn).getTxnMode() == 1) {
                    IllegalStateException illegalStateException = new IllegalStateException("Could not close connection while transaction is active");
                    throw illegalStateException;
                }
                this.m_conn.close();
            }
        }
        catch (SQLException sQLException) {
            EISSystemException eISSystemException = new EISSystemException("SQLException: " + sQLException.getMessage());
            eISSystemException.setLinkedException((Exception)sQLException);
            throw eISSystemException;
        }
    }

    public void associateConnection(Object object) {
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.m_connListeners.put(connectionEventListener, connectionEventListener);
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.m_connListeners.remove(connectionEventListener);
    }

    public XAResource getXAResource() throws ResourceException {
        return this.m_xaconn.getXAResource();
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        return new OracleLocalTransaction(this);
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        return new OracleManagedConnectionMetaData(this);
    }

    public void setLogWriter(PrintWriter printWriter) throws ResourceException {
        this.m_pw = printWriter;
        OracleLog.setLogWriter(printWriter);
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.m_pw;
    }

    Connection getPhysicalConnection() throws ResourceException {
        return ((OracleXAResource)this.m_xaconn.getXAResource()).getConnection();
    }

    void setPasswordCredential(PasswordCredential passwordCredential) {
        this.m_pcred = passwordCredential;
    }

    PasswordCredential getPasswordCredential() {
        return this.m_pcred;
    }

    void eventOccurred(int n) throws ResourceException {
        Enumeration enumeration = this.m_connListeners.keys();
        block7: while (enumeration.hasMoreElements()) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)enumeration.nextElement();
            ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, n);
            switch (n) {
                case 1: {
                    connectionEventListener.connectionClosed(connectionEvent);
                    continue block7;
                }
                case 2: {
                    connectionEventListener.localTransactionStarted(connectionEvent);
                    continue block7;
                }
                case 3: {
                    connectionEventListener.localTransactionCommitted(connectionEvent);
                    continue block7;
                }
                case 4: {
                    connectionEventListener.localTransactionRolledback(connectionEvent);
                    continue block7;
                }
                case 5: {
                    connectionEventListener.connectionErrorOccurred(connectionEvent);
                    continue block7;
                }
            }
            throw new IllegalArgumentException("Illegal eventType in eventOccurred(): " + n);
        }
    }
}

