/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.graph;

import com.projity.graphic.configuration.GraphicConfiguration;
import com.projity.pm.graphic.graph.Graph;
import com.projity.pm.graphic.graph.GraphInteractor;
import com.projity.pm.graphic.graph.GraphRenderer;
import com.projity.pm.graphic.graph.GraphZone;
import com.projity.pm.graphic.graph.LinkRouting;
import com.projity.pm.graphic.model.cache.GraphicDependency;
import com.projity.pm.graphic.model.cache.GraphicNode;
import java.awt.Graphics;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class GraphUI
extends ComponentUI
implements Serializable {
    private static final long serialVersionUID = -8309077056249013471L;
    protected Graph graph;
    protected GraphInteractor interactor;
    protected GraphicConfiguration config;
    protected GraphRenderer graphRenderer;
    protected double[] segment = new double[6];

    public GraphUI(Graph graph, GraphRenderer graphRenderer) {
        this.graph = graph;
        this.graphRenderer = graphRenderer;
        this.config = GraphicConfiguration.getInstance();
    }

    public Graph getGraph() {
        return this.graph;
    }

    public GraphZone getObjectAt(double d, double d2) {
        GraphZone graphZone = this.getNodeAt(d, d2);
        return graphZone == null ? this.getLinkAt(d, d2) : graphZone;
    }

    public GraphZone getLinkAt(double d, double d2) {
        return this.getLinkAt(d, d2, this.graph.getModel().getDependencyIterator());
    }

    protected GraphZone getLinkAt(double d, double d2, Iterator iterator) {
        Rectangle2D.Double double_;
        double d3 = this.config.getSelectionSquare();
        double d4 = this.config.getLinkFlatness();
        Rectangle2D.Double double_2 = double_ = d3 == 0.0 ? null : new Rectangle2D.Double(d - d3, d2 - d3, 2.0 * d3 + 1.0, 2.0 * d3 + 1.0);
        while (iterator.hasNext()) {
            PathIterator pathIterator;
            GraphicDependency graphicDependency = (GraphicDependency)iterator.next();
            if (double_ == null && graphicDependency.getPath().contains(d, d2)) {
                return graphicDependency == null ? null : new GraphZone(graphicDependency);
            }
            if (double_ == null) continue;
            double d5 = -1.0;
            double d6 = -1.0;
            PathIterator pathIterator2 = pathIterator = d4 <= 0.0 ? graphicDependency.getPath().getPathIterator(null) : graphicDependency.getPath().getPathIterator(null, d4);
            while (!pathIterator.isDone()) {
                switch (pathIterator.currentSegment(this.segment)) {
                    case 1: {
                        if (!(Line2D.ptSegDist(d5, d6, this.segment[0], this.segment[1], d, d2) <= d3)) break;
                        return graphicDependency == null ? null : new GraphZone(graphicDependency);
                    }
                }
                d5 = this.segment[0];
                d6 = this.segment[1];
                pathIterator.next();
            }
        }
        return null;
    }

    public LinkRouting getRouting() {
        return this.graphRenderer.getRouting();
    }

    public void setRouting(LinkRouting linkRouting) {
        this.graphRenderer.setRouting(linkRouting);
    }

    public void updateShapes(List list) {
        this.graphRenderer.updateShapes(list);
    }

    public void updateShapes() {
        this.graphRenderer.updateShapes();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.graphRenderer.paint(graphics);
    }

    public void updateShape(GraphicNode graphicNode) {
        this.graphRenderer.updateShape(graphicNode);
    }

    public GraphRenderer getGraphRenderer() {
        return this.graphRenderer;
    }

    public GraphZone getNodeAt(double d, double d2) {
        return null;
    }

    public boolean isEditing(GraphicNode graphicNode) {
        return false;
    }
}

