/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.dxf;

import de.escape.quincunx.dxf.DrawAble;
import de.escape.quincunx.dxf.Drawable14Converter;
import de.escape.quincunx.dxf.ModelDrawArea;
import de.escape.quincunx.dxf.dialogs.PostScriptOutputInfo;
import de.escape.quincunx.dxf.dialogs.SavePostScriptDialog;
import de.escape.quincunx.dxf.reader.DxfConverter;
import de.escape.quincunx.dxf.reader.DxfEntitySet;
import de.escape.quincunx.dxf.reader.DxfFile;
import de.escape.quincunx.dxf.reader.DxfReporter;
import de.escape.quincunx.gimmicks.Bargauge;
import de.escape.quincunx.gimmicks.BasicPaperFormat;
import de.escape.quincunx.gimmicks.ErrorBox;
import de.escape.quincunx.gimmicks.FramedArea;
import de.escape.quincunx.gimmicks.ImageBox;
import de.escape.quincunx.gimmicks.ImageCanvas;
import de.escape.quincunx.gimmicks.LowerArea;
import de.escape.quincunx.gimmicks.PostScriptFileSaveJob;
import de.escape.quincunx.gimmicks.TextBox;
import de.escape.quincunx.gimmicks.Utility;
import de.escape.quincunx.gimmicks.YesNoBox;
import de.escape.quincunx.i18n.I18n;
import de.escape.quincunx.i18n.Localizable;
import de.escape.quincunx.i18n.RButton;
import de.escape.quincunx.i18n.RCheckboxMenuItem;
import de.escape.quincunx.i18n.RFrame;
import de.escape.quincunx.i18n.RMenu;
import de.escape.quincunx.i18n.RMenuBar;
import de.escape.quincunx.i18n.RMenuItem;
import de.escape.quincunx.i18n.RPanel;
import de.escape.quincunx.i18n.ResourcedException;
import de.escape.quincunx.trafo.Point3D;
import de.escape.quincunx.trafo.Vector3D;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Menu;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;

public class DxfViewer
extends Applet
implements Localizable,
DxfReporter {
    public static final boolean calcFaces = false;
    public static final boolean calcLight = false;
    public static final boolean allow14 = true;
    private static final String DEBUG_PROPERTY = "dxfview.debug";
    private static final String LANG_PROPERTY = "dxfview.language";
    private static final String REDUCE_LINES_PROPERTY = "dxfview.reducelines";
    private static final String PREVIEW_LINES_PROPERTY = "preview.reducelines";
    private static final int LANG_ENGLISH = 0;
    private static final int LANG_GERMAN = 1;
    private static final int SUPPORTED_LANGUAGES = 2;
    static final Locale[] locales = new Locale[]{Locale.US, Locale.GERMAN};
    private static int defaultLang;
    public static int debugLevel;
    private static final String versNum = "1.22.06";
    static String myName;
    static String version;
    private static final String mailto = "rammi@caff.de";
    private static final Color READ_COLOR;
    private static final Color CONV_COLOR;
    private static final Color STD_COLOR;
    private static final Color WARN_COLOR;
    DrawAble model;
    String fileName;
    boolean inAnApplet = false;
    private boolean appletFramed = false;
    ModelDrawArea modelDraw;
    Frame myWin;
    RCheckboxMenuItem[] langCheck = new RCheckboxMenuItem[2];
    private int language = defaultLang;
    RCheckboxMenuItem[] csPos = new RCheckboxMenuItem[4];
    private StringBuffer messageLog = new StringBuffer();
    private int nrWarnings;
    private Bargauge progress;
    private Label statusLine;
    private boolean haveFonts = false;
    private String entityCountInfo;
    private boolean initSwapBW = false;
    private boolean initShowCS = true;
    private int initCSPos = 5;
    String lastDir;
    TextBox usageBox;
    ImageBox aboutBox;
    PostScriptOutputInfo psInfo = new PostScriptOutputInfo();

    public void init(String filename, Frame win) {
        this.psInfo.setPaperFormat(BasicPaperFormat.A4_PAPER_PORTRAIT);
        this.myWin = win;
        win.setLayout(new BorderLayout());
        this.loadPersistentData();
        ((Component)this).setFont(new Font("SansSerif", 0, 12));
        this.fileName = filename;
        this.setMyLocale(locales[defaultLang]);
        win.addWindowListener(new 1());
        this.setTitle(filename);
        this.haveFonts = new Drawable14Converter().fontsAvailable();
        this.createMenu(win);
        win.add((Component)this.createView(), "Center");
        this.showStatus(this.haveFonts ? null : I18n.getString("msgNoText"));
    }

    private void checkForFurtherParameters(String[] paras) {
        int p = paras.length - 1;
        while (p >= 0) {
            String value = this.getParameter(paras[p]);
            --p;
        }
    }

    private static void initDebug(String debug) {
        block2: {
            if (debug == null) break block2;
            try {
                debugLevel = Integer.parseInt(debug);
            }
            catch (NumberFormatException numberFormatException) {
                if (!"true".equals(debug)) break block2;
                debugLevel = Integer.MAX_VALUE;
            }
        }
    }

    public void init() {
        this.inAnApplet = true;
        Utility.setApplet(this);
        this.checkForFurtherParameters(new String[]{REDUCE_LINES_PROPERTY, PREVIEW_LINES_PROPERTY});
        DxfViewer.initDebug(this.getParameter(DEBUG_PROPERTY));
        this.setBackground(Color.lightGray);
        ((Component)this).setFont(new Font("SansSerif", 0, 12));
        DxfViewer.testForLanguage(this.getParameter("language"));
        this.language = defaultLang;
        this.setMyLocale(locales[defaultLang]);
        String swap = this.getParameter("swapBW");
        this.initSwapBW = swap != null && swap.equals("true");
        this.fileName = this.getParameter("file");
        String useFrame = this.getParameter("framed");
        this.haveFonts = new Drawable14Converter().fontsAvailable();
        if (useFrame != null && useFrame.equals("true")) {
            int width = 800;
            String param = this.getParameter("frameWidth");
            if (param != null) {
                try {
                    int dummy = Integer.parseInt(param);
                    if (dummy >= 100) {
                        width = dummy;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            int height = 600;
            param = this.getParameter("frameHeight");
            if (param != null) {
                try {
                    int dummy = Integer.parseInt(param);
                    if (dummy >= 100) {
                        height = dummy;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            this.appletFramed = true;
            RFrame win = new RFrame();
            this.init(this.fileName, win);
            win.pack();
            ((Component)win).setSize(width, height);
            win.show();
            this.setLayout(null);
            RButton startButton = new RButton("lbStartButton");
            this.add(startButton);
            Dimension aSize = this.getSize();
            Dimension bSize = startButton.getPreferredSize();
            startButton.setSize(bSize);
            startButton.setLocation((aSize.width - bSize.width) / 2, (aSize.height - bSize.height) / 2);
            startButton.addActionListener(new 2(win));
        } else {
            this.setLayout(new BorderLayout());
            this.add((Component)this.createView(), "Center");
            this.setSize(this.getSize());
        }
    }

    private RPanel createView() {
        RPanel conti;
        RPanel view = new RPanel(new BorderLayout());
        if (this.inAnApplet) {
            conti = new RPanel();
            view.add((Component)new FramedArea(conti), "Center");
            conti.setLayout(new BorderLayout());
        } else {
            conti = view;
        }
        this.modelDraw = new ModelDrawArea(this);
        this.modelDraw.swapBlackAndWhite(this.initSwapBW);
        this.modelDraw.setShowCoord(this.initShowCS);
        this.modelDraw.setCoordPos(this.initCSPos);
        RPanel center = new RPanel();
        conti.add((Component)center, "Center");
        RPanel status = new RPanel(new BorderLayout());
        conti.add((Component)status, "South");
        this.statusLine = new Label();
        status.add((Component)new FramedArea(this.statusLine), "Center");
        this.progress = new Bargauge();
        status.add((Component)this.progress, "East");
        3 showLog = new 3();
        status.addMouseListener(showLog);
        this.statusLine.addMouseListener(showLog);
        this.progress.setColor(READ_COLOR);
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        center.setLayout(gridBag);
        LowerArea frameArea = new LowerArea(this.modelDraw);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        gridBag.setConstraints(frameArea, c);
        center.add(frameArea);
        Component modelCtrl = this.modelDraw.getModelCtrl();
        c.weightx = 0.0;
        c.gridwidth = 0;
        gridBag.setConstraints(modelCtrl, c);
        center.add(modelCtrl);
        view.validate();
        view.repaint();
        try {
            if (this.fileName != null) {
                this.lastDir = new File(this.fileName).getParent();
                this.doLoad(this.fileName);
            }
        }
        catch (Exception x) {
            String msg = x instanceof ResourcedException ? ((ResourcedException)x).getMessage(I18n.getDefaultLocale()) : x.getMessage();
            if (msg == null) {
                msg = x.toString();
            }
            if (debugLevel > 0) {
                x.printStackTrace();
                if (debugLevel > 5) {
                    System.out.println("Error: " + msg);
                }
            }
            this.model = null;
            new ErrorBox(this, msg);
        }
        return view;
    }

    private void doLoad(String filename) {
        this.clearMessages();
        try {
            try {
                if (debugLevel > 10) {
                    System.out.println("Begin reading (" + new Date() + ")");
                }
                this.showStatusRes("msgOpening", new String[]{filename});
                this.setCursor(Cursor.getPredefinedCursor(3));
                DxfFile input = this.inAnApplet ? new DxfFile(new URL(this.getDocumentBase(), filename).openStream(), (DxfReporter)this) : new DxfFile(filename, (DxfReporter)this);
                if (debugLevel > 10) {
                    System.out.println("End reading (" + new Date() + ")");
                }
                Drawable14Converter converter = new Drawable14Converter();
                this.showStatusRes("msgConverting", new String[]{filename});
                if (debugLevel > 10) {
                    System.out.println("Starting conversion (" + new Date() + ")");
                }
                this.progress.setFillLevel(0.0f);
                this.progress.setColor(CONV_COLOR);
                if (this.inAnApplet && !this.appletFramed) {
                    input.convert((DxfConverter)converter);
                } else if (debugLevel > 0) {
                    try {
                        input.convert((DxfConverter)converter);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                } else {
                    input.convert((DxfConverter)converter);
                }
                if (debugLevel > 10) {
                    System.out.println("Ending conversion (" + new Date() + ")");
                }
                this.showStatusRes("msgShowing", new String[]{filename});
                this.model = converter.getModel();
                this.modelDraw.setModel(this.model, input);
                if (this.nrWarnings > 0) {
                    this.showWarningRes("warnWarnings", new String[]{String.valueOf(this.nrWarnings)});
                } else {
                    this.showStatusRes("msgShowingLines", new String[]{filename, String.valueOf(this.modelDraw.getNrLines())});
                }
                this.setTitle(filename);
                this.createEntityCountInfo(input.getEntities().getEntitySet());
            }
            catch (FileNotFoundException x) {
                new ErrorBox((Component)this.getDialogParent(), I18n.format("err!FileNotFound", filename));
                if (debugLevel > 0) {
                    x.printStackTrace();
                }
                this.showStatusRes("msgError");
                this.setTitle(this.fileName);
            }
            catch (Exception x) {
                String msg = x instanceof ResourcedException ? ((ResourcedException)x).getMessage(I18n.getDefaultLocale()) : x.getMessage();
                if (msg == null || msg.length() == 0) {
                    msg = x.toString();
                }
                if (debugLevel > 0) {
                    x.printStackTrace();
                    if (debugLevel > 5) {
                        System.out.println("Error: " + msg);
                    }
                }
                new ErrorBox((Component)this.getDialogParent(), msg);
                this.showStatusRes("msgError");
                this.setTitle(this.fileName);
            }
            Object var4_8 = null;
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            this.setCursor(Cursor.getDefaultCursor());
            this.showProgress(0.0f);
            this.progress.setColor(READ_COLOR);
            throw throwable;
        }
        this.setCursor(Cursor.getDefaultCursor());
        this.showProgress(0.0f);
        this.progress.setColor(READ_COLOR);
    }

    private void setTitle(String filename) {
        this.fileName = filename;
        if (this.myWin != null) {
            if (filename == null) {
                this.myWin.setTitle(myName);
            } else {
                this.myWin.setTitle(String.valueOf(myName) + ": " + filename);
            }
        }
    }

    private synchronized void clearMessages() {
        this.messageLog.setLength(0);
        this.nrWarnings = 0;
    }

    private synchronized void addMessage(String msg) {
        this.messageLog.append(msg).append('\n');
    }

    private void showStatus(String msg, boolean warn, boolean log) {
        if (debugLevel > 20 && msg != null) {
            System.out.println(msg);
        }
        if (log && msg != null) {
            this.addMessage(msg);
        }
        if (this.statusLine != null) {
            this.statusLine.setForeground(warn ? WARN_COLOR : STD_COLOR);
            if (!(warn || msg != null && msg.length() != 0)) {
                this.statusLine.setText(" " + version + "  (" + mailto + ")");
            } else {
                this.statusLine.setText(" " + msg);
            }
        }
    }

    public void showStatus(String msg) {
        this.showStatus(msg, false, true);
    }

    public void showStatusRes(String tag) {
        this.showStatus(I18n.getString(tag));
    }

    public void showStatusRes(String format, String[] args) {
        this.showStatus(I18n.format(format, args));
    }

    public void showHelp(String msg) {
        this.showStatus(msg, false, false);
    }

    public void showHelpRes(String tag) {
        this.showHelp(I18n.getString(tag));
    }

    public void showHelpRes(String format, String[] args) {
        this.showHelp(I18n.format(format, args));
    }

    public void showWarning(String msg) {
        ++this.nrWarnings;
        this.showStatus(String.valueOf(I18n.getString("headWarning")) + msg, true, true);
    }

    public void showWarningRes(String tag) {
        this.showWarning(I18n.getString(tag));
    }

    public void showWarningRes(String format, String[] args) {
        this.showWarning(I18n.format(format, args));
    }

    public void showProgress() {
        if (this.progress != null) {
            this.progress.advanceBar();
        }
    }

    public void showProgress(float level) {
        if (this.progress != null) {
            this.progress.setFillLevel(level);
        }
    }

    public void showProgress(float level, float maxLevel) {
        if (this.progress != null) {
            this.progress.setFillLevel(level, maxLevel);
        }
    }

    public void showProgress(long level, long maxLevel) {
        if (this.progress != null) {
            this.progress.setFillLevel(level, maxLevel);
        }
    }

    private void createMenu(Frame win) {
        RMenuBar mb = new RMenuBar(locales[this.language]);
        win.setMenuBar(mb);
        mb.setFont(this.getFont());
        ((Component)win).setBackground(Color.lightGray);
        if (!this.inAnApplet) {
            RMenu file = new RMenu("mbFile");
            RMenuItem fOpen = new RMenuItem("miOpen");
            fOpen.addActionListener(new FileOpenAdapter());
            RMenuItem fPrint = new RMenuItem("miPrint");
            fPrint.addActionListener(new FilePrintAdapter());
            RMenuItem fSavePS = new RMenuItem("miSavePS");
            fSavePS.addActionListener(new FileSavePSAdapter());
            RMenuItem fExit = new RMenuItem("miExit");
            fExit.addActionListener(new 4());
            ((Menu)file).add(fOpen);
            file.addSeparator();
            ((Menu)file).add(fPrint);
            ((Menu)file).add(fSavePS);
            file.addSeparator();
            ((Menu)file).add(fExit);
            mb.add((Menu)file);
        }
        RMenu opt = new RMenu("mbOptions");
        RMenu lang = new RMenu("mbLanguage");
        ((Menu)opt).add(lang);
        int i = 0;
        while (i < 2) {
            this.langCheck[i] = new RCheckboxMenuItem("miLang" + i, i == this.language);
            ((Menu)lang).add(this.langCheck[i]);
            this.langCheck[i].addItemListener(new LangListener(i));
            ++i;
        }
        opt.addSeparator();
        RCheckboxMenuItem oCsPos = new RCheckboxMenuItem("miCsPosOnOff", this.modelDraw != null ? this.modelDraw.getShowCoord() : this.initShowCS);
        oCsPos.addItemListener(new 5());
        ((Menu)opt).add(oCsPos);
        RMenu corners = new RMenu("mbCsPos");
        ((Menu)opt).add(corners);
        this.csPos[0] = new RCheckboxMenuItem("miCsPosSW", (this.modelDraw != null ? this.modelDraw.getCoordPosition() : this.initCSPos) == 5);
        ((Menu)corners).add(this.csPos[0]);
        this.csPos[0].addItemListener(new CsPosListener(0, 5));
        this.csPos[1] = new RCheckboxMenuItem("miCsPosSE", (this.modelDraw != null ? this.modelDraw.getCoordPosition() : this.initCSPos) == 9);
        ((Menu)corners).add(this.csPos[1]);
        this.csPos[1].addItemListener(new CsPosListener(1, 9));
        this.csPos[2] = new RCheckboxMenuItem("miCsPosNE", (this.modelDraw != null ? this.modelDraw.getCoordPosition() : this.initCSPos) == 10);
        ((Menu)corners).add(this.csPos[2]);
        this.csPos[2].addItemListener(new CsPosListener(2, 10));
        this.csPos[3] = new RCheckboxMenuItem("miCsPosNW", (this.modelDraw != null ? this.modelDraw.getCoordPosition() : this.initCSPos) == 6);
        ((Menu)corners).add(this.csPos[3]);
        this.csPos[3].addItemListener(new CsPosListener(3, 6));
        RCheckboxMenuItem oCol = new RCheckboxMenuItem("miB&W", this.initSwapBW);
        oCol.addItemListener(new 6());
        ((Menu)opt).add(oCol);
        mb.add((Menu)opt);
        RMenu info = new RMenu("mbInfo");
        RMenuItem iLog = new RMenuItem("miMsgLog");
        iLog.addActionListener(new LogMsgAdapter());
        ((Menu)info).add(iLog);
        RMenuItem iModel = new RMenuItem("miModel");
        iModel.addActionListener(new ModelInfoAdapter());
        ((Menu)info).add(iModel);
        RMenuItem iVM = new RMenuItem("miJVM");
        iVM.addActionListener(new VMInfoAdapter());
        ((Menu)info).add(iVM);
        mb.add((Menu)info);
        RMenu help = new RMenu("mbHelp");
        RMenuItem hUse = new RMenuItem("miUsage");
        hUse.addActionListener(new UsageAdapter());
        ((Menu)help).add(hUse);
        RMenuItem hAbout = new RMenuItem("miAbout");
        hAbout.addActionListener(new AboutAdapter());
        ((Menu)help).add(hAbout);
        mb.add((Menu)help);
        mb.setHelpMenu(help);
    }

    public void printAll(Graphics g) {
        this.print(g);
    }

    public void print(Graphics g) {
        try {
            String vendor = System.getProperty("java.vendor");
            if (debugLevel > 0) {
                System.out.println("vendor=" + vendor);
            }
            if (vendor != null && vendor.indexOf("Microsoft") != -1) {
                Enumeration<Applet> e = this.getAppletContext().getApplets();
                while (e.hasMoreElements()) {
                    Applet applet = e.nextElement();
                    if (!applet.isActive() || !(applet instanceof DxfViewer)) continue;
                    DxfViewer other = (DxfViewer)applet;
                    if (debugLevel > 0) {
                        System.out.println("IE print workaround!");
                    }
                    other.realPrint(g);
                    return;
                }
            }
        }
        catch (Throwable throwable) {}
        this.realPrint(g);
    }

    private void realPrint(Graphics g) {
        FontMetrics metrics;
        int border;
        Rectangle bounds;
        block6: {
            if (debugLevel > 0) {
                System.out.println("realPrint()");
            }
            if ((bounds = g.getClipBounds()) == null) {
                bounds = this.getBounds();
                String vendor = System.getProperty("java.vendor");
                if (vendor != null && vendor.startsWith("Netscape")) {
                    if (debugLevel > 0) {
                        System.out.println("Netscape print scaling problem workaround");
                    }
                    bounds.width = 3 * bounds.width / 4;
                    bounds.height = 3 * bounds.height / 4;
                }
                g.setClip(bounds);
            }
            g.setColor(Color.white);
            g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            g.setColor(Color.black);
            g.drawRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
            border = 2;
            Font sans = new Font("SansSerif", 0, 12);
            g.setFont(sans);
            metrics = g.getFontMetrics();
            try {
                g.drawString(this.fileName, bounds.x + border, bounds.y + metrics.getMaxAscent() + border);
            }
            catch (NullPointerException nullPointerException) {
                if (debugLevel <= 0) break block6;
                System.out.println("Netscape NullPointerException workaround");
            }
        }
        this.modelDraw.paintTemporary(g.create(bounds.x, bounds.y + metrics.getHeight() + border, bounds.width, bounds.height - metrics.getHeight() - border), new Dimension(bounds.width, bounds.height - metrics.getHeight() - border), false, true, false, 0);
    }

    public void start() {
    }

    public void stop() {
    }

    public void dispose() {
    }

    private static String makeInfoLine(String text, Object value) {
        int INFO_WIDTH = 80;
        int MIN_SPACE = 2;
        String val = value == null ? "null" : value.toString();
        StringBuffer line = new StringBuffer(text);
        line.append(": ");
        int linelen = line.length();
        if (linelen + val.length() + MIN_SPACE <= INFO_WIDTH) {
            int space = INFO_WIDTH - linelen - val.length();
            int i = linelen;
            while (i < linelen + space - 1) {
                line.append(i % 2 == 0 ? (char)'.' : ' ');
                ++i;
            }
            line.append(' ');
            line.append(val);
        } else {
            if (linelen < INFO_WIDTH) {
                int i = linelen;
                while (i < INFO_WIDTH) {
                    line.append(i % 2 == 0 ? (char)'.' : ' ');
                    ++i;
                }
            }
            line.append('\n');
            int vallen = val.length();
            if (vallen < INFO_WIDTH) {
                int i = 0;
                while (i < INFO_WIDTH - vallen - 1) {
                    line.append(i % 2 == 0 ? (char)'.' : ' ');
                    ++i;
                }
                line.append(' ');
            }
            line.append(val);
        }
        return line.toString();
    }

    private void createEntityCountInfo(DxfEntitySet set) {
        this.entityCountInfo = DxfViewer.makeInfoLine(I18n.getString("infEntCount"), new Integer(set.getNrOfEntities()));
        Enumeration e = set.getCollectedEntityTypes();
        while (e.hasMoreElements()) {
            String entType = (String)e.nextElement();
            this.entityCountInfo = String.valueOf(this.entityCountInfo) + "\n" + DxfViewer.makeInfoLine("   " + entType, new Integer(set.getNumberOf(entType)));
        }
    }

    public String getModelInfo() {
        if (this.model == null) {
            return "";
        }
        String info = DxfViewer.makeInfoLine(I18n.getString("infFileName", this.getLocale()), this.fileName);
        info = String.valueOf(info) + "\n\n" + DxfViewer.makeInfoLine(I18n.getString("infNrLines", this.getLocale()), new Integer(this.modelDraw.getNrLines()));
        info = String.valueOf(info) + "\n\n" + DxfViewer.makeInfoLine(I18n.getString("infBBMin", this.getLocale()), this.modelDraw.getMinPoint());
        info = String.valueOf(info) + "\n" + DxfViewer.makeInfoLine(I18n.getString("infBBMax", this.getLocale()), this.modelDraw.getMaxPoint());
        info = String.valueOf(info) + "\n" + DxfViewer.makeInfoLine(I18n.getString("infBBExt", this.getLocale()), this.modelDraw.getMaxPoint().minus(this.modelDraw.getMinPoint()));
        info = String.valueOf(info) + "\n\n" + this.entityCountInfo;
        if (this.nrWarnings > 0) {
            info = String.valueOf(info) + "\n\n" + DxfViewer.makeInfoLine(I18n.getString("infNrWarn", this.getLocale()), new Integer(this.nrWarnings));
        }
        return info;
    }

    public String getVMInfo() {
        String prop;
        String info = "";
        try {
            prop = System.getProperty("java.vendor");
            if (prop != null) {
                info = String.valueOf(info) + DxfViewer.makeInfoLine("JVM vendor", prop) + '\n';
            }
        }
        catch (SecurityException securityException) {}
        try {
            prop = System.getProperty("java.version");
            if (prop != null) {
                info = String.valueOf(info) + DxfViewer.makeInfoLine("JVM version", prop) + '\n';
            }
        }
        catch (SecurityException securityException) {}
        try {
            prop = System.getProperty("java.class.path");
            if (prop != null) {
                info = String.valueOf(info) + DxfViewer.makeInfoLine("Class path", prop) + '\n';
            }
        }
        catch (SecurityException securityException) {}
        try {
            prop = System.getProperty("java.class.version");
            if (prop != null) {
                info = String.valueOf(info) + DxfViewer.makeInfoLine("Class version", prop) + '\n';
            }
        }
        catch (SecurityException securityException) {}
        try {
            prop = System.getProperty("os.name");
            if (prop != null) {
                info = String.valueOf(info) + DxfViewer.makeInfoLine("OS name", prop) + '\n';
            }
        }
        catch (SecurityException securityException) {}
        try {
            prop = System.getProperty("os.arch");
            if (prop != null) {
                info = String.valueOf(info) + DxfViewer.makeInfoLine("OS architecture", prop) + '\n';
            }
        }
        catch (SecurityException securityException) {}
        try {
            prop = System.getProperty("os.version");
            if (prop != null) {
                info = String.valueOf(info) + DxfViewer.makeInfoLine("OS version", prop) + '\n';
            }
        }
        catch (SecurityException securityException) {}
        try {
            Runtime rt = Runtime.getRuntime();
            long total = rt.totalMemory();
            info = String.valueOf(info) + "\n" + DxfViewer.makeInfoLine(I18n.getString("vmTotalMemory", this.getLocale()), new Long(total));
            long free = rt.freeMemory();
            info = String.valueOf(info) + "\n" + DxfViewer.makeInfoLine(I18n.getString("vmFreeMemory", this.getLocale()), new Long(free));
            info = String.valueOf(info) + "\n" + DxfViewer.makeInfoLine(I18n.getString("vmUsedMemory", this.getLocale()), new Long(total - free));
        }
        catch (SecurityException securityException) {}
        return info;
    }

    public synchronized String getMessages() {
        return this.messageLog.toString();
    }

    public Frame getDialogParent() {
        return this.myWin != null ? this.myWin : Utility.getFrame(this);
    }

    private void displayLogWindow() {
        TextBox info = new TextBox((Component)this.getDialogParent(), this.getMessages(), I18n.getString("diaMessageLog", this.getLocale()));
        Font f = info.getFont();
        info.setFont(new Font("Monospaced", 0, f.getSize()));
        info.show();
    }

    public boolean fontsAvailable() {
        return this.haveFonts;
    }

    private void setMyLocale(Locale l) {
        if (this.myWin != null) {
            this.myWin.setLocale(l);
        }
        this.setLocale(l);
    }

    public void setLocale(Locale l) {
        super.setLocale(l);
        I18n.setDefaultLocale(l);
        myName = I18n.getString("appName", l);
        version = I18n.format("appVersion", versNum, l);
        int c = this.getComponentCount() - 1;
        while (c >= 0) {
            Component comp = this.getComponent(c);
            if (comp instanceof Localizable) {
                ((Localizable)((Object)comp)).setLocale(l);
            }
            --c;
        }
        this.invalidate();
        this.aboutBox = null;
        this.usageBox = null;
        this.showStatus(null);
        this.setTitle(this.fileName);
    }

    private static void testForLanguage(String lang) {
        if (lang != null) {
            int maxLen = 0;
            int maxInd = -1;
            int index = 0;
            while (index < locales.length) {
                String loc = locales[index].toString();
                if (lang.startsWith(loc) && loc.length() > maxLen) {
                    maxLen = loc.length();
                    maxInd = index;
                    if (maxLen == lang.length()) break;
                }
                ++index;
            }
            if (maxInd >= 0) {
                defaultLang = maxInd;
                I18n.setDefaultLocale(locales[defaultLang]);
            }
        }
    }

    public static void main(String[] argv) {
        String filename;
        DxfViewer.initDebug(System.getProperty(DEBUG_PROPERTY));
        if (argv.length == 0) {
            filename = null;
        } else if (argv.length == 1) {
            filename = argv[0];
        } else {
            System.out.println("Can only understand 1 command line argument...");
            return;
        }
        DxfViewer.testForLanguage(System.getProperty(LANG_PROPERTY));
        DxfViewer.startFrame(filename);
    }

    private static void startFrame(String filename) {
        RFrame win = new RFrame();
        ((Component)win).setSize(800, 600);
        DxfViewer dxf = new DxfViewer();
        dxf.init(filename, win);
        dxf.start();
        win.show();
    }

    public String getAppletInfo() {
        return String.valueOf(myName) + "\n" + version + " (" + mailto + ")";
    }

    public String[][] getParameterInfo() {
        return new String[][]{{"file", "URL", "DXF file to show in viewer (may be packed with zip/gzip)"}, {"language", "ISO code", "language (only de_DE (german) and english are supported)"}, {"framed", "boolean", "start viewer in frame when true"}, {"frameWidth", "int", "width of frame in pixel (only used when framed=true)"}, {"frameHeight", "int", "height of frame in pixel (only used when framed=true)"}, {"swapBW", "boolean", "swap black and white when true"}, {REDUCE_LINES_PROPERTY, "int", "number of lines in reduce mode"}, {PREVIEW_LINES_PROPERTY, "int", "number of lines in print preview"}, {"debug", "int", "debug level (Default: 0 =  debugging)"}};
    }

    private void exit() {
        this.savePersistentData();
        System.exit(0);
    }

    private void savePersistentData() {
        String home = System.getProperty("user.home");
        if (home == null) {
            home = ".";
        }
        try {
            FileOutputStream fOut = new FileOutputStream(String.valueOf(home) + File.separator + ".dxfviewrc");
            BufferedOutputStream bOut = new BufferedOutputStream(fOut);
            ObjectOutputStream out = new ObjectOutputStream(bOut);
            try {
                out.writeObject(this.psInfo);
                out.writeObject(this.myWin.getBounds());
                out.writeBoolean(this.modelDraw.isSwapBW());
                out.writeBoolean(this.modelDraw.getShowCoord());
                out.writeInt(this.modelDraw.getCoordPosition());
            }
            finally {
                Object var6_6 = null;
                out.close();
            }
        }
        catch (IOException x) {
            x.printStackTrace();
        }
    }

    private void loadPersistentData() {
        block7: {
            if (this.inAnApplet) {
                return;
            }
            String home = System.getProperty("user.home");
            if (home == null) {
                home = ".";
            }
            try {
                FileInputStream fIn = new FileInputStream(String.valueOf(home) + File.separator + ".dxfviewrc");
                try {
                    BufferedInputStream bIn = new BufferedInputStream(fIn);
                    ObjectInputStream in = new ObjectInputStream(bIn);
                    this.psInfo = (PostScriptOutputInfo)in.readObject();
                    Rectangle bounds = (Rectangle)in.readObject();
                    ((Component)this.myWin).setBounds(bounds);
                    this.initSwapBW = in.readBoolean();
                    this.initShowCS = in.readBoolean();
                    this.initCSPos = in.readInt();
                }
                finally {
                    Object var5_7 = null;
                    fIn.close();
                }
            }
            catch (Exception x) {
                if (debugLevel <= 0) break block7;
                x.printStackTrace();
            }
        }
    }

    public void loadFile(String url) {
        this.doLoad(url);
    }

    public int getNumberOfLayers() {
        return this.modelDraw.getNumberOfLayers();
    }

    public String getLayerName(int index) {
        return this.modelDraw.getLayerName(index);
    }

    public boolean isLayerIndexVisible(int index) {
        String name = this.getLayerName(index);
        return name == null ? false : this.isLayerVisible(name);
    }

    public boolean isLayerVisible(String name) {
        return this.modelDraw.isLayerVisible(name);
    }

    public void setLayerIndexVisible(int index, boolean visible) {
        String name = this.getLayerName(index);
        if (name != null) {
            this.setLayerVisible(name, visible);
        }
    }

    public void setLayerVisible(String name, boolean visible) {
        this.modelDraw.setLayerVisible(name, visible);
    }

    public void showLayerIndex(int index) {
        this.setLayerIndexVisible(index, true);
    }

    public void hideLayerIndex(int index) {
        this.setLayerIndexVisible(index, false);
    }

    public void showLayer(String name) {
        this.setLayerVisible(name, true);
    }

    public void hideLayer(String name) {
        this.setLayerVisible(name, false);
    }

    public void resetView() {
        this.resetViewXY();
    }

    public void resetViewXY() {
        this.modelDraw.resetViewStack('z');
    }

    public void resetViewYZ() {
        this.modelDraw.resetViewStack('x');
    }

    public void resetViewXZ() {
        this.modelDraw.resetViewStack('y');
    }

    public void showPreviousView() {
        this.modelDraw.goBackward();
    }

    public void showNextView() {
        this.modelDraw.goForward();
    }

    public Point3D getModelMinCorner() {
        return this.modelDraw.getMinPoint();
    }

    public double getModelMinCornerX() {
        Point3D minPoint = this.modelDraw.getMinPoint();
        return minPoint != null ? (double)minPoint.x : Double.MAX_VALUE;
    }

    public double getModelMinCornerY() {
        Point3D minPoint = this.modelDraw.getMinPoint();
        return minPoint != null ? (double)minPoint.y : Double.MAX_VALUE;
    }

    public double getModelMinCornerZ() {
        Point3D minPoint = this.modelDraw.getMinPoint();
        return minPoint != null ? (double)minPoint.z : Double.MAX_VALUE;
    }

    public Point3D getModelMaxCorner() {
        return this.modelDraw.getMaxPoint();
    }

    public double getModelMaxCornerX() {
        Point3D maxPoint = this.modelDraw.getMaxPoint();
        return maxPoint != null ? (double)maxPoint.x : Double.MIN_VALUE;
    }

    public double getModelMaxCornerY() {
        Point3D maxPoint = this.modelDraw.getMaxPoint();
        return maxPoint != null ? (double)maxPoint.y : Double.MIN_VALUE;
    }

    public double getModelMaxCornerZ() {
        Point3D maxPoint = this.modelDraw.getMaxPoint();
        return maxPoint != null ? (double)maxPoint.z : Double.MIN_VALUE;
    }

    public Vector3D getModelExtension() {
        Point3D modelMin = this.modelDraw.getMinPoint();
        Point3D modelMax = this.modelDraw.getMaxPoint();
        if (modelMin != null && modelMax != null) {
            return modelMax.minus(modelMin);
        }
        return null;
    }

    public double getModelExtensionX() {
        Vector3D extension = this.getModelExtension();
        return extension != null ? (double)extension.x : Double.MIN_VALUE;
    }

    public double getModelExtensionY() {
        Vector3D extension = this.getModelExtension();
        return extension != null ? (double)extension.y : Double.MIN_VALUE;
    }

    public double getModelExtensionZ() {
        Vector3D extension = this.getModelExtension();
        return extension != null ? (double)extension.z : Double.MIN_VALUE;
    }

    static /* synthetic */ int access$3() {
        return 2;
    }

    static {
        I18n.addAppResourceBase("de.escape.quincunx.dxf.DxfResourceBundle");
        I18n.setDefaultLocale(locales[defaultLang]);
        myName = I18n.getString("appName", null);
        version = I18n.format("appVersion", new String[]{versNum}, null);
        READ_COLOR = Color.red;
        CONV_COLOR = Color.blue;
        STD_COLOR = Color.black;
        WARN_COLOR = new Color(128, 0, 0);
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent event) {
            if (!DxfViewer.this.inAnApplet) {
                DxfViewer.this.exit();
            } else {
                ((Component)DxfViewer.this.myWin).setVisible(false);
            }
        }

        /* synthetic */ 1() {
        }
    }

    private static final class 2
    implements ActionListener {
        private final /* synthetic */ Frame val$win;

        public void actionPerformed(ActionEvent event) {
            ((Component)this.val$win).setVisible(true);
            this.val$win.toFront();
            this.val$win.requestFocus();
        }

        /* synthetic */ 2(Frame val$win) {
            this.val$win = val$win;
        }
    }

    private final class 3
    extends MouseAdapter {
        public void mouseClicked(MouseEvent event) {
            DxfViewer.this.displayLogWindow();
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            DxfViewer.this.exit();
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements ItemListener {
        public void itemStateChanged(ItemEvent event) {
            if (DxfViewer.this.modelDraw != null) {
                DxfViewer.this.modelDraw.setShowCoord(event.getStateChange() == 1);
            }
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    implements ItemListener {
        public void itemStateChanged(ItemEvent event) {
            if (DxfViewer.this.modelDraw != null) {
                DxfViewer.this.modelDraw.swapBlackAndWhite(event.getStateChange() == 1);
            }
        }

        /* synthetic */ 6() {
        }
    }

    class FileOpenAdapter
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            String file;
            FileDialog open = new FileDialog(DxfViewer.this.getDialogParent(), I18n.getString("diaOpenFile", DxfViewer.this.getLocale()), 0);
            if (DxfViewer.this.lastDir != null) {
                open.setDirectory(DxfViewer.this.lastDir);
            }
            open.show();
            DxfViewer.this.lastDir = open.getDirectory();
            if (DxfViewer.this.lastDir != null && (file = open.getFile()) != null) {
                DxfViewer.this.doLoad(String.valueOf(DxfViewer.this.lastDir) + file);
            }
        }

        FileOpenAdapter() {
            DxfViewer.this = DxfViewer.this;
        }
    }

    class FilePrintAdapter
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            PrintJob pj = DxfViewer.this.getToolkit().getPrintJob(DxfViewer.this.myWin, I18n.getString("diaPrint", DxfViewer.this.getLocale()), null);
            boolean monochromePrinting = Utility.getBooleanProperty("print.monochrome", false);
            if (pj != null) {
                DxfViewer.this.showStatusRes("msgPrinting");
                DxfViewer.this.setCursor(Cursor.getPredefinedCursor(3));
                DxfViewer.this.modelDraw.print(pj, monochromePrinting, false);
                pj.end();
                DxfViewer.this.setCursor(Cursor.getDefaultCursor());
                DxfViewer.this.showStatusRes("msgPrintingOk");
            }
        }

        FilePrintAdapter() {
            DxfViewer.this = DxfViewer.this;
        }
    }

    class FileSavePSAdapter
    implements ActionListener {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void actionPerformed(ActionEvent event) {
            OutputStream output;
            block17: {
                block18: {
                    output = null;
                    DxfViewer.this.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        try {
                            Dimension size = DxfViewer.this.modelDraw.getSize();
                            DxfViewer.this.psInfo.setTemporaryPainter(DxfViewer.this.modelDraw);
                            DxfViewer.this.psInfo.setAspectRatio((double)size.width / (double)size.height);
                            SavePostScriptDialog dialog = new SavePostScriptDialog(DxfViewer.this.myWin, DxfViewer.this.psInfo);
                            dialog.show();
                            PostScriptOutputInfo info = dialog.getOutputInfo();
                            if (info == null) break block17;
                            DxfViewer.this.psInfo = info;
                            if (info.isRunningCommand()) {
                                try {
                                    Process cmd = Runtime.getRuntime().exec(info.getCommandPath());
                                    output = cmd.getOutputStream();
                                }
                                catch (Exception exception) {
                                    new ErrorBox((Component)DxfViewer.this.getDialogParent(), I18n.format("err!noExec", info.getCommandPath(), DxfViewer.this.getLocale()));
                                    Object var4_8 = null;
                                    DxfViewer.this.setCursor(Cursor.getDefaultCursor());
                                    if (output == null) return;
                                    try {
                                        output.close();
                                        return;
                                    }
                                    catch (Throwable throwable) {}
                                    return;
                                }
                            }
                            File file = new File(info.getOutputPath());
                            if (file.exists() && !new YesNoBox((Component)DxfViewer.this.getDialogParent(), I18n.getString("diaOverwrite"), I18n.format("askOverwrite", info.getOutputPath(), DxfViewer.this.getLocale())).answer()) {
                                Object var4_9 = null;
                                break block18;
                            }
                            try {
                                output = new FileOutputStream(file);
                            }
                            catch (IOException iOException) {
                                new ErrorBox((Component)DxfViewer.this.getDialogParent(), I18n.format("err!openFile", info.getOutputPath(), DxfViewer.this.getLocale()));
                                Object var4_10 = null;
                                DxfViewer.this.setCursor(Cursor.getDefaultCursor());
                                if (output == null) return;
                                try {}
                                catch (Throwable throwable) {}
                                output.close();
                                return;
                            }
                            PostScriptFileSaveJob job = new PostScriptFileSaveJob(new File(DxfViewer.this.fileName).getName(), output, info);
                            boolean monochromePrinting = info.isMonochrome();
                            if (job != null) {
                                DxfViewer.this.showStatusRes("msgSavingPS");
                                DxfViewer.this.modelDraw.print(job, monochromePrinting, info.isRotated());
                                job.end();
                                DxfViewer.this.showStatusRes("msgSavingPSOk");
                            }
                            break block17;
                        }
                        catch (IOException x) {
                            new ErrorBox((Component)DxfViewer.this.getDialogParent(), I18n.format("err!savePS", x.getMessage(), DxfViewer.this.getLocale()));
                        }
                        break block17;
                    }
                    catch (Throwable throwable) {
                        Object var4_12 = null;
                        DxfViewer.this.setCursor(Cursor.getDefaultCursor());
                        if (output == null) throw throwable;
                        try {}
                        catch (Throwable throwable2) {}
                        output.close();
                        throw throwable;
                        throw throwable;
                    }
                }
                DxfViewer.this.setCursor(Cursor.getDefaultCursor());
                if (output == null) return;
                try {}
                catch (Throwable throwable) {}
                output.close();
                return;
            }
            Object var4_11 = null;
            DxfViewer.this.setCursor(Cursor.getDefaultCursor());
            if (output == null) return;
            try {}
            catch (Throwable throwable) {
                return;
            }
            output.close();
        }

        FileSavePSAdapter() {
            DxfViewer.this = DxfViewer.this;
        }
    }

    class LogMsgAdapter
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            DxfViewer.this.displayLogWindow();
        }

        LogMsgAdapter() {
            DxfViewer.this = DxfViewer.this;
        }
    }

    class ModelInfoAdapter
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            TextBox info = new TextBox((Component)DxfViewer.this.getDialogParent(), DxfViewer.this.getModelInfo(), I18n.getString("diaModelInfo", DxfViewer.this.getLocale()));
            Font f = info.getFont();
            info.setFont(new Font("Monospaced", 0, f.getSize()));
            info.show();
        }

        ModelInfoAdapter() {
            DxfViewer.this = DxfViewer.this;
        }
    }

    class VMInfoAdapter
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            TextBox info = new TextBox((Component)DxfViewer.this.getDialogParent(), DxfViewer.this.getVMInfo(), I18n.getString("diaVMInfo", DxfViewer.this.getLocale()));
            Font f = info.getFont();
            info.setFont(new Font("Monospaced", 0, f.getSize()));
            info.show();
        }

        VMInfoAdapter() {
            DxfViewer.this = DxfViewer.this;
        }
    }

    class UsageAdapter
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            if (DxfViewer.this.usageBox == null) {
                DxfViewer.this.usageBox = new TextBox((Component)DxfViewer.this.getDialogParent(), Utility.loadText(I18n.getString("fileHelpText", DxfViewer.this.getLocale())), I18n.getString("diaUsage", DxfViewer.this.getLocale()));
                Font f = DxfViewer.this.usageBox.getFont();
                DxfViewer.this.usageBox.setFont(new Font("Monospaced", 0, f.getSize()));
            }
            DxfViewer.this.usageBox.show();
        }

        UsageAdapter() {
            DxfViewer.this = DxfViewer.this;
        }
    }

    class AboutAdapter
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            if (DxfViewer.this.aboutBox == null) {
                DxfViewer.this.aboutBox = new ImageBox((Component)DxfViewer.this.getDialogParent(), new AboutCanvas(Utility.loadImage("dxfview.jpg", DxfViewer.this), myName, version, mailto), I18n.getString("diaAbout", DxfViewer.this.getLocale()));
            }
            DxfViewer.this.aboutBox.show();
        }

        AboutAdapter() {
            DxfViewer.this = DxfViewer.this;
        }
    }

    class LangListener
    implements ItemListener {
        private int lang;

        LangListener(int l) {
            DxfViewer.this = DxfViewer.this;
            this.lang = l;
        }

        public void itemStateChanged(ItemEvent event) {
            if (event.getStateChange() == 1) {
                int i = 0;
                while (i < DxfViewer.access$3()) {
                    DxfViewer.this.langCheck[i].setState(i == this.lang);
                    ++i;
                }
                DxfViewer.this.setMyLocale(locales[this.lang]);
            }
        }
    }

    class CsPosListener
    implements ItemListener {
        private int index;
        private int position;

        public CsPosListener(int ind, int pos) {
            DxfViewer.this = DxfViewer.this;
            this.index = ind;
            this.position = pos;
        }

        public void itemStateChanged(ItemEvent event) {
            if (event.getStateChange() == 1) {
                int i = 0;
                while (i < DxfViewer.this.csPos.length) {
                    DxfViewer.this.csPos[i].setState(i == this.index);
                    ++i;
                }
                if (DxfViewer.this.modelDraw != null) {
                    DxfViewer.this.modelDraw.setCoordPos(this.position);
                }
            }
        }
    }

    static class AboutCanvas
    extends ImageCanvas {
        private static final int PROGNAME_OFFSET = 36;
        private static final int VERSION_OFFSET = 20;
        private static final int MAILTO_OFFSET = 5;
        private static final int SHADOW_OFFSET = 1;
        private static final int PROGNAME_SIZE = 24;
        private static final int VERSION_SIZE = 12;
        String progname;
        String version;
        String mailto;

        AboutCanvas(Image img, String progname, String version, String mailto) {
            super(img, true, 4);
            this.progname = progname;
            this.version = version;
            this.mailto = mailto;
        }

        public void paint(Graphics g) {
            super.paint(g);
            Dimension size = this.getSize();
            Font f = new Font("SansSerif", 1, 24);
            FontMetrics fm = g.getFontMetrics(f);
            int width = fm.stringWidth(this.progname);
            g.setFont(f);
            g.setColor(Color.black);
            g.drawString(this.progname, (size.width - width) / 2 + 1, size.height - 36 + 1);
            g.setColor(Color.blue);
            g.drawString(this.progname, (size.width - width) / 2, size.height - 36);
            f = new Font("SansSerif", 0, 12);
            fm = g.getFontMetrics(f);
            g.setFont(f);
            g.setColor(Color.green);
            width = fm.stringWidth(this.version);
            g.drawString(this.version, (size.width - width) / 2, size.height - 20);
            width = fm.stringWidth(this.mailto);
            g.drawString(this.mailto, (size.width - width) / 2, size.height - 5);
        }
    }
}

