/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.io.IOException;
import org.msgpack.MessageTypeException;
import org.msgpack.packer.Packer;
import org.msgpack.template.AbstractTemplate;
import org.msgpack.unpacker.Unpacker;

public class LongTemplate
extends AbstractTemplate<Long> {
    static final LongTemplate instance = new LongTemplate();

    private LongTemplate() {
    }

    @Override
    public void write(Packer pk, Long target, boolean required) throws IOException {
        if (target == null) {
            if (required) {
                throw new MessageTypeException("Attempted to write null");
            }
            pk.writeNil();
            return;
        }
        pk.write((long)target);
    }

    @Override
    public Long read(Unpacker u, Long to, boolean required) throws IOException {
        if (!required && u.trySkipNil()) {
            return null;
        }
        return u.readLong();
    }

    public static LongTemplate getInstance() {
        return instance;
    }
}

