/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Hashtable;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsProtocol;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.util.Integers;

public class TlsSRPUtils {
    public static final Integer EXT_SRP = Integers.valueOf(12);

    public static void addSRPExtension(Hashtable hashtable, byte[] byArray) throws IOException {
        hashtable.put(EXT_SRP, TlsSRPUtils.createSRPExtension(byArray));
    }

    public static byte[] getSRPExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_SRP);
        return byArray == null ? null : TlsSRPUtils.readSRPExtension(byArray);
    }

    public static byte[] createSRPExtension(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new TlsFatalAlert(80);
        }
        return TlsUtils.encodeOpaque8(byArray);
    }

    public static byte[] readSRPExtension(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        byte[] byArray2 = TlsUtils.readOpaque8(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        return byArray2;
    }
}

