/*
 * Decompiled with CFR 0.152.
 */
package nokogiri.internals;

import java.io.IOException;
import nokogiri.internals.ParserContext;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.parsers.XIncludeParserConfiguration;
import org.apache.xerces.xni.XMLDTDContentModelHandler;
import org.apache.xerces.xni.XMLDTDHandler;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.cyberneko.dtd.DTDConfiguration;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class NokogiriDomParser
extends DOMParser {
    protected DOMParser dtd;
    protected boolean xInclude;
    protected XMLParserConfiguration config;

    public NokogiriDomParser(XMLParserConfiguration xMLParserConfiguration) {
        super(xMLParserConfiguration);
        this.config = xMLParserConfiguration;
        this.initialize();
    }

    public NokogiriDomParser(ParserContext.Options options) {
        this.xInclude = options.xInclude;
        this.initialize();
    }

    protected void initialize() {
        if (this.config == null) {
            this.config = this.xInclude ? new XIncludeParserConfiguration() : this.getXMLParserConfiguration();
        }
        DTDConfiguration dTDConfiguration = new DTDConfiguration();
        this.dtd = new DOMParser((XMLParserConfiguration)dTDConfiguration);
        this.config.setDTDHandler((XMLDTDHandler)dTDConfiguration);
        this.config.setDTDContentModelHandler((XMLDTDContentModelHandler)dTDConfiguration);
    }

    public void parse(InputSource inputSource) throws SAXException, IOException {
        this.dtd.reset();
        if (this.xInclude) {
            this.setEntityResolver(new NokogiriXInlcudeEntityResolver(inputSource));
        }
        super.parse(inputSource);
        Document document = this.getDocument();
        if (document == null) {
            throw new RuntimeException("null document");
        }
        document.setUserData("DTD_RAW_DOCUMENT", this.dtd.getDocument(), null);
    }

    private class NokogiriXInlcudeEntityResolver
    implements EntityResolver {
        InputSource source;

        private NokogiriXInlcudeEntityResolver(InputSource inputSource) {
            this.source = inputSource;
        }

        @Override
        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            if (string2 != null) {
                this.source.setSystemId(string2);
            }
            if (string != null) {
                this.source.setPublicId(string);
            }
            return this.source;
        }
    }
}

