/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.cbutil;

import com.ca.commons.cbutil.CBButton;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.text.JTextComponent;

public class CBFileChooserButton
extends CBButton
implements ActionListener {
    static String globalLastDirectory = "";
    String localLastDirectory = "";
    boolean useLocal = false;
    JTextComponent myText;
    Component parent;

    public CBFileChooserButton(JTextComponent text, Component GUIparent) {
        this(text, GUIparent, "File");
    }

    public CBFileChooserButton(JTextComponent text, Component GUIparent, String buttonName) {
        this(text, GUIparent, buttonName, "");
    }

    public CBFileChooserButton(JTextComponent text, Component GUIparent, String buttonName, String tooltip) {
        super(buttonName, tooltip, new ImageIcon("open.gif"));
        this.myText = text;
        this.parent = GUIparent;
        this.addActionListener(this);
    }

    public void setLocalDirectoryUse(boolean state) {
        this.useLocal = state;
    }

    public boolean getLocalDirectoryUse() {
        return this.useLocal;
    }

    public static void setGlobalDirectory(String dirString) {
        globalLastDirectory = dirString;
    }

    public void setStartingDirectory(String dirString) {
        if (this.useLocal) {
            this.localLastDirectory = dirString;
        } else {
            CBFileChooserButton.setGlobalDirectory(dirString);
        }
    }

    public String getStartingDirectory() {
        return this.useLocal ? this.localLastDirectory : globalLastDirectory;
    }

    public void actionPerformed(ActionEvent e) {
        String lastDirectory = this.useLocal ? this.localLastDirectory : globalLastDirectory;
        try {
            if (!new File(lastDirectory).exists()) {
                lastDirectory = null;
            }
        }
        catch (Exception ex) {
            lastDirectory = null;
        }
        JFileChooser chooser = new JFileChooser(lastDirectory);
        int option = chooser.showOpenDialog(this.parent);
        if (option == 0) {
            this.setStartingDirectory(chooser.getSelectedFile().getParent());
            File readFile = chooser.getSelectedFile();
            this.myText.setText(readFile.toString());
        }
    }
}

