/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v2;

import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.List;
import org.postgresql.Driver;
import org.postgresql.copy.CopyOperation;
import org.postgresql.core.Field;
import org.postgresql.core.Logger;
import org.postgresql.core.Notification;
import org.postgresql.core.PGStream;
import org.postgresql.core.ParameterList;
import org.postgresql.core.Query;
import org.postgresql.core.QueryExecutor;
import org.postgresql.core.ResultCursor;
import org.postgresql.core.ResultHandler;
import org.postgresql.core.v2.FastpathParameterList;
import org.postgresql.core.v2.ProtocolConnectionImpl;
import org.postgresql.core.v2.SimpleParameterList;
import org.postgresql.core.v2.V2Query;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class QueryExecutorImpl
implements QueryExecutor {
    private final ProtocolConnectionImpl protoConnection;
    private final PGStream pgStream;
    private final Logger logger;

    public QueryExecutorImpl(ProtocolConnectionImpl protoConnection, PGStream pgStream, Logger logger) {
        this.protoConnection = protoConnection;
        this.pgStream = pgStream;
        this.logger = logger;
    }

    public Query createSimpleQuery(String sql) {
        return new V2Query(sql, false, this.protoConnection);
    }

    public Query createParameterizedQuery(String sql) {
        return new V2Query(sql, true, this.protoConnection);
    }

    public ParameterList createFastpathParameters(int count) {
        return new FastpathParameterList(count);
    }

    public synchronized byte[] fastpathCall(int fnid, ParameterList parameters, boolean suppressBegin) throws SQLException {
        if (this.protoConnection.getTransactionState() == 0 && !suppressBegin) {
            if (this.logger.logDebug()) {
                this.logger.debug("Issuing BEGIN before fastpath call.");
            }
            ResultHandler handler = new ResultHandler(){
                private boolean sawBegin = false;
                private SQLException sqle = null;

                public void handleResultRows(Query fromQuery, Field[] fields, List tuples, ResultCursor cursor) {
                }

                public void handleCommandStatus(String status, int updateCount, long insertOID) {
                    if (!this.sawBegin) {
                        if (!status.equals("BEGIN")) {
                            this.handleError(new PSQLException(GT.tr("Expected command status BEGIN, got {0}.", status), PSQLState.PROTOCOL_VIOLATION));
                        }
                        this.sawBegin = true;
                    } else {
                        this.handleError(new PSQLException(GT.tr("Unexpected command status: {0}.", status), PSQLState.PROTOCOL_VIOLATION));
                    }
                }

                public void handleWarning(SQLWarning warning) {
                    this.handleError(warning);
                }

                public void handleError(SQLException error) {
                    if (this.sqle == null) {
                        this.sqle = error;
                    } else {
                        this.sqle.setNextException(error);
                    }
                }

                public void handleCompletion() throws SQLException {
                    if (this.sqle != null) {
                        throw this.sqle;
                    }
                }
            };
            try {
                V2Query query = (V2Query)this.createSimpleQuery("");
                SimpleParameterList params = (SimpleParameterList)query.createParameterList();
                this.sendQuery(query, params, "BEGIN");
                this.processResults(query, handler, 0, 0);
            }
            catch (IOException ioe) {
                throw new PSQLException(GT.tr("An I/O error occured while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)ioe);
            }
        }
        try {
            this.sendFastpathCall(fnid, (FastpathParameterList)parameters);
            return this.receiveFastpathResult();
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("An I/O error occured while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)ioe);
        }
    }

    private void sendFastpathCall(int fnid, FastpathParameterList params) throws IOException {
        int count = params.getParameterCount();
        if (this.logger.logDebug()) {
            this.logger.debug(" FE=> FastpathCall(fnid=" + fnid + ",paramCount=" + count + ")");
        }
        this.pgStream.SendChar(70);
        this.pgStream.SendChar(0);
        this.pgStream.SendInteger4(fnid);
        this.pgStream.SendInteger4(count);
        for (int i = 1; i <= count; ++i) {
            params.writeV2FastpathValue(i, this.pgStream);
        }
        this.pgStream.flush();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void processNotifies() throws SQLException {
        if (this.protoConnection.getTransactionState() != 0) {
            return;
        }
        try {
            int c;
            block7: while (this.pgStream.hasMessagePending()) {
                c = this.pgStream.ReceiveChar();
                switch (c) {
                    case 65: {
                        this.receiveAsyncNotify();
                        continue block7;
                    }
                    case 69: {
                        throw this.receiveErrorMessage();
                    }
                    case 78: {
                        this.protoConnection.addWarning(this.receiveNotification());
                        continue block7;
                    }
                }
            }
            return;
            throw new PSQLException(GT.tr("Unknown Response Type {0}.", new Character((char)c)), PSQLState.CONNECTION_FAILURE);
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("An I/O error occured while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)ioe);
        }
    }

    private byte[] receiveFastpathResult() throws IOException, SQLException {
        SQLException error = null;
        boolean endQuery = false;
        byte[] result = null;
        block7: while (!endQuery) {
            int c = this.pgStream.ReceiveChar();
            switch (c) {
                case 65: {
                    this.receiveAsyncNotify();
                    continue block7;
                }
                case 69: {
                    SQLException newError = this.receiveErrorMessage();
                    if (error == null) {
                        error = newError;
                        continue block7;
                    }
                    error.setNextException(newError);
                    continue block7;
                }
                case 78: {
                    this.protoConnection.addWarning(this.receiveNotification());
                    continue block7;
                }
                case 86: {
                    c = this.pgStream.ReceiveChar();
                    if (c == 71) {
                        if (this.logger.logDebug()) {
                            this.logger.debug(" <=BE FastpathResult");
                        }
                        int len = this.pgStream.ReceiveInteger4();
                        result = this.pgStream.Receive(len);
                        c = this.pgStream.ReceiveChar();
                    } else if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE FastpathVoidResult");
                    }
                    if (c == 48) continue block7;
                    throw new PSQLException(GT.tr("Unknown Response Type {0}.", new Character((char)c)), PSQLState.CONNECTION_FAILURE);
                }
                case 90: {
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE ReadyForQuery");
                    }
                    endQuery = true;
                    continue block7;
                }
            }
            throw new PSQLException(GT.tr("Unknown Response Type {0}.", new Character((char)c)), PSQLState.CONNECTION_FAILURE);
        }
        if (error != null) {
            throw error;
        }
        return result;
    }

    public synchronized void execute(Query query, ParameterList parameters, ResultHandler handler, int maxRows, int fetchSize, int flags) throws SQLException {
        this.execute((V2Query)query, (SimpleParameterList)parameters, handler, maxRows, flags);
    }

    public synchronized void execute(Query[] queries, ParameterList[] parameters, ResultHandler handler, int maxRows, int fetchSize, int flags) throws SQLException {
        final ResultHandler delegateHandler = handler;
        handler = new ResultHandler(){

            public void handleResultRows(Query fromQuery, Field[] fields, List tuples, ResultCursor cursor) {
                delegateHandler.handleResultRows(fromQuery, fields, tuples, cursor);
            }

            public void handleCommandStatus(String status, int updateCount, long insertOID) {
                delegateHandler.handleCommandStatus(status, updateCount, insertOID);
            }

            public void handleWarning(SQLWarning warning) {
                delegateHandler.handleWarning(warning);
            }

            public void handleError(SQLException error) {
                delegateHandler.handleError(error);
            }

            public void handleCompletion() throws SQLException {
            }
        };
        for (int i = 0; i < queries.length; ++i) {
            this.execute((V2Query)queries[i], (SimpleParameterList)parameters[i], handler, maxRows, flags);
        }
        delegateHandler.handleCompletion();
    }

    public void fetch(ResultCursor cursor, ResultHandler handler, int rows) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "fetch(ResultCursor,ResultHandler,int)");
    }

    private void execute(V2Query query, SimpleParameterList parameters, ResultHandler handler, int maxRows, int flags) throws SQLException {
        if ((flags & 0x20) != 0) {
            return;
        }
        if (parameters == null) {
            parameters = (SimpleParameterList)query.createParameterList();
        }
        parameters.checkAllParametersSet();
        String queryPrefix = null;
        if (this.protoConnection.getTransactionState() == 0 && (flags & 0x10) == 0) {
            queryPrefix = "BEGIN;";
            final ResultHandler delegateHandler = handler;
            handler = new ResultHandler(){
                private boolean sawBegin = false;

                public void handleResultRows(Query fromQuery, Field[] fields, List tuples, ResultCursor cursor) {
                    if (this.sawBegin) {
                        delegateHandler.handleResultRows(fromQuery, fields, tuples, cursor);
                    }
                }

                public void handleCommandStatus(String status, int updateCount, long insertOID) {
                    if (!this.sawBegin) {
                        if (!status.equals("BEGIN")) {
                            this.handleError(new PSQLException(GT.tr("Expected command status BEGIN, got {0}.", status), PSQLState.PROTOCOL_VIOLATION));
                        }
                        this.sawBegin = true;
                    } else {
                        delegateHandler.handleCommandStatus(status, updateCount, insertOID);
                    }
                }

                public void handleWarning(SQLWarning warning) {
                    delegateHandler.handleWarning(warning);
                }

                public void handleError(SQLException error) {
                    delegateHandler.handleError(error);
                }

                public void handleCompletion() throws SQLException {
                    delegateHandler.handleCompletion();
                }
            };
        }
        try {
            this.sendQuery(query, parameters, queryPrefix);
            this.processResults(query, handler, maxRows, flags);
        }
        catch (IOException e) {
            this.protoConnection.close();
            handler.handleError(new PSQLException(GT.tr("An I/O error occured while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)e));
        }
        handler.handleCompletion();
    }

    protected void sendQuery(V2Query query, SimpleParameterList params, String queryPrefix) throws IOException {
        if (this.logger.logDebug()) {
            this.logger.debug(" FE=> Query(\"" + (queryPrefix == null ? "" : queryPrefix) + query.toString(params) + "\")");
        }
        this.pgStream.SendChar(81);
        Writer encodingWriter = this.pgStream.getEncodingWriter();
        if (queryPrefix != null) {
            encodingWriter.write(queryPrefix);
        }
        String[] fragments = query.getFragments();
        for (int i = 0; i < fragments.length; ++i) {
            encodingWriter.write(fragments[i]);
            if (i >= params.getParameterCount()) continue;
            params.writeV2Value(i + 1, encodingWriter);
        }
        encodingWriter.write(0);
        this.pgStream.flush();
    }

    /*
     * Unable to fully structure code
     */
    protected void processResults(Query originalQuery, ResultHandler handler, int maxRows, int flags) throws IOException {
        bothRowsAndStatus = (flags & 64) != 0;
        fields = null;
        tuples = null;
        endQuery = false;
        block16: while (!endQuery) {
            c = this.pgStream.ReceiveChar();
            switch (c) {
                case 65: {
                    this.receiveAsyncNotify();
                    break;
                }
                case 66: {
                    if (fields == null) {
                        throw new IOException("Data transfer before field metadata");
                    }
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE BinaryRow");
                    }
                    tuple = null;
                    try {
                        tuple = this.pgStream.ReceiveTupleV2(fields.length, true);
                    }
                    catch (OutOfMemoryError oome) {
                        if (maxRows != 0 && tuples.size() >= maxRows) ** GOTO lbl23
                        handler.handleError(new PSQLException(GT.tr("Ran out of memory retrieving query results."), PSQLState.OUT_OF_MEMORY, (Throwable)oome));
                    }
lbl23:
                    // 4 sources

                    for (i = 0; i < fields.length; ++i) {
                        fields[i].setFormat(1);
                    }
                    if (maxRows != 0 && tuples.size() >= maxRows) continue block16;
                    tuples.add(tuple);
                    break;
                }
                case 67: {
                    status = this.pgStream.ReceiveString();
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE CommandStatus(" + status + ")");
                    }
                    if (fields != null) {
                        handler.handleResultRows(originalQuery, fields, tuples, null);
                        fields = null;
                        if (!bothRowsAndStatus) continue block16;
                        this.interpretCommandStatus(status, handler);
                        break;
                    }
                    this.interpretCommandStatus(status, handler);
                    break;
                }
                case 68: {
                    if (fields == null) {
                        throw new IOException("Data transfer before field metadata");
                    }
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE DataRow");
                    }
                    tuple = null;
                    try {
                        tuple = this.pgStream.ReceiveTupleV2(fields.length, false);
                    }
                    catch (OutOfMemoryError oome) {
                        if (maxRows != 0 && tuples.size() >= maxRows) ** GOTO lbl54
                        handler.handleError(new PSQLException(GT.tr("Ran out of memory retrieving query results."), PSQLState.OUT_OF_MEMORY, (Throwable)oome));
                    }
lbl54:
                    // 3 sources

                    if (maxRows != 0 && tuples.size() >= maxRows) continue block16;
                    tuples.add(tuple);
                    break;
                }
                case 69: {
                    handler.handleError(this.receiveErrorMessage());
                    break;
                }
                case 73: {
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE EmptyQuery");
                    }
                    if ((c = this.pgStream.ReceiveChar()) == 0) continue block16;
                    throw new IOException("Expected \\0 after EmptyQuery, got: " + c);
                }
                case 78: {
                    handler.handleWarning(this.receiveNotification());
                    break;
                }
                case 80: {
                    portalName = this.pgStream.ReceiveString();
                    if (!this.logger.logDebug()) continue block16;
                    this.logger.debug(" <=BE PortalName(" + portalName + ")");
                    break;
                }
                case 84: {
                    fields = this.receiveFields();
                    tuples = new ArrayList<byte[][]>();
                    break;
                }
                case 90: {
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE ReadyForQuery");
                    }
                    endQuery = true;
                    break;
                }
                default: {
                    throw new IOException("Unexpected packet type: " + c);
                }
            }
        }
    }

    private Field[] receiveFields() throws IOException {
        int size = this.pgStream.ReceiveInteger2();
        Field[] fields = new Field[size];
        if (this.logger.logDebug()) {
            this.logger.debug(" <=BE RowDescription(" + fields.length + ")");
        }
        for (int i = 0; i < fields.length; ++i) {
            String columnLabel = this.pgStream.ReceiveString();
            int typeOid = this.pgStream.ReceiveInteger4();
            int typeLength = this.pgStream.ReceiveInteger2();
            int typeModifier = this.pgStream.ReceiveInteger4();
            fields[i] = new Field(columnLabel, columnLabel, typeOid, typeLength, typeModifier, 0, 0);
        }
        return fields;
    }

    private void receiveAsyncNotify() throws IOException {
        int pid = this.pgStream.ReceiveInteger4();
        String msg = this.pgStream.ReceiveString();
        if (this.logger.logDebug()) {
            this.logger.debug(" <=BE AsyncNotify(pid=" + pid + ",msg=" + msg + ")");
        }
        this.protoConnection.addNotification(new Notification(msg, pid));
    }

    private SQLException receiveErrorMessage() throws IOException {
        String errorMsg = this.pgStream.ReceiveString().trim();
        if (this.logger.logDebug()) {
            this.logger.debug(" <=BE ErrorResponse(" + errorMsg + ")");
        }
        return new PSQLException(errorMsg, PSQLState.UNKNOWN_STATE);
    }

    private SQLWarning receiveNotification() throws IOException {
        String warnMsg = this.pgStream.ReceiveString();
        int severityMark = warnMsg.indexOf(":");
        warnMsg = warnMsg.substring(severityMark + 1).trim();
        if (this.logger.logDebug()) {
            this.logger.debug(" <=BE NoticeResponse(" + warnMsg + ")");
        }
        return new SQLWarning(warnMsg);
    }

    private void interpretCommandStatus(String status, ResultHandler handler) throws IOException {
        int update_count = 0;
        long insert_oid = 0L;
        if (status.equals("BEGIN")) {
            this.protoConnection.setTransactionState(1);
        } else if (status.equals("COMMIT") || status.equals("ROLLBACK")) {
            this.protoConnection.setTransactionState(0);
        } else if (status.startsWith("INSERT") || status.startsWith("UPDATE") || status.startsWith("DELETE") || status.startsWith("MOVE")) {
            try {
                update_count = Integer.parseInt(status.substring(1 + status.lastIndexOf(32)));
                if (status.startsWith("INSERT")) {
                    insert_oid = Long.parseLong(status.substring(1 + status.indexOf(32), status.lastIndexOf(32)));
                }
            }
            catch (NumberFormatException nfe) {
                handler.handleError(new PSQLException(GT.tr("Unable to interpret the update count in command completion tag: {0}.", status), PSQLState.CONNECTION_FAILURE));
                return;
            }
        }
        handler.handleCommandStatus(status, update_count, insert_oid);
    }

    public CopyOperation startCopy(String sql, boolean suppressBegin) throws SQLException {
        throw new PSQLException(GT.tr("Copy not implemented for protocol version 2"), PSQLState.NOT_IMPLEMENTED);
    }
}

