/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.interop;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.Source;
import java.io.IOException;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.string.StringCachingGuards;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.interop.ToJavaStringNode;
import org.jruby.util.ByteList;

@CoreClass(value="Truffle::Interop")
public abstract class InteropNodes {

    @CoreMethod(names={"eval"}, isModuleFunction=true, needsSelf=false, required=2)
    @ImportStatic(value={StringCachingGuards.class})
    public static abstract class EvalNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isRubyString(mimeType)", "isRubyString(source)", "ropesEqual(mimeType, cachedMimeType)", "ropesEqual(source, cachedSource)"}, limit="getCacheLimit()")
        public Object evalCached(VirtualFrame frame, DynamicObject mimeType, DynamicObject source, @Cached(value="privatizeRope(mimeType)") Rope cachedMimeType, @Cached(value="privatizeRope(source)") Rope cachedSource, @Cached(value="create(parse(mimeType, source))") DirectCallNode callNode) {
            return callNode.call(frame, new Object[0]);
        }

        @Specialization(guards={"isRubyString(mimeType)", "isRubyString(source)"}, contains={"evalCached"})
        public Object evalUncached(VirtualFrame frame, DynamicObject mimeType, DynamicObject source, @Cached(value="create()") IndirectCallNode callNode) {
            return callNode.call(frame, this.parse(mimeType, source), new Object[0]);
        }

        @CompilerDirectives.TruffleBoundary
        protected CallTarget parse(DynamicObject mimeType, DynamicObject source) {
            String mimeTypeString = mimeType.toString();
            Source sourceObject = Source.fromText(source.toString(), "(eval)").withMimeType(mimeTypeString);
            try {
                return this.getContext().getEnv().parse(sourceObject, new String[0]);
            }
            catch (IOException e) {
                CompilerDirectives.transferToInterpreter();
                throw new RuntimeException(e);
            }
        }

        protected int getCacheLimit() {
            return this.getContext().getOptions().EVAL_CACHE;
        }
    }

    @CoreMethod(names={"mime_type_supported?"}, isModuleFunction=true, needsSelf=false, required=1)
    public static abstract class MimeTypeSupportedNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(mimeType)"})
        public boolean isMimeTypeSupported(DynamicObject mimeType) {
            return this.getContext().getEnv().isMimeTypeSupported(mimeType.toString());
        }
    }

    @CoreMethod(names={"import"}, isModuleFunction=true, needsSelf=false, required=1)
    public static abstract class ImportNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(name) || isRubySymbol(name)"})
        public Object importObject(DynamicObject name) {
            return this.getContext().getInteropManager().importObject(name.toString());
        }
    }

    @CoreMethod(names={"export"}, isModuleFunction=true, needsSelf=false, required=2)
    public static abstract class ExportNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(name) || isRubySymbol(name)"})
        public Object export(DynamicObject name, TruffleObject object) {
            this.getContext().getInteropManager().exportObject(name.toString(), object);
            return object;
        }
    }

    @CoreMethod(names={"write"}, isModuleFunction=true, needsSelf=false, required=3)
    @ImportStatic(value={StringCachingGuards.class})
    public static abstract class WriteNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"!isRubySymbol(identifier)", "!isRubyString(identifier)"})
        public Object write(VirtualFrame frame, TruffleObject receiver, Object identifier, Object value, @Cached(value="createWriteNode()") Node writeNode, @Cached(value="create()") BranchProfile exceptionProfile) {
            try {
                return ForeignAccess.sendWrite(writeNode, frame, receiver, identifier, value);
            }
            catch (UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException e) {
                exceptionProfile.enter();
                throw new RuntimeException(e);
            }
        }

        @Specialization(guards={"identifier == cachedIdentifier", "isRubySymbol(cachedIdentifier)"})
        public Object write(VirtualFrame frame, TruffleObject receiver, DynamicObject identifier, Object value, @Cached(value="identifier") DynamicObject cachedIdentifier, @Cached(value="cachedIdentifier.toString()") String identifierString, @Cached(value="createWriteNode()") Node writeNode, @Cached(value="create()") BranchProfile exceptionProfile) {
            try {
                return ForeignAccess.sendWrite(writeNode, frame, receiver, identifierString, value);
            }
            catch (UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException e) {
                exceptionProfile.enter();
                throw new RuntimeException(e);
            }
        }

        @Specialization(guards={"isRubyString(identifier)", "ropesEqual(identifier, cachedIdentifier)"}, limit="getCacheLimit()")
        public Object writeCached(VirtualFrame frame, TruffleObject receiver, DynamicObject identifier, Object value, @Cached(value="privatizeRope(identifier)") Rope cachedIdentifier, @Cached(value="cachedIdentifier.toString()") String identifierString, @Cached(value="createWriteNode()") Node writeNode, @Cached(value="create()") BranchProfile exceptionProfile) {
            try {
                return ForeignAccess.sendWrite(writeNode, frame, receiver, identifierString, value);
            }
            catch (UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException e) {
                exceptionProfile.enter();
                throw new RuntimeException(e);
            }
        }

        @Specialization(guards={"isRubyString(identifier)"}, contains={"writeCached"})
        public Object writeUncached(VirtualFrame frame, TruffleObject receiver, DynamicObject identifier, Object value, @Cached(value="createWriteNode()") Node writeNode, @Cached(value="create()") BranchProfile exceptionProfile) {
            try {
                return ForeignAccess.sendWrite(writeNode, frame, receiver, this.objectToString(identifier), value);
            }
            catch (UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException e) {
                exceptionProfile.enter();
                throw new RuntimeException(e);
            }
        }

        @CompilerDirectives.TruffleBoundary
        protected String objectToString(Object object) {
            return object.toString();
        }

        protected static Node createWriteNode() {
            return Message.WRITE.createNode();
        }

        protected int getCacheLimit() {
            return this.getContext().getOptions().INTEROP_WRITE_CACHE;
        }
    }

    @CoreMethod(names={"read"}, isModuleFunction=true, needsSelf=false, required=2)
    @ImportStatic(value={StringCachingGuards.class})
    public static abstract class ReadNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"!isRubySymbol(identifier)", "!isRubyString(identifier)"})
        public Object read(VirtualFrame frame, TruffleObject receiver, Object identifier, @Cached(value="createReadNode()") Node readNode, @Cached(value="create()") BranchProfile exceptionProfile) {
            try {
                return ForeignAccess.sendRead(readNode, frame, receiver, identifier);
            }
            catch (UnknownIdentifierException | UnsupportedMessageException e) {
                exceptionProfile.enter();
                throw new RuntimeException(e);
            }
        }

        @Specialization(guards={"identifier == cachedIdentifier", "isRubySymbol(cachedIdentifier)"})
        public Object read(VirtualFrame frame, TruffleObject receiver, DynamicObject identifier, @Cached(value="identifier") DynamicObject cachedIdentifier, @Cached(value="cachedIdentifier.toString()") String identifierString, @Cached(value="createReadNode()") Node readNode, @Cached(value="create()") BranchProfile exceptionProfile) {
            try {
                return ForeignAccess.sendRead(readNode, frame, receiver, identifierString);
            }
            catch (UnknownIdentifierException | UnsupportedMessageException e) {
                exceptionProfile.enter();
                throw new RuntimeException(e);
            }
        }

        @Specialization(guards={"isRubyString(identifier)", "ropesEqual(identifier, cachedIdentifier)"}, limit="getCacheLimit()")
        public Object readCached(VirtualFrame frame, TruffleObject receiver, DynamicObject identifier, @Cached(value="privatizeRope(identifier)") Rope cachedIdentifier, @Cached(value="cachedIdentifier.toString()") String identifierString, @Cached(value="createReadNode()") Node readNode, @Cached(value="create()") BranchProfile exceptionProfile) {
            try {
                return ForeignAccess.sendRead(readNode, frame, receiver, identifierString);
            }
            catch (UnknownIdentifierException | UnsupportedMessageException e) {
                exceptionProfile.enter();
                throw new RuntimeException(e);
            }
        }

        @Specialization(guards={"isRubyString(identifier)"}, contains={"readCached"})
        public Object readUncached(VirtualFrame frame, TruffleObject receiver, DynamicObject identifier, @Cached(value="createReadNode()") Node readNode, @Cached(value="create()") BranchProfile exceptionProfile) {
            try {
                return ForeignAccess.sendRead(readNode, frame, receiver, this.objectToString(identifier));
            }
            catch (UnknownIdentifierException | UnsupportedMessageException e) {
                exceptionProfile.enter();
                throw new RuntimeException(e);
            }
        }

        @CompilerDirectives.TruffleBoundary
        protected String objectToString(Object object) {
            return object.toString();
        }

        protected static Node createReadNode() {
            return Message.READ.createNode();
        }

        protected int getCacheLimit() {
            return this.getContext().getOptions().INTEROP_READ_CACHE;
        }
    }

    @CoreMethod(names={"null?"}, isModuleFunction=true, needsSelf=false, required=1)
    public static abstract class NullNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public boolean isNull(VirtualFrame frame, TruffleObject receiver, @Cached(value="createIsNullNode()") Node isNullNode) {
            return ForeignAccess.sendIsNull(isNullNode, frame, receiver);
        }

        protected Node createIsNullNode() {
            return Message.IS_NULL.createNode();
        }

        @Fallback
        public boolean isNull(Object receiver) {
            return false;
        }
    }

    @CoreMethod(names={"unbox"}, isModuleFunction=true, needsSelf=false, required=1)
    public static abstract class UnboxNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject unbox(CharSequence receiver) {
            return Layouts.STRING.createString(this.coreLibrary().getStringFactory(), StringOperations.ropeFromByteList(ByteList.create((CharSequence)receiver)));
        }

        @Specialization
        public Object unbox(VirtualFrame frame, TruffleObject receiver, @Cached(value="createUnboxNode()") Node unboxNode, @Cached(value="create()") BranchProfile exceptionProfile) {
            try {
                return ForeignAccess.sendUnbox(unboxNode, frame, receiver);
            }
            catch (UnsupportedMessageException e) {
                exceptionProfile.enter();
                throw new RuntimeException(e);
            }
        }

        protected Node createUnboxNode() {
            return Message.UNBOX.createNode();
        }

        @Fallback
        public Object unbox(Object receiver) {
            return receiver;
        }
    }

    @CoreMethod(names={"boxed?"}, isModuleFunction=true, needsSelf=false, required=1)
    public static abstract class BoxedNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public boolean isBoxed(boolean receiver) {
            return true;
        }

        @Specialization
        public boolean isBoxed(byte receiver) {
            return true;
        }

        @Specialization
        public boolean isBoxed(short receiver) {
            return true;
        }

        @Specialization
        public boolean isBoxed(int receiver) {
            return true;
        }

        @Specialization
        public boolean isBoxed(long receiver) {
            return true;
        }

        @Specialization
        public boolean isBoxed(float receiver) {
            return true;
        }

        @Specialization
        public boolean isBoxed(double receiver) {
            return true;
        }

        @Specialization
        public boolean isBoxed(CharSequence receiver) {
            return true;
        }

        @Specialization
        public boolean isBoxed(VirtualFrame frame, TruffleObject receiver, @Cached(value="createIsBoxedNode()") Node isBoxedNode, @Cached(value="create()") BranchProfile exceptionProfile) {
            return ForeignAccess.sendIsBoxed(isBoxedNode, frame, receiver);
        }

        protected Node createIsBoxedNode() {
            return Message.IS_BOXED.createNode();
        }

        @Fallback
        public boolean isBoxed(Object receiver) {
            return false;
        }
    }

    @CoreMethod(names={"size"}, isModuleFunction=true, needsSelf=false, required=1)
    public static abstract class SizeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public Object size(String receiver) {
            return receiver.length();
        }

        @Specialization
        public Object size(VirtualFrame frame, TruffleObject receiver, @Cached(value="createGetSizeNode()") Node getSizeNode, @Cached(value="create()") BranchProfile exceptionProfile) {
            try {
                return ForeignAccess.sendGetSize(getSizeNode, frame, receiver);
            }
            catch (UnsupportedMessageException e) {
                exceptionProfile.enter();
                throw new RuntimeException(e);
            }
        }

        protected Node createGetSizeNode() {
            return Message.GET_SIZE.createNode();
        }
    }

    @CoreMethod(names={"size?"}, isModuleFunction=true, needsSelf=false, required=1)
    public static abstract class HasSizeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public boolean hasSize(VirtualFrame frame, TruffleObject receiver, @Cached(value="createHasSizeNode()") Node hasSizeNode) {
            return ForeignAccess.sendHasSize(hasSizeNode, frame, receiver);
        }

        protected Node createHasSizeNode() {
            return Message.HAS_SIZE.createNode();
        }
    }

    @CoreMethod(names={"invoke"}, isModuleFunction=true, needsSelf=false, required=2, rest=true)
    public static abstract class InvokeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isRubyString(identifier) || isRubySymbol(identifier)", "args.length == cachedArgsLength"}, limit="getCacheLimit()")
        public Object invokeCached(VirtualFrame frame, TruffleObject receiver, DynamicObject identifier, Object[] args, @Cached(value="args.length") int cachedArgsLength, @Cached(value="createInvokeNode(cachedArgsLength)") Node invokeNode, @Cached(value="create()") ToJavaStringNode toJavaStringNode, @Cached(value="create()") BranchProfile exceptionProfile) {
            try {
                return ForeignAccess.sendInvoke(invokeNode, frame, receiver, toJavaStringNode.executeToJavaString(identifier), args);
            }
            catch (ArityException | UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException e) {
                exceptionProfile.enter();
                throw new RuntimeException(e);
            }
        }

        @Specialization(guards={"isRubyString(identifier) || isRubySymbol(identifier)"}, contains={"invokeCached"})
        public Object invokeUncached(VirtualFrame frame, TruffleObject receiver, DynamicObject identifier, Object[] args) {
            CompilerDirectives.bailout("can't compile megamorphic interop INVOKE message sends");
            Node invokeNode = this.createInvokeNode(args.length);
            try {
                return ForeignAccess.sendInvoke(invokeNode, frame, receiver, identifier.toString(), args);
            }
            catch (ArityException | UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw new RuntimeException(e);
            }
        }

        protected Node createInvokeNode(int argsLength) {
            return Message.createInvoke(argsLength).createNode();
        }

        protected int getCacheLimit() {
            return this.getContext().getOptions().INTEROP_INVOKE_CACHE;
        }
    }

    @CoreMethod(names={"execute"}, isModuleFunction=true, needsSelf=false, required=1, rest=true)
    public static abstract class ExecuteNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"args.length == cachedArgsLength"}, limit="getCacheLimit()")
        public Object executeForeignCached(VirtualFrame frame, TruffleObject receiver, Object[] args, @Cached(value="args.length") int cachedArgsLength, @Cached(value="createExecuteNode(cachedArgsLength)") Node executeNode, @Cached(value="create()") BranchProfile exceptionProfile) {
            try {
                return ForeignAccess.sendExecute(executeNode, frame, receiver, args);
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                exceptionProfile.enter();
                throw new RuntimeException(e);
            }
        }

        @Specialization(contains={"executeForeignCached"})
        public Object executeForeignUncached(VirtualFrame frame, TruffleObject receiver, Object[] args) {
            CompilerDirectives.bailout("can't compile megamorphic interop EXECUTE message sends");
            Node executeNode = this.createExecuteNode(args.length);
            try {
                return ForeignAccess.sendExecute(executeNode, frame, receiver, args);
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw new RuntimeException(e);
            }
        }

        protected Node createExecuteNode(int argsLength) {
            return Message.createExecute(argsLength).createNode();
        }

        protected int getCacheLimit() {
            return this.getContext().getOptions().INTEROP_EXECUTE_CACHE;
        }
    }

    @CoreMethod(names={"executable?"}, isModuleFunction=true, needsSelf=false, required=1)
    public static abstract class IsExecutableNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public boolean isExecutable(VirtualFrame frame, TruffleObject receiver, @Cached(value="createIsExecutableNode()") Node isExecutableNode) {
            return ForeignAccess.sendIsExecutable(isExecutableNode, frame, receiver);
        }

        protected Node createIsExecutableNode() {
            return Message.IS_EXECUTABLE.createNode();
        }
    }
}

