/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.write.bytes;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.format.FormatNode;

@NodeChildren(value={@NodeChild(value="value", type=FormatNode.class)})
public abstract class WritePaddedBytesNode
extends FormatNode {
    private final ConditionProfile leftJustifiedProfile = ConditionProfile.createBinaryProfile();
    private final int padding;
    private final boolean leftJustified;

    public WritePaddedBytesNode(RubyContext context, int padding, boolean leftJustified) {
        super(context);
        this.padding = padding;
        this.leftJustified = leftJustified;
    }

    @Specialization
    public Object write(VirtualFrame frame, byte[] bytes) {
        if (this.leftJustifiedProfile.profile(this.leftJustified)) {
            return this.writeLeftJustified(frame, bytes);
        }
        return this.writeRightJustified(frame, bytes);
    }

    private Object writeLeftJustified(VirtualFrame frame, byte[] bytes) {
        this.writeBytes(frame, bytes);
        for (int n = 0; n < this.padding - bytes.length; ++n) {
            this.writeByte(frame, (byte)32);
        }
        return null;
    }

    private Object writeRightJustified(VirtualFrame frame, byte[] bytes) {
        for (int n = 0; n < this.padding - bytes.length; ++n) {
            this.writeByte(frame, (byte)32);
        }
        this.writeBytes(frame, bytes);
        return null;
    }
}

