/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.anno;

import java.util.List;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.anno.JavaMethodDescriptor;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.MethodFactory;
import org.jruby.runtime.Visibility;

public abstract class TypePopulator {
    public static final TypePopulator DEFAULT = new DefaultTypePopulator();

    public static void populateMethod(JavaMethod javaMethod, int arity2, String simpleName, boolean isStatic, boolean notImplemented) {
        javaMethod.setIsBuiltin(true);
        javaMethod.setArity(Arity.createArity(arity2));
        javaMethod.setJavaName(simpleName);
        javaMethod.setSingleton(isStatic);
        javaMethod.setNotImplemented(notImplemented);
    }

    public static void populateMethod(JavaMethod javaMethod, int arity2, String simpleName, boolean isStatic, boolean notImplemented, Class nativeTarget, String nativeName, Class nativeReturn, Class[] nativeArguments) {
        javaMethod.setIsBuiltin(true);
        javaMethod.setArity(Arity.createArity(arity2));
        javaMethod.setJavaName(simpleName);
        javaMethod.setSingleton(isStatic);
        javaMethod.setNotImplemented(notImplemented);
        javaMethod.setNativeCall(nativeTarget, nativeName, nativeReturn, nativeArguments, isStatic, false);
    }

    public static DynamicMethod populateModuleMethod(RubyModule cls, DynamicMethod javaMethod) {
        DynamicMethod moduleMethod = javaMethod.dup();
        moduleMethod.setImplementationClass(cls.getSingletonClass());
        moduleMethod.setVisibility(Visibility.PUBLIC);
        return moduleMethod;
    }

    public abstract void populate(RubyModule var1, Class var2);

    public static final class ReflectiveTypePopulator
    extends TypePopulator {
        private final Class clazz;
        private final RubyModule.MethodClumper clumper;

        public ReflectiveTypePopulator(Class clazz) {
            this.clazz = clazz;
            this.clumper = new RubyModule.MethodClumper();
            this.clumper.clump(clazz);
        }

        @Override
        public void populate(RubyModule clsmod, Class clazz) {
            JavaMethodDescriptor desc;
            int i2;
            List<JavaMethodDescriptor> methods2;
            String name2;
            assert (clazz == this.clazz) : "populator for " + this.clazz + " used for " + clazz;
            Ruby runtime = clsmod.getRuntime();
            MethodFactory methodFactory = MethodFactory.createFactory(runtime.getJRubyClassLoader());
            for (Map.Entry<String, List<JavaMethodDescriptor>> entry : this.clumper.getStaticAnnotatedMethods().entrySet()) {
                name2 = entry.getKey();
                methods2 = entry.getValue();
                clsmod.defineAnnotatedMethod(name2, methods2, methodFactory);
                for (i2 = 0; i2 < methods2.size(); ++i2) {
                    desc = methods2.get(i2);
                    if (desc.anno.omit()) continue;
                    runtime.addBoundMethod(desc.declaringClassName, desc.name, name2);
                }
            }
            for (Map.Entry<String, List<JavaMethodDescriptor>> entry : this.clumper.getAnnotatedMethods().entrySet()) {
                name2 = entry.getKey();
                methods2 = entry.getValue();
                clsmod.defineAnnotatedMethod(name2, methods2, methodFactory);
                for (i2 = 0; i2 < methods2.size(); ++i2) {
                    desc = methods2.get(i2);
                    if (desc.anno.omit()) continue;
                    runtime.addBoundMethod(desc.declaringClassName, desc.name, name2);
                }
            }
        }
    }

    public static class DefaultTypePopulator
    extends TypePopulator {
        @Override
        public void populate(RubyModule clsmod, Class clazz) {
            ReflectiveTypePopulator populator = new ReflectiveTypePopulator(clazz);
            populator.populate(clsmod, clazz);
        }
    }
}

