/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.gui.layer.AbstractTileSourceLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.io.FileExporter;
import org.openstreetmap.josm.io.WMSLayerImporter;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class WMSLayerExporter
extends FileExporter {
    public static final int CURRENT_FILE_VERSION = 6;

    public WMSLayerExporter() {
        super(WMSLayerImporter.FILE_FILTER);
    }

    @Override
    public void exportData(File file, Layer layer) throws IOException {
        CheckParameterUtil.ensureParameterNotNull(file, "file");
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
        if (layer instanceof AbstractTileSourceLayer) {
            try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));){
                objectOutputStream.writeInt(6);
                objectOutputStream.writeObject(Main.map.mapView.getCenter());
                ImageryInfo.ImageryPreferenceEntry imageryPreferenceEntry = new ImageryInfo.ImageryPreferenceEntry(((AbstractTileSourceLayer)layer).getInfo());
                objectOutputStream.writeObject(Preferences.serializeStruct(imageryPreferenceEntry, ImageryInfo.ImageryPreferenceEntry.class));
            }
        }
    }

    @Override
    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent activeLayerChangeEvent) {
        this.setEnabled(activeLayerChangeEvent.getSource().getActiveLayer() instanceof AbstractTileSourceLayer);
    }
}

