/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.imagery;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.openstreetmap.josm.data.cache.JCSCacheManager;
import org.openstreetmap.josm.data.imagery.CachedTileLoaderFactory;
import org.openstreetmap.josm.gui.layer.AbstractCachedTileSourceLayer;
import org.openstreetmap.josm.gui.layer.AbstractTileSourceLayer;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class CommonSettingsPanel
extends JPanel {
    private final JButton btnFadeColor;
    private final JSlider fadeAmount = new JSlider(0, 100);
    private final JosmComboBox<String> sharpen;
    private final JosmTextField tilecacheDir = new JosmTextField();
    private final JSpinner maxElementsOnDisk;
    private final JSlider tilesZoom = new JSlider(-2, 2, 0);

    public CommonSettingsPanel() {
        super(new GridBagLayout());
        this.maxElementsOnDisk = new JSpinner(new SpinnerNumberModel(AbstractCachedTileSourceLayer.MAX_DISK_CACHE_SIZE.get(), 0, Integer.MAX_VALUE, 1));
        this.btnFadeColor = new JButton();
        this.btnFadeColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JColorChooser jColorChooser = new JColorChooser(CommonSettingsPanel.this.btnFadeColor.getBackground());
                int n = JOptionPane.showConfirmDialog(CommonSettingsPanel.this, jColorChooser, I18n.tr("Choose a color for {0}", I18n.tr("imagery fade", new Object[0])), 2, -1);
                if (n == 0) {
                    Color color = jColorChooser.getColor();
                    CommonSettingsPanel.this.btnFadeColor.setBackground(color);
                    CommonSettingsPanel.this.btnFadeColor.setText(ColorHelper.color2html(color));
                }
            }
        });
        this.add((Component)new JLabel(I18n.tr("Fade Color: ", new Object[0])), GBC.std());
        this.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.add((Component)this.btnFadeColor, GBC.eol().fill(2));
        this.add((Component)new JLabel(I18n.tr("Fade amount: ", new Object[0])), GBC.std());
        this.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.add((Component)this.fadeAmount, GBC.eol().fill(2));
        this.sharpen = new JosmComboBox<String>(new String[]{I18n.tr("None", new Object[0]), I18n.tr("Soft", new Object[0]), I18n.tr("Strong", new Object[0])});
        this.add(new JLabel(I18n.tr("Sharpen (requires layer re-add): ", new Object[0])));
        this.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.add(this.sharpen, GBC.eol().fill(2));
        this.add((Component)new JLabel(I18n.tr("Tile cache directory: ", new Object[0])), GBC.std());
        this.add(GBC.glue(5, 0), GBC.std());
        this.add((Component)this.tilecacheDir, GBC.eol().fill(2));
        this.add((Component)new JLabel(I18n.tr("Maximum size of disk cache (per imagery) in MB: ", new Object[0])), GBC.std());
        this.add(GBC.glue(5, 0), GBC.std());
        this.add((Component)this.maxElementsOnDisk, GBC.eol());
        this.tilesZoom.setPaintLabels(true);
        this.tilesZoom.setMajorTickSpacing(2);
        this.tilesZoom.setMinorTickSpacing(1);
        this.tilesZoom.setPaintTicks(true);
        this.add(new JLabel(I18n.tr("Tiles zoom offset:", new Object[0])));
        this.add(GBC.glue(5, 0), GBC.std());
        this.add((Component)this.tilesZoom, GBC.eol());
    }

    public void loadSettings() {
        Color color = ImageryLayer.PROP_FADE_COLOR.get();
        this.btnFadeColor.setBackground(color);
        this.btnFadeColor.setText(ColorHelper.color2html(color));
        this.fadeAmount.setValue(ImageryLayer.PROP_FADE_AMOUNT.get());
        this.sharpen.setSelectedIndex(Math.max(0, Math.min(2, ImageryLayer.PROP_SHARPEN_LEVEL.get())));
        this.tilecacheDir.setText(CachedTileLoaderFactory.PROP_TILECACHE_DIR.get());
        this.maxElementsOnDisk.setValue(AbstractCachedTileSourceLayer.MAX_DISK_CACHE_SIZE.get());
        this.tilesZoom.setValue(AbstractTileSourceLayer.ZOOM_OFFSET.get());
    }

    public boolean saveSettings() {
        ImageryLayer.PROP_FADE_AMOUNT.put(this.fadeAmount.getValue());
        ImageryLayer.PROP_FADE_COLOR.put(this.btnFadeColor.getBackground());
        ImageryLayer.PROP_SHARPEN_LEVEL.put(this.sharpen.getSelectedIndex());
        boolean bl = false;
        if (!AbstractCachedTileSourceLayer.MAX_DISK_CACHE_SIZE.get().equals(this.maxElementsOnDisk.getValue())) {
            if ((Integer)this.maxElementsOnDisk.getValue() < AbstractCachedTileSourceLayer.MAX_DISK_CACHE_SIZE.get() && JCSCacheManager.USE_BLOCK_CACHE.get().booleanValue()) {
                this.removeCacheFiles(CachedTileLoaderFactory.PROP_TILECACHE_DIR.get());
            }
            AbstractCachedTileSourceLayer.MAX_DISK_CACHE_SIZE.put((Integer)this.maxElementsOnDisk.getValue());
            bl = true;
        }
        if (!CachedTileLoaderFactory.PROP_TILECACHE_DIR.get().equals(this.tilecacheDir.getText())) {
            bl = true;
            this.removeCacheFiles(CachedTileLoaderFactory.PROP_TILECACHE_DIR.get());
            CachedTileLoaderFactory.PROP_TILECACHE_DIR.put(this.tilecacheDir.getText());
        }
        if (!AbstractTileSourceLayer.ZOOM_OFFSET.get().equals(this.tilesZoom.getValue())) {
            AbstractTileSourceLayer.ZOOM_OFFSET.put(this.tilesZoom.getValue());
            bl = true;
        }
        return bl;
    }

    private void removeCacheFiles(String string) {
        File file = new File(string);
        File[] fileArray = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(".data") || string.endsWith(".key");
            }
        });
        JCSCacheManager.shutdown();
        for (File file2 : fileArray) {
            Utils.deleteFile(file2);
        }
    }
}

