/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.SelectByInternalPointAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.layer.AbstractMapViewPaintable;
import org.openstreetmap.josm.tools.Utils;

public class SelectionManager
implements MouseListener,
MouseMotionListener,
PropertyChangeListener {
    private final SelectionEnded selectionEndedListener;
    private Point mousePosStart;
    private Point mousePos;
    private final NavigatableComponent nc;
    private final boolean aspectRatio;
    private boolean lassoMode;
    private final Polygon lasso = new Polygon();
    private Polygon selectionResult = new Polygon();
    private final SelectionHintLayer selectionHintLayer = new SelectionHintLayer();

    public SelectionManager(SelectionEnded selectionEnded, boolean bl, NavigatableComponent navigatableComponent) {
        this.selectionEndedListener = selectionEnded;
        this.aspectRatio = bl;
        this.nc = navigatableComponent;
    }

    public void register(MapView mapView, boolean bl) {
        this.lassoMode = bl;
        mapView.addMouseListener(this);
        mapView.addMouseMotionListener(this);
        this.selectionEndedListener.addPropertyChangeListener(this);
        mapView.addPropertyChangeListener("scale", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SelectionManager.this.abortSelecting();
            }
        });
        mapView.addTemporaryLayer(this.selectionHintLayer);
    }

    public void unregister(MapView mapView) {
        this.abortSelecting();
        mapView.removeTemporaryLayer(this.selectionHintLayer);
        mapView.removeMouseListener(this);
        mapView.removeMouseMotionListener(this);
        this.selectionEndedListener.removePropertyChangeListener(this);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() > 1 && Main.getLayerManager().getEditDataSet() != null) {
            SelectByInternalPointAction.performSelection(Main.map.mapView.getEastNorth(mouseEvent.getX(), mouseEvent.getY()), (mouseEvent.getModifiersEx() & 0x40) != 0, (mouseEvent.getModifiersEx() & 0x80) != 0);
        } else if (mouseEvent.getButton() == 1) {
            this.mousePosStart = this.mousePos = mouseEvent.getPoint();
            this.lasso.reset();
            this.lasso.addPoint(this.mousePosStart.x, this.mousePosStart.y);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiersEx() & 0x1400;
        if (n != 0) {
            if (this.mousePosStart == null) {
                this.mousePosStart = this.mousePos = mouseEvent.getPoint();
            }
            this.selectionAreaChanged();
        }
        if (n == 1024) {
            this.mousePos = mouseEvent.getPoint();
            this.addLassoPoint(mouseEvent.getPoint());
            this.selectionAreaChanged();
        } else if (n == 5120) {
            this.moveSelection(mouseEvent.getX() - this.mousePos.x, mouseEvent.getY() - this.mousePos.y);
            this.mousePos = mouseEvent.getPoint();
            this.selectionAreaChanged();
        }
    }

    private void moveSelection(int n, int n2) {
        this.mousePosStart.x += n;
        this.mousePosStart.y += n2;
        this.lasso.translate(n, n2);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            this.endSelecting(mouseEvent);
        }
    }

    public void endSelecting(MouseEvent mouseEvent) {
        boolean bl;
        this.mousePos = mouseEvent.getPoint();
        if (this.lassoMode) {
            this.addLassoPoint(mouseEvent.getPoint());
        }
        boolean bl2 = bl = (mouseEvent.getModifiersEx() & 0x1000) != 0;
        if (!bl) {
            this.selectingDone(mouseEvent);
        }
        this.abortSelecting();
    }

    private void addLassoPoint(Point point) {
        if (this.isNoSelection()) {
            return;
        }
        this.lasso.addPoint(point.x, point.y);
    }

    private boolean isNoSelection() {
        return this.mousePos == null || this.mousePosStart == null || this.mousePos == this.mousePosStart;
    }

    private Rectangle getSelectionRectangle() {
        int n = this.mousePosStart.x;
        int n2 = this.mousePosStart.y;
        int n3 = this.mousePos.x - this.mousePosStart.x;
        int n4 = this.mousePos.y - this.mousePosStart.y;
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if (this.aspectRatio) {
            double d = (double)this.nc.getWidth() / (double)this.nc.getHeight();
            if ((double)n3 / (double)n4 < d) {
                int n5 = (int)((double)n4 * d);
                if (this.mousePos.x < this.mousePosStart.x) {
                    n += n3 - n5;
                }
                n3 = n5;
            } else {
                int n6 = (int)((double)n3 / d);
                if (this.mousePos.y < this.mousePosStart.y) {
                    n2 += n4 - n6;
                }
                n4 = n6;
            }
        }
        return new Rectangle(n, n2, n3, n4);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("active".equals(propertyChangeEvent.getPropertyName()) && !((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
            this.abortSelecting();
        }
    }

    private void selectingDone(MouseEvent mouseEvent) {
        Rectangle rectangle;
        if (this.isNoSelection()) {
            return;
        }
        if (this.lassoMode) {
            rectangle = this.lasso.getBounds();
            this.selectionResult = new Polygon(this.lasso.xpoints, this.lasso.ypoints, this.lasso.npoints);
        } else {
            rectangle = this.getSelectionRectangle();
            this.selectionResult = SelectionManager.rectToPolygon(rectangle);
        }
        this.selectionEndedListener.selectionEnded(rectangle, mouseEvent);
    }

    private void abortSelecting() {
        if (this.mousePosStart != null) {
            this.mousePosStart = null;
            this.mousePos = null;
            this.lasso.reset();
            this.selectionAreaChanged();
        }
    }

    private void selectionAreaChanged() {
        this.selectionHintLayer.invalidate();
    }

    public Collection<OsmPrimitive> getSelectedObjects(boolean bl) {
        LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
        boolean bl2 = false;
        Rectangle rectangle = this.selectionResult.getBounds();
        if (rectangle.height <= 2 && rectangle.width <= 2) {
            bl2 = true;
        }
        if (bl2) {
            Point point = new Point(this.selectionResult.xpoints[0], this.selectionResult.ypoints[0]);
            OsmPrimitive osmPrimitive = this.nc.getNearestNodeOrWay(point, OsmPrimitive.isSelectablePredicate, false);
            if (osmPrimitive != null) {
                linkedList.add(osmPrimitive);
            }
        } else {
            for (Node osmPrimitive : Main.getLayerManager().getEditDataSet().getNodes()) {
                if (!osmPrimitive.isSelectable() || !this.selectionResult.contains(this.nc.getPoint2D(osmPrimitive))) continue;
                linkedList.add(osmPrimitive);
            }
            block1: for (Way way : Main.getLayerManager().getEditDataSet().getWays()) {
                if (!way.isSelectable() || way.getNodesCount() == 0) continue;
                if (bl) {
                    for (Node node : way.getNodes()) {
                        if (node.isIncomplete() || !this.selectionResult.contains(this.nc.getPoint2D(node))) continue;
                        linkedList.add(way);
                        continue block1;
                    }
                    continue;
                }
                boolean bl3 = true;
                for (Node node : way.getNodes()) {
                    if (node.isIncomplete() || this.selectionResult.contains(this.nc.getPoint(node))) continue;
                    bl3 = false;
                    break;
                }
                if (!bl3) continue;
                linkedList.add(way);
            }
        }
        return linkedList;
    }

    private static Polygon rectToPolygon(Rectangle rectangle) {
        Polygon polygon = new Polygon();
        polygon.addPoint(rectangle.x, rectangle.y);
        polygon.addPoint(rectangle.x, rectangle.y + rectangle.height);
        polygon.addPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        polygon.addPoint(rectangle.x + rectangle.width, rectangle.y);
        return polygon;
    }

    public void setLassoMode(boolean bl) {
        this.lassoMode = bl;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private class SelectionHintLayer
    extends AbstractMapViewPaintable {
        private SelectionHintLayer() {
        }

        @Override
        public void paint(Graphics2D graphics2D, MapView mapView, Bounds bounds) {
            if (SelectionManager.this.mousePos == null || SelectionManager.this.mousePosStart == null || SelectionManager.this.mousePos == SelectionManager.this.mousePosStart) {
                return;
            }
            Color color = Utils.complement(PaintColors.getBackgroundColor());
            graphics2D.setColor(color);
            if (SelectionManager.this.lassoMode) {
                graphics2D.drawPolygon(SelectionManager.this.lasso);
                graphics2D.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha() / 8));
                graphics2D.fillPolygon(SelectionManager.this.lasso);
            } else {
                Rectangle rectangle = SelectionManager.this.getSelectionRectangle();
                graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    public static interface SelectionEnded {
        public void selectionEnded(Rectangle var1, MouseEvent var2);

        public void addPropertyChangeListener(PropertyChangeListener var1);

        public void removePropertyChangeListener(PropertyChangeListener var1);
    }
}

