/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.proj;

import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.proj.Proj;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public abstract class AbstractProj
implements Proj {
    private static final int MAXIMUM_ITERATIONS = 15;
    private static final double ITERATION_TOLERANCE = 1.0E-10;
    private static final double MLFN_TOL = 1.0E-11;
    private static final double C00 = 1.0;
    private static final double C02 = 0.25;
    private static final double C04 = 0.046875;
    private static final double C06 = 0.01953125;
    private static final double C08 = 0.01068115234375;
    private static final double C22 = 0.75;
    private static final double C44 = 0.46875;
    private static final double C46 = 0.013020833333333334;
    private static final double C48 = 0.007120768229166667;
    private static final double C66 = 0.3645833333333333;
    private static final double C68 = 0.005696614583333333;
    private static final double C88 = 0.3076171875;
    protected double en0;
    protected double en1;
    protected double en2;
    protected double en3;
    protected double en4;
    protected double e;
    protected double e2;
    protected boolean spherical;

    @Override
    public void initialize(ProjParameters projParameters) throws ProjectionConfigurationException {
        CheckParameterUtil.ensureParameterNotNull(projParameters, "params");
        CheckParameterUtil.ensureParameterNotNull(projParameters.ellps, "params.ellps");
        this.e2 = projParameters.ellps.e2;
        this.e = projParameters.ellps.e;
        this.spherical = projParameters.ellps.spherical;
        this.en0 = 1.0 - this.e2 * (0.25 + this.e2 * (0.046875 + this.e2 * (0.01953125 + this.e2 * 0.01068115234375)));
        this.en1 = this.e2 * (0.75 - this.e2 * (0.046875 + this.e2 * (0.01953125 + this.e2 * 0.01068115234375)));
        double d = this.e2 * this.e2;
        this.en2 = d * (0.46875 - this.e2 * (0.013020833333333334 + this.e2 * 0.007120768229166667));
        this.en3 = (d *= this.e2) * (0.3645833333333333 - this.e2 * 0.005696614583333333);
        this.en4 = d * this.e2 * 0.3076171875;
    }

    @Override
    public boolean isGeographic() {
        return false;
    }

    protected final double mlfn(double d, double d2, double d3) {
        d3 *= d2;
        d2 *= d2;
        return this.en0 * d - d3 * (this.en1 + d2 * (this.en2 + d2 * (this.en3 + d2 * this.en4)));
    }

    protected final double inv_mlfn(double d) {
        double d2;
        double d3 = 1.0 / (1.0 - this.e2);
        double d4 = d;
        int n = 15;
        do {
            if (--n < 0) {
                throw new IllegalStateException("Too many iterations");
            }
            double d5 = Math.sin(d4);
            d2 = 1.0 - this.e2 * d5 * d5;
            d2 = (this.mlfn(d4, d5, Math.cos(d4)) - d) * (d2 * Math.sqrt(d2)) * d3;
            d4 -= d2;
        } while (!(Math.abs(d2) < 1.0E-11));
        return d4;
    }

    final double cphi2(double d) {
        double d2 = 0.5 * this.e;
        double d3 = 1.5707963267948966 - 2.0 * Math.atan(d);
        for (int i = 0; i < 15; ++i) {
            double d4 = this.e * Math.sin(d3);
            double d5 = 1.5707963267948966 - 2.0 * Math.atan(d * Math.pow((1.0 - d4) / (1.0 + d4), d2)) - d3;
            d3 += d5;
            if (!(Math.abs(d5) <= 1.0E-10)) continue;
            return d3;
        }
        throw new IllegalStateException("no convergence for ts=" + d);
    }

    final double msfn(double d, double d2) {
        return d2 / Math.sqrt(1.0 - d * d * this.e2);
    }

    final double tsfn(double d, double d2) {
        return Math.tan(0.5 * (1.5707963267948966 - d)) / Math.pow((1.0 - (d2 *= this.e)) / (1.0 + d2), 0.5 * this.e);
    }
}

