/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Enumeration;
import sun.misc.Unsafe;

public final class Inet6Address
extends InetAddress {
    static final int INADDRSZ = 16;
    private transient int cached_scope_id;
    private final transient Inet6AddressHolder holder6;
    private static final long serialVersionUID = 6880410070516793377L;
    private static final ObjectStreamField[] serialPersistentFields;
    private static final long FIELDS_OFFSET;
    private static final Unsafe UNSAFE;
    private static final int INT16SZ = 2;

    Inet6Address() {
        this.holder.init(null, 2);
        this.holder6 = new Inet6AddressHolder();
    }

    Inet6Address(String string, byte[] byArray, int n) {
        this.holder.init(string, 2);
        this.holder6 = new Inet6AddressHolder();
        this.holder6.init(byArray, n);
    }

    Inet6Address(String string, byte[] byArray) {
        this.holder6 = new Inet6AddressHolder();
        try {
            this.initif(string, byArray, null);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    Inet6Address(String string, byte[] byArray, NetworkInterface networkInterface) throws UnknownHostException {
        this.holder6 = new Inet6AddressHolder();
        this.initif(string, byArray, networkInterface);
    }

    Inet6Address(String string, byte[] byArray, String string2) throws UnknownHostException {
        this.holder6 = new Inet6AddressHolder();
        this.initstr(string, byArray, string2);
    }

    public static Inet6Address getByAddress(String string, byte[] byArray, NetworkInterface networkInterface) throws UnknownHostException {
        if (string != null && string.length() > 0 && string.charAt(0) == '[' && string.charAt(string.length() - 1) == ']') {
            string = string.substring(1, string.length() - 1);
        }
        if (byArray != null && byArray.length == 16) {
            return new Inet6Address(string, byArray, networkInterface);
        }
        throw new UnknownHostException("addr is of illegal length");
    }

    public static Inet6Address getByAddress(String string, byte[] byArray, int n) throws UnknownHostException {
        if (string != null && string.length() > 0 && string.charAt(0) == '[' && string.charAt(string.length() - 1) == ']') {
            string = string.substring(1, string.length() - 1);
        }
        if (byArray != null && byArray.length == 16) {
            return new Inet6Address(string, byArray, n);
        }
        throw new UnknownHostException("addr is of illegal length");
    }

    private void initstr(String string, byte[] byArray, String string2) throws UnknownHostException {
        try {
            NetworkInterface networkInterface = NetworkInterface.getByName(string2);
            if (networkInterface == null) {
                throw new UnknownHostException("no such interface " + string2);
            }
            this.initif(string, byArray, networkInterface);
        }
        catch (SocketException socketException) {
            throw new UnknownHostException("SocketException thrown" + string2);
        }
    }

    private void initif(String string, byte[] byArray, NetworkInterface networkInterface) throws UnknownHostException {
        int n = -1;
        this.holder6.init(byArray, networkInterface);
        if (byArray.length == 16) {
            n = 2;
        }
        this.holder.init(string, n);
    }

    private static boolean isDifferentLocalAddressType(byte[] byArray, byte[] byArray2) {
        if (Inet6Address.isLinkLocalAddress(byArray) && !Inet6Address.isLinkLocalAddress(byArray2)) {
            return false;
        }
        return !Inet6Address.isSiteLocalAddress(byArray) || Inet6Address.isSiteLocalAddress(byArray2);
    }

    private static int deriveNumericScope(byte[] byArray, NetworkInterface networkInterface) throws UnknownHostException {
        Enumeration<InetAddress> enumeration = networkInterface.getInetAddresses();
        while (enumeration.hasMoreElements()) {
            Inet6Address inet6Address;
            InetAddress inetAddress = enumeration.nextElement();
            if (!(inetAddress instanceof Inet6Address) || !Inet6Address.isDifferentLocalAddressType(byArray, (inet6Address = (Inet6Address)inetAddress).getAddress())) continue;
            return inet6Address.getScopeId();
        }
        throw new UnknownHostException("no scope_id found");
    }

    private int deriveNumericScope(String string) throws UnknownHostException {
        Enumeration<NetworkInterface> enumeration;
        try {
            enumeration = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException socketException) {
            throw new UnknownHostException("could not enumerate local network interfaces");
        }
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            if (!networkInterface.getName().equals(string)) continue;
            return Inet6Address.deriveNumericScope(this.holder6.ipaddress, networkInterface);
        }
        throw new UnknownHostException("No matching address found for interface : " + string);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        NetworkInterface networkInterface = null;
        if (this.getClass().getClassLoader() != null) {
            throw new SecurityException("invalid address type");
        }
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        byte[] byArray = (byte[])getField.get("ipaddress", null);
        int n = getField.get("scope_id", -1);
        boolean bl = getField.get("scope_id_set", false);
        boolean bl2 = getField.get("scope_ifname_set", false);
        String string = (String)getField.get("ifname", null);
        if (string != null && !"".equals(string)) {
            try {
                networkInterface = NetworkInterface.getByName(string);
                if (networkInterface == null) {
                    bl = false;
                    bl2 = false;
                    n = 0;
                } else {
                    bl2 = true;
                    try {
                        n = Inet6Address.deriveNumericScope(byArray, networkInterface);
                    }
                    catch (UnknownHostException unknownHostException) {}
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        if ((byArray = (byte[])byArray.clone()).length != 16) {
            throw new InvalidObjectException("invalid address length: " + byArray.length);
        }
        if (this.holder.getFamily() != 2) {
            throw new InvalidObjectException("invalid address family type");
        }
        Inet6AddressHolder inet6AddressHolder = new Inet6AddressHolder(byArray, n, bl, networkInterface, bl2);
        UNSAFE.putObject((Object)this, FIELDS_OFFSET, (Object)inet6AddressHolder);
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        String string = null;
        if (this.holder6.scope_ifname != null) {
            string = this.holder6.scope_ifname.getName();
            this.holder6.scope_ifname_set = true;
        }
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("ipaddress", this.holder6.ipaddress);
        putField.put("scope_id", this.holder6.scope_id);
        putField.put("scope_id_set", this.holder6.scope_id_set);
        putField.put("scope_ifname_set", this.holder6.scope_ifname_set);
        putField.put("ifname", string);
        objectOutputStream.writeFields();
    }

    @Override
    public boolean isMulticastAddress() {
        return this.holder6.isMulticastAddress();
    }

    @Override
    public boolean isAnyLocalAddress() {
        return this.holder6.isAnyLocalAddress();
    }

    @Override
    public boolean isLoopbackAddress() {
        return this.holder6.isLoopbackAddress();
    }

    @Override
    public boolean isLinkLocalAddress() {
        return this.holder6.isLinkLocalAddress();
    }

    static boolean isLinkLocalAddress(byte[] byArray) {
        return (byArray[0] & 0xFF) == 254 && (byArray[1] & 0xC0) == 128;
    }

    @Override
    public boolean isSiteLocalAddress() {
        return this.holder6.isSiteLocalAddress();
    }

    static boolean isSiteLocalAddress(byte[] byArray) {
        return (byArray[0] & 0xFF) == 254 && (byArray[1] & 0xC0) == 192;
    }

    @Override
    public boolean isMCGlobal() {
        return this.holder6.isMCGlobal();
    }

    @Override
    public boolean isMCNodeLocal() {
        return this.holder6.isMCNodeLocal();
    }

    @Override
    public boolean isMCLinkLocal() {
        return this.holder6.isMCLinkLocal();
    }

    @Override
    public boolean isMCSiteLocal() {
        return this.holder6.isMCSiteLocal();
    }

    @Override
    public boolean isMCOrgLocal() {
        return this.holder6.isMCOrgLocal();
    }

    @Override
    public byte[] getAddress() {
        return (byte[])this.holder6.ipaddress.clone();
    }

    public int getScopeId() {
        return this.holder6.scope_id;
    }

    public NetworkInterface getScopedInterface() {
        return this.holder6.scope_ifname;
    }

    @Override
    public String getHostAddress() {
        return this.holder6.getHostAddress();
    }

    @Override
    public int hashCode() {
        return this.holder6.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof Inet6Address)) {
            return false;
        }
        Inet6Address inet6Address = (Inet6Address)object;
        return this.holder6.equals(inet6Address.holder6);
    }

    public boolean isIPv4CompatibleAddress() {
        return this.holder6.isIPv4CompatibleAddress();
    }

    static String numericToTextFormat(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(39);
        for (int i = 0; i < 8; ++i) {
            stringBuilder.append(Integer.toHexString(byArray[i << 1] << 8 & 0xFF00 | byArray[(i << 1) + 1] & 0xFF));
            if (i >= 7) continue;
            stringBuilder.append(":");
        }
        return stringBuilder.toString();
    }

    private static native void init();

    static {
        Inet6Address.init();
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("ipaddress", byte[].class), new ObjectStreamField("scope_id", Integer.TYPE), new ObjectStreamField("scope_id_set", Boolean.TYPE), new ObjectStreamField("scope_ifname_set", Boolean.TYPE), new ObjectStreamField("ifname", String.class)};
        try {
            Unsafe unsafe = Unsafe.getUnsafe();
            FIELDS_OFFSET = unsafe.objectFieldOffset(Inet6Address.class.getDeclaredField("holder6"));
            UNSAFE = unsafe;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new Error(reflectiveOperationException);
        }
    }

    private class Inet6AddressHolder {
        byte[] ipaddress;
        int scope_id;
        boolean scope_id_set;
        NetworkInterface scope_ifname;
        boolean scope_ifname_set;

        private Inet6AddressHolder() {
            this.ipaddress = new byte[16];
        }

        private Inet6AddressHolder(byte[] byArray, int n, boolean bl, NetworkInterface networkInterface, boolean bl2) {
            this.ipaddress = byArray;
            this.scope_id = n;
            this.scope_id_set = bl;
            this.scope_ifname_set = bl2;
            this.scope_ifname = networkInterface;
        }

        void setAddr(byte[] byArray) {
            if (byArray.length == 16) {
                System.arraycopy(byArray, 0, this.ipaddress, 0, 16);
            }
        }

        void init(byte[] byArray, int n) {
            this.setAddr(byArray);
            if (n >= 0) {
                this.scope_id = n;
                this.scope_id_set = true;
            }
        }

        void init(byte[] byArray, NetworkInterface networkInterface) throws UnknownHostException {
            this.setAddr(byArray);
            if (networkInterface != null) {
                this.scope_id = Inet6Address.deriveNumericScope(this.ipaddress, networkInterface);
                this.scope_id_set = true;
                this.scope_ifname = networkInterface;
                this.scope_ifname_set = true;
            }
        }

        String getHostAddress() {
            String string = Inet6Address.numericToTextFormat(this.ipaddress);
            if (this.scope_ifname != null) {
                string = string + "%" + this.scope_ifname.getName();
            } else if (this.scope_id_set) {
                string = string + "%" + this.scope_id;
            }
            return string;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Inet6AddressHolder)) {
                return false;
            }
            Inet6AddressHolder inet6AddressHolder = (Inet6AddressHolder)object;
            return Arrays.equals(this.ipaddress, inet6AddressHolder.ipaddress);
        }

        public int hashCode() {
            if (this.ipaddress != null) {
                int n = 0;
                int n2 = 0;
                while (n2 < 16) {
                    int n3 = 0;
                    for (int i = 0; i < 4 && n2 < 16; ++i, ++n2) {
                        n3 = (n3 << 8) + this.ipaddress[n2];
                    }
                    n += n3;
                }
                return n;
            }
            return 0;
        }

        boolean isIPv4CompatibleAddress() {
            return this.ipaddress[0] == 0 && this.ipaddress[1] == 0 && this.ipaddress[2] == 0 && this.ipaddress[3] == 0 && this.ipaddress[4] == 0 && this.ipaddress[5] == 0 && this.ipaddress[6] == 0 && this.ipaddress[7] == 0 && this.ipaddress[8] == 0 && this.ipaddress[9] == 0 && this.ipaddress[10] == 0 && this.ipaddress[11] == 0;
        }

        boolean isMulticastAddress() {
            return (this.ipaddress[0] & 0xFF) == 255;
        }

        boolean isAnyLocalAddress() {
            byte by = 0;
            for (int i = 0; i < 16; ++i) {
                by = (byte)(by | this.ipaddress[i]);
            }
            return by == 0;
        }

        boolean isLoopbackAddress() {
            byte by = 0;
            for (int i = 0; i < 15; ++i) {
                by = (byte)(by | this.ipaddress[i]);
            }
            return by == 0 && this.ipaddress[15] == 1;
        }

        boolean isLinkLocalAddress() {
            return (this.ipaddress[0] & 0xFF) == 254 && (this.ipaddress[1] & 0xC0) == 128;
        }

        boolean isSiteLocalAddress() {
            return (this.ipaddress[0] & 0xFF) == 254 && (this.ipaddress[1] & 0xC0) == 192;
        }

        boolean isMCGlobal() {
            return (this.ipaddress[0] & 0xFF) == 255 && (this.ipaddress[1] & 0xF) == 14;
        }

        boolean isMCNodeLocal() {
            return (this.ipaddress[0] & 0xFF) == 255 && (this.ipaddress[1] & 0xF) == 1;
        }

        boolean isMCLinkLocal() {
            return (this.ipaddress[0] & 0xFF) == 255 && (this.ipaddress[1] & 0xF) == 2;
        }

        boolean isMCSiteLocal() {
            return (this.ipaddress[0] & 0xFF) == 255 && (this.ipaddress[1] & 0xF) == 5;
        }

        boolean isMCOrgLocal() {
            return (this.ipaddress[0] & 0xFF) == 255 && (this.ipaddress[1] & 0xF) == 8;
        }
    }
}

