/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.parsers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.validation.Schema;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class SAXParser {
    protected SAXParser() {
    }

    public void parse(InputStream is, HandlerBase hb) throws SAXException, IOException {
        if (is == null) {
            throw new IllegalArgumentException("input stream is null");
        }
        this.parse(new InputSource(is), hb);
    }

    public void parse(InputStream is, HandlerBase hb, String systemId) throws SAXException, IOException {
        if (is == null) {
            throw new IllegalArgumentException("input stream is null");
        }
        InputSource source = new InputSource(is);
        source.setSystemId(systemId);
        this.parse(source, hb);
    }

    public void parse(InputStream is, DefaultHandler dh) throws SAXException, IOException {
        if (is == null) {
            throw new IllegalArgumentException("input stream is null");
        }
        this.parse(new InputSource(is), dh);
    }

    public void parse(InputStream is, DefaultHandler dh, String systemId) throws SAXException, IOException {
        if (is == null) {
            throw new IllegalArgumentException("input stream is null");
        }
        InputSource source = new InputSource(is);
        source.setSystemId(systemId);
        this.parse(source, dh);
    }

    public void parse(String uri, HandlerBase hb) throws SAXException, IOException {
        if (uri == null) {
            throw new IllegalArgumentException("URI is null");
        }
        this.parse(new InputSource(uri), hb);
    }

    public void parse(String uri, DefaultHandler dh) throws SAXException, IOException {
        if (uri == null) {
            throw new IllegalArgumentException("URI is null");
        }
        this.parse(new InputSource(uri), dh);
    }

    public void parse(File f, HandlerBase hb) throws SAXException, IOException {
        if (f == null) {
            throw new IllegalArgumentException("file is null");
        }
        InputSource source = new InputSource(new FileInputStream(f));
        source.setSystemId(f.toURL().toString());
        this.parse(source, hb);
    }

    public void parse(File f, DefaultHandler dh) throws SAXException, IOException {
        if (f == null) {
            throw new IllegalArgumentException("file is null");
        }
        InputSource source = new InputSource(new FileInputStream(f));
        source.setSystemId(f.toURL().toString());
        this.parse(source, dh);
    }

    public void parse(InputSource is, HandlerBase hb) throws SAXException, IOException {
        if (is == null) {
            throw new IllegalArgumentException("input source is null");
        }
        Parser parser = this.getParser();
        parser.setDocumentHandler(hb);
        parser.setDTDHandler(hb);
        parser.setEntityResolver(hb);
        parser.setErrorHandler(hb);
        parser.parse(is);
    }

    public void parse(InputSource is, DefaultHandler dh) throws SAXException, IOException {
        if (is == null) {
            throw new IllegalArgumentException("input source is null");
        }
        XMLReader reader = this.getXMLReader();
        reader.setContentHandler(dh);
        reader.setDTDHandler(dh);
        reader.setEntityResolver(dh);
        reader.setErrorHandler(dh);
        reader.parse(is);
    }

    public abstract Parser getParser() throws SAXException;

    public abstract XMLReader getXMLReader() throws SAXException;

    public abstract boolean isNamespaceAware();

    public abstract boolean isValidating();

    public abstract void setProperty(String var1, Object var2) throws SAXNotRecognizedException, SAXNotSupportedException;

    public abstract Object getProperty(String var1) throws SAXNotRecognizedException, SAXNotSupportedException;

    public void reset() {
    }

    public Schema getSchema() {
        return null;
    }

    public boolean isXIncludeAware() {
        return false;
    }
}

