/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote;

import java.io.Serializable;
import javax.management.remote.TargetedNotification;

public class NotificationResult
implements Serializable {
    private static final long serialVersionUID = 1191800228721395279L;
    private long earliestSequenceNumber;
    private long nextSequenceNumber;
    private TargetedNotification[] targetedNotifications;

    public NotificationResult(long startSeqNumber, long nextSeqNumber, TargetedNotification[] notifications) {
        if (startSeqNumber < 0L) {
            throw new IllegalArgumentException("Starting sequence number is less than 0.");
        }
        if (nextSeqNumber < 0L) {
            throw new IllegalArgumentException("Next sequence number is less than 0.");
        }
        if (notifications == null) {
            throw new IllegalArgumentException("The array of notifications is null.");
        }
        this.earliestSequenceNumber = startSeqNumber;
        this.nextSequenceNumber = nextSeqNumber;
        this.targetedNotifications = notifications;
    }

    public long getEarliestSequenceNumber() {
        return this.earliestSequenceNumber;
    }

    public long getNextSequenceNumber() {
        return this.nextSequenceNumber;
    }

    public TargetedNotification[] getTargetedNotifications() {
        return this.targetedNotifications;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[earliestSequenceNumber=" + this.earliestSequenceNumber + ",nextSequenceNumber=" + this.nextSequenceNumber + ",targetedNotifications=" + this.targetedNotifications + "]";
    }
}

