/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.sasl.srp;

import gnu.javax.crypto.assembly.Assembly;
import gnu.javax.crypto.assembly.Cascade;
import gnu.javax.crypto.assembly.Direction;
import gnu.javax.crypto.assembly.Stage;
import gnu.javax.crypto.assembly.Transformer;
import gnu.javax.crypto.assembly.TransformerException;
import gnu.javax.crypto.cipher.CipherFactory;
import gnu.javax.crypto.cipher.IBlockCipher;
import gnu.javax.crypto.mode.IMode;
import gnu.javax.crypto.mode.ModeFactory;
import gnu.javax.crypto.pad.IPad;
import gnu.javax.crypto.pad.PadFactory;
import gnu.javax.crypto.sasl.ConfidentialityException;
import gnu.javax.crypto.sasl.srp.KDF;
import java.util.HashMap;
import javax.security.sasl.SaslException;

public final class CALG {
    private Assembly assembly;
    private Object modeNdx;
    private int blockSize;
    private int keySize;

    private CALG(int blockSize, int keySize, Object modeNdx, Assembly assembly) {
        this.blockSize = blockSize;
        this.keySize = keySize;
        this.modeNdx = modeNdx;
        this.assembly = assembly;
    }

    static synchronized CALG getInstance(String algorithm) {
        IBlockCipher cipher = CipherFactory.getInstance(algorithm);
        int blockSize = cipher.defaultBlockSize();
        int keySize = cipher.defaultKeySize();
        Cascade ofbCipher = new Cascade();
        IMode ofbMode = ModeFactory.getInstance("ofb", cipher, blockSize);
        Stage modeStage = Stage.getInstance(ofbMode, Direction.FORWARD);
        Object modeNdx = ofbCipher.append(modeStage);
        IPad pkcs7 = PadFactory.getInstance("pkcs7");
        Assembly asm = new Assembly();
        asm.addPreTransformer(Transformer.getCascadeTransformer(ofbCipher));
        asm.addPreTransformer(Transformer.getPaddingTransformer(pkcs7));
        return new CALG(blockSize, keySize, modeNdx, asm);
    }

    public void init(KDF kdf, byte[] iv, Direction dir) throws SaslException {
        byte[] realIV;
        if (iv.length == this.blockSize) {
            realIV = iv;
        } else {
            realIV = new byte[this.blockSize];
            if (iv.length > this.blockSize) {
                System.arraycopy(iv, 0, realIV, 0, this.blockSize);
            } else {
                System.arraycopy(iv, 0, realIV, 0, iv.length);
            }
        }
        HashMap<String, byte[]> modeAttributes = new HashMap<String, byte[]>();
        byte[] sk = kdf.derive(this.keySize);
        modeAttributes.put("gnu.crypto.cipher.key.material", sk);
        modeAttributes.put("gnu.crypto.mode.iv", realIV);
        HashMap<Object, Object> attributes = new HashMap<Object, Object>();
        attributes.put("gnu.crypto.assembly.assembly.direction", dir);
        attributes.put(this.modeNdx, modeAttributes);
        try {
            this.assembly.init(attributes);
        }
        catch (TransformerException x) {
            throw new SaslException("getInstance()", x);
        }
    }

    public byte[] doFinal(byte[] data) throws ConfidentialityException {
        return this.doFinal(data, 0, data.length);
    }

    public byte[] doFinal(byte[] data, int offset, int length) throws ConfidentialityException {
        byte[] result;
        try {
            result = this.assembly.lastUpdate(data, offset, length);
        }
        catch (TransformerException x) {
            throw new ConfidentialityException("doFinal()", x);
        }
        return result;
    }
}

