/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.key.rsa;

import gnu.java.lang.CPStringBuilder;
import gnu.java.security.action.GetPropertyAction;
import gnu.java.security.util.FormatUtil;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.Key;
import java.security.interfaces.RSAKey;

public abstract class GnuRSAKey
implements Key,
RSAKey {
    private final BigInteger n;
    private final BigInteger e;
    protected final int defaultFormat;
    private transient String str;

    protected GnuRSAKey(int defaultFormat, BigInteger n, BigInteger e) {
        this.defaultFormat = defaultFormat <= 0 ? 1 : defaultFormat;
        this.n = n;
        this.e = e;
    }

    public BigInteger getModulus() {
        return this.getN();
    }

    public String getAlgorithm() {
        return "rsa";
    }

    public byte[] getEncoded() {
        return this.getEncoded(this.defaultFormat);
    }

    public String getFormat() {
        return FormatUtil.getEncodingShortName(this.defaultFormat);
    }

    public BigInteger getN() {
        return this.n;
    }

    public BigInteger getPublicExponent() {
        return this.getE();
    }

    public BigInteger getE() {
        return this.e;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RSAKey)) {
            return false;
        }
        RSAKey that = (RSAKey)obj;
        return this.n.equals(that.getModulus());
    }

    public String toString() {
        if (this.str == null) {
            String ls = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
            this.str = new CPStringBuilder(ls).append("defaultFormat=").append(this.defaultFormat).append(",").append(ls).append("n=0x").append(this.n.toString(16)).append(",").append(ls).append("e=0x").append(this.e.toString(16)).toString();
        }
        return this.str;
    }

    public abstract byte[] getEncoded(int var1);
}

