/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.nio.VMChannel;
import gnu.java.nio.VMPipe;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Pipe;
import java.nio.channels.spi.SelectorProvider;

class PipeImpl
extends Pipe {
    private SinkChannelImpl sink;
    private SourceChannelImpl source;

    public PipeImpl(SelectorProvider provider) throws IOException {
        VMPipe.init(this, provider);
    }

    public Pipe.SinkChannel sink() {
        return this.sink;
    }

    public Pipe.SourceChannel source() {
        return this.source;
    }

    public static final class SinkChannelImpl
    extends Pipe.SinkChannel {
        private int native_fd;
        private VMChannel vmch;

        public SinkChannelImpl(SelectorProvider selectorProvider, int native_fd) {
            super(selectorProvider);
            this.native_fd = native_fd;
            this.vmch = VMChannel.getVMChannel(this);
        }

        protected final void implCloseSelectableChannel() throws IOException {
            throw new Error("Not implemented");
        }

        protected final void implConfigureBlocking(boolean blocking) throws IOException {
            this.vmch.setBlocking(blocking);
        }

        public final int write(ByteBuffer dst) throws IOException {
            return this.vmch.write(dst);
        }

        public final long write(ByteBuffer[] srcs) throws IOException {
            return this.vmch.writeGathering(srcs, 0, srcs.length);
        }

        public final synchronized long write(ByteBuffer[] srcs, int offset, int len) throws IOException {
            if (offset < 0 || offset > srcs.length || len < 0 || len > srcs.length - offset) {
                throw new IndexOutOfBoundsException();
            }
            return this.vmch.writeGathering(srcs, offset, len);
        }

        public final int getNativeFD() {
            return this.native_fd;
        }
    }

    public static final class SourceChannelImpl
    extends Pipe.SourceChannel {
        private int native_fd;
        private VMChannel vmch;

        public SourceChannelImpl(SelectorProvider selectorProvider, int native_fd) {
            super(selectorProvider);
            this.native_fd = native_fd;
            this.vmch = VMChannel.getVMChannel(this);
        }

        protected final void implCloseSelectableChannel() throws IOException {
            throw new Error("Not implemented");
        }

        protected void implConfigureBlocking(boolean blocking) throws IOException {
            this.vmch.setBlocking(blocking);
        }

        public final int read(ByteBuffer src) throws IOException {
            return this.vmch.read(src);
        }

        public final long read(ByteBuffer[] srcs) throws IOException {
            return this.vmch.readScattering(srcs, 0, srcs.length);
        }

        public final synchronized long read(ByteBuffer[] srcs, int offset, int len) throws IOException {
            if (offset < 0 || offset > srcs.length || len < 0 || len > srcs.length - offset) {
                throw new IndexOutOfBoundsException();
            }
            return this.vmch.readScattering(srcs, offset, len);
        }

        public final int getNativeFD() {
            return this.native_fd;
        }
    }
}

