/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.font.opentype;

import gnu.java.awt.font.FontDelegate;
import gnu.java.awt.font.opentype.MacResourceFork;
import gnu.java.awt.font.opentype.OpenTypeFont;
import java.awt.FontFormatException;
import java.nio.ByteBuffer;

public final class OpenTypeFontFactory {
    private OpenTypeFontFactory() {
    }

    public static FontDelegate[] createFonts(ByteBuffer buf) throws FontFormatException {
        int version = buf.getInt(0);
        switch (version) {
            case 65536: 
            case 0x4F54544F: 
            case 1936092788: 
            case 1953658213: 
            case 1954115633: {
                return new OpenTypeFont[]{new OpenTypeFont(buf, 0)};
            }
        }
        if (version == 1953784678) {
            FontDelegate[] fonts = new OpenTypeFont[buf.getInt(8)];
            int i = 0;
            while (i < fonts.length) {
                fonts[i] = new OpenTypeFont(buf, buf.getInt(16 + 4 * i));
                ++i;
            }
            return fonts;
        }
        try {
            MacResourceFork fork = new MacResourceFork(buf);
            MacResourceFork.Resource[] rsrc = fork.getResources(1936092788);
            FontDelegate[] fonts = new OpenTypeFont[rsrc.length];
            int i = 0;
            while (i < fonts.length) {
                fonts[i] = new OpenTypeFont(rsrc[i].getContent(), 0);
                ++i;
            }
            return fonts;
        }
        catch (Exception exception) {
            throw new FontFormatException("not in OpenType or TrueType format");
        }
    }
}

