/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp;

import gnu.classpath.jdwp.exception.InvalidClassException;
import gnu.classpath.jdwp.exception.InvalidObjectException;
import gnu.classpath.jdwp.id.ArrayId;
import gnu.classpath.jdwp.id.ArrayReferenceTypeId;
import gnu.classpath.jdwp.id.ClassLoaderId;
import gnu.classpath.jdwp.id.ClassObjectId;
import gnu.classpath.jdwp.id.ClassReferenceTypeId;
import gnu.classpath.jdwp.id.InterfaceReferenceTypeId;
import gnu.classpath.jdwp.id.NullObjectId;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.id.ReferenceTypeId;
import gnu.classpath.jdwp.id.StringId;
import gnu.classpath.jdwp.id.ThreadGroupId;
import gnu.classpath.jdwp.id.ThreadId;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Hashtable;

public class VMIdManager {
    private static VMIdManager _idm = new VMIdManager();
    private ReferenceQueue _refQueue = new ReferenceQueue();
    private Hashtable _oidTable = new Hashtable(50);
    private Hashtable _idTable = new Hashtable(50);
    private Hashtable _classTable = new Hashtable(20);
    private Hashtable _ridTable = new Hashtable(20);

    public static VMIdManager getDefault() {
        return _idm;
    }

    private VMIdManager() {
    }

    private void _update() {
        Reference ref;
        while ((ref = this._refQueue.poll()) != null) {
            ObjectId id = (ObjectId)this._oidTable.get(ref);
            this._oidTable.remove(ref);
            this._idTable.remove(new Long(id.getId()));
        }
    }

    public ObjectId getObjectId(Object theObject) {
        if (theObject == null) {
            return new NullObjectId();
        }
        ReferenceKey ref = new ReferenceKey(theObject, this._refQueue);
        ObjectId id = (ObjectId)this._oidTable.get(ref);
        if (id == null) {
            this._update();
            id = IdFactory.newObjectId(ref);
            this._oidTable.put(ref, id);
            this._idTable.put(new Long(id.getId()), id);
        }
        return id;
    }

    public ObjectId get(long id) throws InvalidObjectException {
        if (id == 0L) {
            return new NullObjectId();
        }
        ObjectId oid = (ObjectId)this._idTable.get(new Long(id));
        if (oid == null) {
            throw new InvalidObjectException(id);
        }
        return oid;
    }

    public ObjectId readObjectId(ByteBuffer bb) throws InvalidObjectException {
        long id = bb.getLong();
        return this.get(id);
    }

    public ReferenceTypeId getReferenceTypeId(Class clazz) {
        ReferenceKey ref = new ReferenceKey(clazz);
        ReferenceTypeId id = (ReferenceTypeId)this._classTable.get(ref);
        if (id == null) {
            id = IdFactory.newReferenceTypeId(ref);
            this._classTable.put(ref, id);
            this._ridTable.put(new Long(id.getId()), id);
        }
        return id;
    }

    public ReferenceTypeId getReferenceType(long id) throws InvalidClassException {
        ReferenceTypeId rid = (ReferenceTypeId)this._ridTable.get(new Long(id));
        if (rid == null) {
            throw new InvalidClassException(id);
        }
        return rid;
    }

    public ReferenceTypeId readReferenceTypeId(ByteBuffer bb) throws InvalidClassException {
        long id = bb.getLong();
        return this.getReferenceType(id);
    }

    private static class IdFactory {
        private static Object _idLock = new Object();
        private static Object _ridLock = new Object();
        private static long _lastId = 0L;
        private static long _lastRid = 0L;
        private static HashMap _idList = new HashMap();

        static {
            _idList.put(ClassLoaderId.typeClass, ClassLoaderId.class);
            _idList.put(ClassObjectId.typeClass, ClassObjectId.class);
            _idList.put(StringId.typeClass, StringId.class);
            _idList.put(ThreadId.typeClass, ThreadId.class);
            _idList.put(ThreadGroupId.typeClass, ThreadGroupId.class);
        }

        private IdFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ObjectId newObjectId(SoftReference obj) {
            ObjectId id = null;
            Object object = obj.get();
            if (object.getClass().isArray()) {
                id = new ArrayId();
            } else {
                Class<? extends Object> myClass = object.getClass();
                while (myClass != null) {
                    Class clz = (Class)_idList.get(myClass);
                    if (clz != null) {
                        try {
                            id = (ObjectId)clz.newInstance();
                            Object object2 = _idLock;
                            synchronized (object2) {
                                id.setId(++_lastId);
                            }
                            id.setReference(obj);
                            return id;
                        }
                        catch (InstantiationException ie) {
                            throw new RuntimeException("cannot create new ID", ie);
                        }
                        catch (IllegalAccessException iae) {
                            throw new RuntimeException("illegal access of ID", iae);
                        }
                    }
                    myClass = myClass.getSuperclass();
                }
                id = new ObjectId();
            }
            Object object3 = _idLock;
            synchronized (object3) {
                id.setId(++_lastId);
            }
            id.setReference(obj);
            return id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ReferenceTypeId newReferenceTypeId(SoftReference ref) {
            Class clazz = (Class)ref.get();
            if (clazz == null) {
                return null;
            }
            ReferenceTypeId id = clazz.isArray() ? new ArrayReferenceTypeId() : (clazz.isInterface() ? new InterfaceReferenceTypeId() : new ClassReferenceTypeId());
            id.setReference(ref);
            Object object = _ridLock;
            synchronized (object) {
                id.setId(++_lastRid);
            }
            return id;
        }
    }

    class ReferenceKey
    extends SoftReference {
        private int _hash;

        public ReferenceKey(Object referent) {
            super(referent);
            this._hash = referent.hashCode();
        }

        public ReferenceKey(Object referent, ReferenceQueue queue) {
            super(referent, queue);
            this._hash = referent.hashCode();
        }

        public int hashCode() {
            return this._hash;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ReferenceKey) {
                ReferenceKey ref = (ReferenceKey)obj;
                if (this == obj) {
                    return true;
                }
                return ref.get() == this.get();
            }
            return false;
        }
    }
}

