/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.wizard.page;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.wizard.ClosableWizardDialog;

public class WizardUtil {
    private WizardUtil() {
    }

    public static IProject getServerProject() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        if (projects != null) {
            int size = projects.length;
            int i = 0;
            while (i < size) {
                if (ServerPlugin.getProjectProperties((IProject)projects[i]).isServerProject()) {
                    return projects[i];
                }
                ++i;
            }
        }
        String s = WizardUtil.findUnusedServerProjectName();
        return ResourcesPlugin.getWorkspace().getRoot().getProject(s);
    }

    protected static String findUnusedServerProjectName() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String name = NLS.bind((String)Messages.defaultServerProjectName, (Object)"");
        int count = 1;
        while (root.getProject(name).exists()) {
            name = NLS.bind((String)Messages.defaultServerProjectName, (Object)String.valueOf(++count));
        }
        return name;
    }

    public static IContainer findContainer(String containerName) {
        if (containerName == null || containerName.equals("")) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        try {
            IProject project = root.getProject(containerName);
            if (project != null && project.exists()) {
                return project;
            }
        }
        catch (Exception exception) {}
        try {
            IFolder folder = root.getFolder((IPath)new Path(containerName));
            if (folder != null && folder.exists()) {
                return folder;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    protected static IContainer findServerProjectContainer(IResource resource) {
        IContainer container = null;
        while (resource != null) {
            IFile file;
            if (container == null && resource instanceof IContainer) {
                container = (IContainer)resource;
            }
            if (resource instanceof IFile && ServerUIPlugin.findServer(file = (IFile)resource) != null) {
                return null;
            }
            if (resource instanceof IProject && resource.getProject().isOpen()) {
                return container;
            }
            resource = resource.getParent();
        }
        return null;
    }

    public static String getContainerText(IContainer container) {
        String name = container.getName();
        while (container != null && !(container instanceof IProject)) {
            container = container.getParent();
            name = String.valueOf(container.getName()) + "/" + name;
        }
        return name;
    }

    public static IContainer getSelectionContainer(IStructuredSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        Object obj = selection.getFirstElement();
        if (obj instanceof IResource) {
            return WizardUtil.findServerProjectContainer((IResource)obj);
        }
        return null;
    }

    public static String validateContainer(String name) {
        IContainer container = WizardUtil.findContainer(name);
        if (container == null || !container.exists()) {
            IStatus status = ResourcesPlugin.getWorkspace().validateName(name, 4);
            if (status.isOK()) {
                return null;
            }
            return status.getMessage();
        }
        String error = Messages.wizErrorInvalidFolder;
        try {
            IContainer temp;
            IProject project = null;
            if (container instanceof IProject) {
                project = (IProject)container;
            } else {
                temp = container.getParent();
                while (project == null && temp != null && !(temp instanceof IProject)) {
                    temp = temp.getParent();
                }
                if (temp != null && temp instanceof IProject) {
                    project = (IProject)temp;
                }
            }
            if (project != null && !project.isOpen()) {
                return Messages.wizErrorClosedProject;
            }
            if (project == null || !project.exists() || !project.isOpen()) {
                return error;
            }
            temp = container;
            while (temp != null && !(temp instanceof IProject)) {
                IFile file;
                if (temp instanceof IFile && ServerUIPlugin.findServer(file = (IFile)temp) != null) {
                    return error;
                }
                temp = temp.getParent();
            }
        }
        catch (Exception exception) {
            return error;
        }
        return null;
    }

    public static boolean promptForServerProjectCreation(Shell shell, String projectName) {
        String msg = NLS.bind((String)Messages.createServerProjectDialogMessage, (Object)projectName);
        return MessageDialog.openQuestion((Shell)shell, (String)Messages.createServerProjectDialogTitle, (String)msg);
    }

    public static void defaultSelect(IWizard wizard, IWizardPage page) {
        if (page.canFlipToNextPage() && page.getNextPage() != null) {
            wizard.getContainer().showPage(page.getNextPage());
        } else if (wizard.canFinish() && wizard.getContainer() instanceof ClosableWizardDialog) {
            ClosableWizardDialog dialog = (ClosableWizardDialog)wizard.getContainer();
            dialog.finishPressed();
        }
    }
}

