/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.util;

import java.util.Enumeration;
import java.util.Iterator;
import org.eclipse.wst.css.core.internal.Logger;
import org.eclipse.wst.css.core.internal.parser.CSSRegionUtil;
import org.eclipse.wst.css.core.internal.parserz.CSSTextToken;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegionList;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;

public class CSSUtil {
    public static void debugOut(String str) {
        Logger.log(2, "css warning: " + str);
    }

    public static String extractStringContents(String text) {
        return CSSUtil.stripQuotes(text);
    }

    public static String extractUriContents(String text) {
        String contents = text.trim();
        if (contents.toLowerCase().startsWith("url(") && contents.toLowerCase().endsWith(")")) {
            contents = contents.substring(4, contents.length() - 1);
        }
        contents = CSSUtil.stripQuotes(contents);
        return contents;
    }

    public static IStructuredDocumentRegion findNextSignificantNode(IStructuredDocumentRegion startNode) {
        if (startNode == null) {
            return null;
        }
        IStructuredDocumentRegion node = startNode.getNext();
        while (node != null) {
            String type = CSSUtil.getStructuredDocumentRegionType(node);
            if (type != "S" && type != "COMMENT" && type != "CDO" && type != "CDC") {
                return node;
            }
            node = node.getNext();
        }
        return null;
    }

    public static IStructuredDocumentRegion findNodeBackward(IStructuredDocumentRegion startNode, IStructuredDocumentRegion endNode, String type) {
        IStructuredDocumentRegion node = startNode;
        while (node != null) {
            if (node.getStartOffset() < endNode.getStartOffset()) {
                node = null;
                break;
            }
            if (CSSUtil.getStructuredDocumentRegionType(node) == type) break;
            node = node.getPrevious();
        }
        return node;
    }

    public static IStructuredDocumentRegion findNodeForward(IStructuredDocumentRegion startNode, IStructuredDocumentRegion endNode, String type) {
        IStructuredDocumentRegion node = startNode;
        while (node != null) {
            if (endNode.getStartOffset() < node.getStartOffset()) {
                node = null;
                break;
            }
            if (CSSUtil.getStructuredDocumentRegionType(node) == type) break;
            node = node.getNext();
        }
        return node;
    }

    public static IStructuredDocumentRegion findPreviousSignificantNode(IStructuredDocumentRegion startNode) {
        if (startNode == null) {
            return null;
        }
        IStructuredDocumentRegion node = startNode.getPrevious();
        while (node != null) {
            String type = CSSUtil.getStructuredDocumentRegionType(node);
            if (type != "S" && type != "COMMENT" && type != "CDO" && type != "CDC") {
                return node;
            }
            node = node.getPrevious();
        }
        return null;
    }

    public static String getClassString(Object object) {
        if (object == null) {
            return "null";
        }
        String name = object.getClass().toString();
        int lastPeriod = name.lastIndexOf(46);
        return name.substring(lastPeriod + 1);
    }

    public static String getStructuredDocumentRegionType(IStructuredDocumentRegion flatNode) {
        if (flatNode == null) {
            return "UNDEFINED";
        }
        ITextRegionList regions = flatNode.getRegions();
        if (regions == null || regions.size() == 0) {
            return "UNDEFINED";
        }
        ITextRegion region = regions.get(0);
        return region.getType();
    }

    public static int getLengthDifference(IStructuredDocumentRegionList newNodes, IStructuredDocumentRegionList oldNodes) {
        int newLen = CSSUtil.getTextLength(newNodes);
        int oldLen = CSSUtil.getTextLength(oldNodes);
        return newLen - oldLen;
    }

    public static String getRegionText(IStructuredDocumentRegion flatNode, ITextRegionList regions) {
        StringBuffer buf = new StringBuffer();
        if (regions != null) {
            Iterator i = regions.iterator();
            while (i.hasNext()) {
                ITextRegion region = (ITextRegion)i.next();
                if (region == null) continue;
                buf.append(flatNode.getText(region));
            }
        }
        return buf.toString();
    }

    public static int getTextLength(IStructuredDocumentRegionList nodes) {
        int length = 0;
        if (nodes != null) {
            Enumeration e = nodes.elements();
            while (e.hasMoreElements()) {
                IStructuredDocumentRegion flatNode = (IStructuredDocumentRegion)e.nextElement();
                if (flatNode == null) continue;
                length += flatNode.getText().length();
            }
        }
        return length;
    }

    public static boolean isLength(CSSTextToken token) {
        double number;
        if (token == null) {
            return false;
        }
        if (token.kind == "DECLARATION_VALUE_DIMENSION") {
            return true;
        }
        return token.kind == "DECLARATION_VALUE_NUMBER" && (number = Double.parseDouble(token.image)) == 0.0;
    }

    public static boolean isSelectorText(IStructuredDocumentRegion region) {
        String type = CSSUtil.getStructuredDocumentRegionType(region);
        if (CSSRegionUtil.isSelectorBegginingType(type)) {
            return true;
        }
        return type == "UNKNOWN";
    }

    public static String stripQuotes(String text) {
        if (text == null) {
            return null;
        }
        String contents = text.trim();
        if (2 <= contents.length()) {
            char first = contents.charAt(0);
            char last = contents.charAt(contents.length() - 1);
            if (first == '\"' && last == '\"' || first == '\'' && last == '\'') {
                contents = contents.substring(1, contents.length() - 1);
            }
        }
        return contents;
    }

    public static String detectQuote(String source, String defaultQuote) {
        if (source == null) {
            return defaultQuote;
        }
        int dIndex = source.indexOf("\"");
        int sIndex = source.indexOf("'");
        if (dIndex < 0 && sIndex < 0) {
            return defaultQuote;
        }
        if (dIndex < 0) {
            return "\"";
        }
        if (sIndex < 0) {
            return "'";
        }
        if (dIndex < sIndex) {
            return "'";
        }
        return "\"";
    }

    /*
     * Unable to fully structure code
     */
    public static void stripSurroundingSpace(ITextRegionList regions) {
        if (regions != null) ** GOTO lbl6
        return;
        while ((type = (region = regions.get(0)).getType()) == "S" || type == "COMMENT") {
            regions.remove(0);
lbl6:
            // 2 sources

            if (!regions.isEmpty()) continue;
        }
        while (!regions.isEmpty()) {
            region = regions.get(regions.size() - 1);
            type = region.getType();
            if (type != "S" && type != "COMMENT") break;
            regions.remove(region);
        }
    }
}

